/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.expression;

import java.util.ArrayList;
import java.util.List;
import org.ibatis.persist.criteria.CriteriaBuilder;
import org.ibatis.persist.criteria.Expression;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.Renderable;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.expression.ExpressionImpl;
import org.ibatis.persist.impl.expression.LiteralExpression;

public class CoalesceExpression<T>
extends ExpressionImpl<T>
implements CriteriaBuilder.Coalesce<T> {
    private final List<Expression<? extends T>> expressions;
    private Class<T> javaType;

    public CoalesceExpression(CriteriaBuilderImpl criteriaBuilder) {
        this(criteriaBuilder, (Class<T>)null);
    }

    public CoalesceExpression(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType) {
        super(criteriaBuilder, javaType);
        this.javaType = javaType;
        this.expressions = new ArrayList<Expression<? extends T>>();
    }

    @Override
    public Class<T> getJavaType() {
        return this.javaType;
    }

    @Override
    public CriteriaBuilder.Coalesce<T> value(T value) {
        return this.value((Expression<? extends T>)new LiteralExpression<T>(this.criteriaBuilder(), value));
    }

    @Override
    public CriteriaBuilder.Coalesce<T> value(Expression<? extends T> value) {
        this.expressions.add(value);
        if (this.javaType == null) {
            this.javaType = value.getJavaType();
        }
        return this;
    }

    public List<Expression<? extends T>> getExpressions() {
        return this.expressions;
    }

    @Override
    public void render(RenderingContext rc) {
        rc.append("coalesce(");
        String sep = "";
        for (Expression<T> expression : this.getExpressions()) {
            rc.append(sep);
            ((Renderable)((Object)expression)).render(rc);
            sep = ", ";
        }
        rc.append(")");
    }

    @Override
    public void renderProjection(RenderingContext rc) {
        this.render(rc);
        if (this.getAlias() != null) {
            rc.append(" AS ").append(this.getAlias());
        }
    }
}

