/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.expression;

import com.ibatis.sqlmap.engine.type.TypeHandler;
import java.util.ArrayList;
import java.util.List;
import org.ibatis.persist.criteria.CompoundSelection;
import org.ibatis.persist.criteria.Selection;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.Renderable;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.SelectionImplementor;
import org.ibatis.persist.impl.expression.SelectionImpl;

public class CompoundSelectionImpl<X>
extends SelectionImpl<X>
implements CompoundSelection<X> {
    private List<Selection<?>> selectionItems;

    public CompoundSelectionImpl(CriteriaBuilderImpl criteriaBuilder, Class<X> javaType, List<Selection<?>> selectionItems) {
        super(criteriaBuilder, javaType);
        this.selectionItems = selectionItems;
    }

    @Override
    public boolean isCompoundSelection() {
        return true;
    }

    @Override
    public List<Selection<?>> getCompoundSelectionItems() {
        return this.selectionItems;
    }

    @Override
    public List<TypeHandler<?>> getValueHandlers() {
        boolean foundHandlers = false;
        ArrayList valueHandlers = new ArrayList();
        for (Selection<?> selection : this.getCompoundSelectionItems()) {
            TypeHandler valueHandler = ((SelectionImplementor)selection).getValueHandler();
            valueHandlers.add(valueHandler);
            foundHandlers = foundHandlers || valueHandler != null;
        }
        return foundHandlers ? null : valueHandlers;
    }

    @Override
    public void render(RenderingContext rc) {
        throw new IllegalStateException("Compound selection cannot occur in expressions");
    }

    @Override
    public void renderProjection(RenderingContext rc) {
        String sep = "";
        for (Selection<?> selection : this.selectionItems) {
            rc.append(sep);
            ((Renderable)((Object)selection)).renderProjection(rc);
            sep = ", ";
        }
    }
}

