/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import org.ibatis.persist.criteria.Expression;
import org.ibatis.persist.criteria.Predicate;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.ExpressionImplementor;
import org.ibatis.persist.impl.expression.SelectionImpl;

public abstract class ExpressionImpl<T>
extends SelectionImpl<T>
implements ExpressionImplementor<T> {
    public ExpressionImpl(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType) {
        super(criteriaBuilder, javaType);
    }

    @Override
    public <X> Expression<X> as(Class<X> type) {
        ExpressionImpl x = this;
        x.setJavaType((Class)type);
        return x;
    }

    @Override
    public Predicate isNull() {
        return this.criteriaBuilder().isNull(this);
    }

    @Override
    public Predicate isNotNull() {
        return this.criteriaBuilder().isNotNull(this);
    }

    @Override
    public Predicate in(Object ... values) {
        return this.criteriaBuilder().in(this, values);
    }

    @Override
    public Predicate in(Expression<?> ... values) {
        return this.criteriaBuilder().in(this, (Expression<? extends T>[])values);
    }

    @Override
    public Predicate in(Collection<?> values) {
        return this.criteriaBuilder().in(this, values.toArray());
    }

    @Override
    public Predicate in(Expression<Collection<?>> values) {
        return this.criteriaBuilder().in(this, new Expression[]{values});
    }

    @Override
    public ExpressionImplementor<Long> asLong() {
        this.setJavaType((Class)Long.class);
        return this;
    }

    @Override
    public ExpressionImplementor<Integer> asInteger() {
        this.setJavaType((Class)Integer.class);
        return this;
    }

    @Override
    public ExpressionImplementor<Float> asFloat() {
        this.setJavaType((Class)Float.class);
        return this;
    }

    @Override
    public ExpressionImplementor<Double> asDouble() {
        this.setJavaType((Class)Double.class);
        return this;
    }

    @Override
    public ExpressionImplementor<BigDecimal> asBigDecimal() {
        this.setJavaType((Class)BigDecimal.class);
        return this;
    }

    @Override
    public ExpressionImplementor<BigInteger> asBigInteger() {
        this.setJavaType((Class)BigInteger.class);
        return this;
    }

    @Override
    public ExpressionImplementor<String> asString() {
        this.setJavaType((Class)String.class);
        return this;
    }
}

