/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.expression;

import com.ibatis.sqlmap.engine.type.TypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.ParameterInfo;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.expression.ExpressionImpl;

public class LiteralExpression<T>
extends ExpressionImpl<T>
implements ParameterInfo<T> {
    private T literal;

    public LiteralExpression(CriteriaBuilderImpl criteriaBuilder, T literal) {
        this(criteriaBuilder, LiteralExpression.determineClass(literal), literal);
    }

    private static Class<?> determineClass(Object literal) {
        return literal == null ? null : literal.getClass();
    }

    public LiteralExpression(CriteriaBuilderImpl criteriaBuilder, Class<T> type, T literal) {
        super(criteriaBuilder, type);
        this.literal = literal;
    }

    public T getLiteral() {
        return this.literal;
    }

    @Override
    public void render(RenderingContext rc) {
        rc.append(this);
    }

    @Override
    public void renderProjection(RenderingContext rc) {
        if (this.literal == null) {
            rc.append("null");
        } else if (TypeHandlerFactory.isCharacter(this.literal)) {
            rc.append('\'' + this.literal.toString() + '\'');
        } else {
            rc.append(this.literal.toString());
        }
        if (this.getAlias() != null) {
            rc.append(" AS ").append(this.getAlias());
        }
    }

    @Override
    public void setJavaType(Class targetType) {
        super.setJavaType(targetType);
        TypeHandler<Object> valueHandler = this.getValueHandler();
        if (valueHandler == null) {
            valueHandler = this.criteriaBuilder().getEntityManager().getDelegate().getTypeHandlerFactory().getTypeHandler(targetType);
            this.forceConversion(valueHandler);
        }
        if (valueHandler != null) {
            this.literal = valueHandler.valueOf(this.literal);
        }
    }

    @Override
    public T getParameterValue() {
        return this.literal;
    }

    @Override
    public void setParameterValue(T value) {
        this.literal = value;
    }

    @Override
    public Class<T> getParameterType() {
        return this.getJavaType();
    }

    public String toString() {
        return "?:" + this.literal;
    }

    @Override
    public boolean isBound() {
        return this.literal != ParameterInfo.None;
    }
}

