/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.expression;

import org.ibatis.persist.criteria.Expression;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.Renderable;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.expression.ExpressionImpl;
import org.ibatis.persist.impl.expression.LiteralExpression;

public class NullifExpression<T>
extends ExpressionImpl<T> {
    private final Expression<? extends T> primaryExpression;
    private final Expression<?> secondaryExpression;

    public NullifExpression(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType, Expression<? extends T> primaryExpression, Expression<?> secondaryExpression) {
        super(criteriaBuilder, NullifExpression.determineType(javaType, primaryExpression));
        this.primaryExpression = primaryExpression;
        this.secondaryExpression = secondaryExpression;
    }

    public NullifExpression(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType, Expression<? extends T> primaryExpression, Object secondaryExpression) {
        super(criteriaBuilder, NullifExpression.determineType(javaType, primaryExpression));
        this.primaryExpression = primaryExpression;
        this.secondaryExpression = new LiteralExpression<Object>(criteriaBuilder, secondaryExpression);
    }

    private static Class determineType(Class javaType, Expression primaryExpression) {
        return javaType != null ? javaType : primaryExpression.getJavaType();
    }

    public Expression<? extends T> getPrimaryExpression() {
        return this.primaryExpression;
    }

    public Expression<?> getSecondaryExpression() {
        return this.secondaryExpression;
    }

    @Override
    public void render(RenderingContext rc) {
        rc.append("nullif(");
        ((Renderable)((Object)this.getPrimaryExpression())).render(rc);
        rc.append(',');
        ((Renderable)((Object)this.getSecondaryExpression())).render(rc);
        rc.append(")");
    }

    @Override
    public void renderProjection(RenderingContext rc) {
        this.render(rc);
        if (this.getAlias() != null) {
            rc.append(" AS ").append(this.getAlias());
        }
    }
}

