/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.expression;

import org.ibatis.persist.criteria.ParameterExpression;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.ParameterInfo;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.expression.ExpressionImpl;

public class ParameterExpressionImpl<T>
extends ExpressionImpl<T>
implements ParameterExpression<T>,
ParameterInfo<T> {
    private final String name;
    private final Integer position;
    private T value = None;

    public ParameterExpressionImpl(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType, String name) {
        super(criteriaBuilder, javaType);
        this.name = name;
        this.position = null;
    }

    public ParameterExpressionImpl(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType, Integer position) {
        super(criteriaBuilder, javaType);
        this.name = null;
        this.position = position;
    }

    public ParameterExpressionImpl(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType) {
        super(criteriaBuilder, javaType);
        this.name = null;
        this.position = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public Class<T> getParameterType() {
        return this.getJavaType();
    }

    @Override
    public void render(RenderingContext rc) {
        rc.append(this);
    }

    @Override
    public void renderProjection(RenderingContext rc) {
        throw new IllegalStateException("Parameter cannot occur in select clause");
    }

    @Override
    public T getParameterValue() {
        return this.value;
    }

    @Override
    public void setParameterValue(T value) {
        this.value = value;
    }

    @Override
    public boolean isBound() {
        return this.value != ParameterInfo.None;
    }

    public String toString() {
        return "?" + (this.name != null ? this.name : String.valueOf(this.position)) + ":" + this.value;
    }
}

