/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.expression;

import com.ibatis.sqlmap.engine.type.TypeHandler;
import java.util.Collections;
import java.util.List;
import org.ibatis.persist.criteria.Selection;
import org.ibatis.persist.impl.AbstractNode;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.SelectionImplementor;

public abstract class SelectionImpl<X>
extends AbstractNode
implements SelectionImplementor<X> {
    final Class originalJavaType;
    private Class<X> javaType;
    private String alias;
    private TypeHandler<X> valueHandler;

    public SelectionImpl(CriteriaBuilderImpl criteriaBuilder, Class<X> javaType) {
        super(criteriaBuilder);
        this.originalJavaType = javaType;
        this.javaType = javaType;
    }

    @Override
    public Selection<X> alias(String alias) {
        this.setAlias(alias);
        return this;
    }

    @Override
    public boolean isCompoundSelection() {
        return false;
    }

    @Override
    public List<TypeHandler<?>> getValueHandlers() {
        TypeHandler<X> hander = this.getValueHandler();
        if (hander == null) {
            return null;
        }
        List<TypeHandler<?>> list = Collections.singletonList(hander);
        return list;
    }

    @Override
    public List<Selection<?>> getCompoundSelectionItems() {
        throw new IllegalStateException("Not a compound selection");
    }

    @Override
    public Class<X> getJavaType() {
        return this.javaType;
    }

    @Override
    public void setJavaType(Class targetType) {
        this.javaType = targetType;
        this.valueHandler = this.criteriaBuilder().getEntityManager().getDelegate().getTypeHandlerFactory().getTypeHandler(this.javaType);
    }

    protected void forceConversion(TypeHandler<X> valueHandler) {
        this.valueHandler = valueHandler;
    }

    @Override
    public TypeHandler<X> getValueHandler() {
        return this.valueHandler;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    protected void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public void renderFrom(RenderingContext rc) {
        throw new IllegalStateException("Selection cannot occur in from clause");
    }
}

