/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.expression;

import java.util.ArrayList;
import java.util.List;
import org.ibatis.persist.criteria.CriteriaBuilder;
import org.ibatis.persist.criteria.Expression;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.Renderable;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.expression.ExpressionImpl;
import org.ibatis.persist.impl.expression.LiteralExpression;

public class SimpleCaseExpression<C, R>
extends ExpressionImpl<R>
implements CriteriaBuilder.SimpleCase<C, R> {
    private Class<R> javaType;
    private final Expression<? extends C> expression;
    private List<WhenClause> whenClauses = new ArrayList<WhenClause>();
    private Expression<? extends R> otherwiseResult;

    public SimpleCaseExpression(CriteriaBuilderImpl criteriaBuilder, Class<R> javaType, Expression<? extends C> expression) {
        super(criteriaBuilder, javaType);
        this.javaType = javaType;
        this.expression = expression;
    }

    @Override
    public Expression<C> getExpression() {
        return this.expression;
    }

    @Override
    public CriteriaBuilder.SimpleCase<C, R> when(C condition, R result) {
        return this.when(condition, (Expression<? extends R>)this.buildLiteral(result));
    }

    private LiteralExpression<R> buildLiteral(R result) {
        Class<Object> type = result != null ? result.getClass() : this.getJavaType();
        return new LiteralExpression(this.criteriaBuilder(), type, result);
    }

    @Override
    public CriteriaBuilder.SimpleCase<C, R> when(C condition, Expression<? extends R> result) {
        WhenClause whenClause = new WhenClause(new LiteralExpression<C>(this.criteriaBuilder(), condition), result);
        this.whenClauses.add(whenClause);
        this.adjustJavaType(result);
        return this;
    }

    private void adjustJavaType(Expression<? extends R> exp) {
        if (this.javaType == null) {
            this.javaType = exp.getJavaType();
        }
    }

    @Override
    public Expression<R> otherwise(R result) {
        return this.otherwise((Expression<? extends R>)this.buildLiteral(result));
    }

    @Override
    public Expression<R> otherwise(Expression<? extends R> result) {
        this.otherwiseResult = result;
        this.adjustJavaType(result);
        return this;
    }

    public Expression<? extends R> getOtherwiseResult() {
        return this.otherwiseResult;
    }

    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    @Override
    public void render(RenderingContext rc) {
        rc.append("case ");
        ((Renderable)((Object)this.getExpression())).render(rc);
        for (WhenClause whenClause : this.getWhenClauses()) {
            rc.append(" when ");
            whenClause.getCondition().render(rc);
            rc.append(" then ");
            ((Renderable)((Object)whenClause.getResult())).render(rc);
        }
        rc.append(" else ");
        ((Renderable)((Object)this.getOtherwiseResult())).render(rc);
        rc.append(" end");
    }

    @Override
    public void renderProjection(RenderingContext rc) {
        this.render(rc);
        if (this.getAlias() != null) {
            rc.append(" AS ").append(this.getAlias());
        }
    }

    public class WhenClause {
        private final LiteralExpression<C> condition;
        private final Expression<? extends R> result;

        public WhenClause(LiteralExpression<C> condition, Expression<? extends R> result) {
            this.condition = condition;
            this.result = result;
        }

        public LiteralExpression<C> getCondition() {
            return this.condition;
        }

        public Expression<? extends R> getResult() {
            return this.result;
        }
    }
}

