/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.expression;

import org.ibatis.persist.criteria.Expression;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.Renderable;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.expression.ExpressionImpl;
import org.ibatis.persist.impl.expression.UnaryOperatorExpression;

public class UnaryArithmeticOperation<T>
extends ExpressionImpl<T>
implements UnaryOperatorExpression<T> {
    private final Operation operation;
    private final Expression<T> operand;

    public UnaryArithmeticOperation(CriteriaBuilderImpl criteriaBuilder, Operation operation, Expression<T> operand) {
        super(criteriaBuilder, operand.getJavaType());
        this.operation = operation;
        this.operand = operand;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public Expression<T> getOperand() {
        return this.operand;
    }

    @Override
    public void render(RenderingContext rc) {
        rc.append(this.getOperation() == Operation.UNARY_MINUS ? (char)'-' : '+');
        ((Renderable)((Object)this.getOperand())).render(rc);
    }

    @Override
    public void renderProjection(RenderingContext rc) {
        this.render(rc);
        if (this.getAlias() != null) {
            rc.append(" AS ").append(this.getAlias());
        }
    }

    public static enum Operation {
        UNARY_PLUS,
        UNARY_MINUS;

    }
}

