/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.function;

import org.ibatis.persist.criteria.Expression;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.function.ParameterizedFunctionExpression;

public class AggregationFunction<T>
extends ParameterizedFunctionExpression<T> {
    public AggregationFunction(CriteriaBuilderImpl criteriaBuilder, Class<T> returnType, String functionName, Expression<?> argument) {
        super(criteriaBuilder, returnType, functionName, argument);
    }

    @Override
    public boolean isAggregation() {
        return true;
    }

    @Override
    protected boolean isStandardJpaFunction() {
        return true;
    }

    public static class GREATEST<X extends Comparable<X>>
    extends AggregationFunction<X> {
        public static final String NAME = "max";

        public GREATEST(CriteriaBuilderImpl criteriaBuilder, Expression<X> expression) {
            super(criteriaBuilder, expression.getJavaType(), NAME, (Expression<?>)expression);
        }
    }

    public static class LEAST<X extends Comparable<X>>
    extends AggregationFunction<X> {
        public static final String NAME = "min";

        public LEAST(CriteriaBuilderImpl criteriaBuilder, Expression<X> expression) {
            super(criteriaBuilder, expression.getJavaType(), NAME, (Expression<?>)expression);
        }
    }

    public static class MAX<N extends Number>
    extends AggregationFunction<N> {
        public static final String NAME = "max";

        public MAX(CriteriaBuilderImpl criteriaBuilder, Expression<N> expression) {
            super(criteriaBuilder, expression.getJavaType(), NAME, (Expression<?>)expression);
        }
    }

    public static class MIN<N extends Number>
    extends AggregationFunction<N> {
        public static final String NAME = "min";

        public MIN(CriteriaBuilderImpl criteriaBuilder, Expression<N> expression) {
            super(criteriaBuilder, expression.getJavaType(), NAME, (Expression<?>)expression);
        }
    }

    public static class SUM<N extends Number>
    extends AggregationFunction<N> {
        public static final String NAME = "sum";

        public SUM(CriteriaBuilderImpl criteriaBuilder, Expression<N> expression) {
            super(criteriaBuilder, expression.getJavaType(), NAME, (Expression<?>)expression);
            this.setJavaType(expression.getJavaType());
        }

        public SUM(CriteriaBuilderImpl criteriaBuilder, Expression<? extends Number> expression, Class<N> returnType) {
            super(criteriaBuilder, returnType, NAME, (Expression<?>)expression);
            this.setJavaType((Class)returnType);
        }
    }

    public static class AVG
    extends AggregationFunction<Double> {
        public static final String NAME = "avg";

        public AVG(CriteriaBuilderImpl criteriaBuilder, Expression<? extends Number> expression) {
            super(criteriaBuilder, Double.class, NAME, (Expression<?>)expression);
        }
    }

    public static class COUNT
    extends AggregationFunction<Long> {
        public static final String NAME = "count";
        private final boolean distinct;

        public COUNT(CriteriaBuilderImpl criteriaBuilder, Expression<?> expression, boolean distinct) {
            super(criteriaBuilder, Long.class, NAME, expression);
            this.distinct = distinct;
        }

        @Override
        protected void renderArguments(RenderingContext rc) {
            if (this.isDistinct()) {
                rc.append("distinct ");
            }
            super.renderArguments(rc);
        }

        public boolean isDistinct() {
            return this.distinct;
        }
    }
}

