/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.function;

import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.expression.ExpressionImpl;
import org.ibatis.persist.impl.function.FunctionExpression;

public class BasicFunctionExpression<X>
extends ExpressionImpl<X>
implements FunctionExpression<X> {
    private final String functionName;

    public BasicFunctionExpression(CriteriaBuilderImpl criteriaBuilder, Class<X> javaType, String functionName) {
        super(criteriaBuilder, javaType);
        this.functionName = functionName;
    }

    protected static int properSize(int number) {
        return number + (int)((double)number * 0.75) + 1;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public boolean isAggregation() {
        return false;
    }

    @Override
    public void render(RenderingContext rc) {
        rc.append(this.getFunctionName()).append("()");
    }

    @Override
    public void renderProjection(RenderingContext rc) {
        this.render(rc);
        if (this.getAlias() != null) {
            rc.append(" AS ").append(this.getAlias());
        }
    }
}

