/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.function;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.ibatis.persist.criteria.Expression;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.Renderable;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.function.BasicFunctionExpression;
import org.ibatis.persist.impl.function.FunctionExpression;

public class ParameterizedFunctionExpression<X>
extends BasicFunctionExpression<X>
implements FunctionExpression<X> {
    public static List<String> STANDARD_JPA_FUNCTION_NAMES = Arrays.asList("CONCAT", "SUBSTRING", "TRIM", "UPPER", "LOWER", "LOCATE", "LENGTH", "ABS", "SQRT", "MOD", "SIZE", "INDEX", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP");
    private final List<Expression<?>> argumentExpressions;
    private final boolean isStandardJpaFunction;

    public ParameterizedFunctionExpression(CriteriaBuilderImpl criteriaBuilder, Class<X> javaType, String functionName, List<Expression<?>> argumentExpressions) {
        super(criteriaBuilder, javaType, functionName);
        this.argumentExpressions = argumentExpressions;
        this.isStandardJpaFunction = STANDARD_JPA_FUNCTION_NAMES.contains(functionName.toUpperCase(Locale.ROOT));
    }

    public ParameterizedFunctionExpression(CriteriaBuilderImpl criteriaBuilder, Class<X> javaType, String functionName, Expression<?> ... argumentExpressions) {
        super(criteriaBuilder, javaType, functionName);
        this.argumentExpressions = Arrays.asList(argumentExpressions);
        this.isStandardJpaFunction = STANDARD_JPA_FUNCTION_NAMES.contains(functionName.toUpperCase(Locale.ROOT));
    }

    protected boolean isStandardJpaFunction() {
        return this.isStandardJpaFunction;
    }

    protected static int properSize(int number) {
        return number + (int)((double)number * 0.75) + 1;
    }

    public List<Expression<?>> getArgumentExpressions() {
        return this.argumentExpressions;
    }

    @Override
    public void render(RenderingContext rc) {
        if (this.isStandardJpaFunction()) {
            rc.append(this.getFunctionName()).append("(");
        } else {
            rc.append("function('").append(this.getFunctionName()).append("', ");
        }
        this.renderArguments(rc);
        rc.append(')');
    }

    protected void renderArguments(RenderingContext rc) {
        String sep = "";
        for (Expression<?> argument : this.argumentExpressions) {
            rc.append(sep);
            ((Renderable)((Object)argument)).render(rc);
            sep = ", ";
        }
    }
}

