/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.path;

import org.ibatis.persist.criteria.Expression;
import org.ibatis.persist.criteria.JoinType;
import org.ibatis.persist.criteria.Predicate;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.FromImplementor;
import org.ibatis.persist.impl.JoinImplementor;
import org.ibatis.persist.impl.QueryStructure;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.path.AbstractFromImpl;
import org.ibatis.persist.impl.predicate.AbstractPredicateImpl;

public class JoinImpl
extends AbstractFromImpl
implements JoinImplementor {
    private final JoinType joinType;
    private FromImplementor left;
    private FromImplementor right;
    private Predicate suppliedJoinCondition;

    public JoinImpl(CriteriaBuilderImpl criteriaBuilder, QueryStructure queryStructure, FromImplementor left, FromImplementor right, JoinType jt) {
        super(criteriaBuilder, queryStructure);
        this.left = left;
        this.right = right;
        this.joinType = jt;
    }

    @Override
    public JoinType getJoinType() {
        return this.joinType;
    }

    private String renderJoinType(JoinType joinType) {
        switch (joinType) {
            case LEFT: {
                return " left join ";
            }
            case RIGHT: {
                return " right join ";
            }
        }
        return " join ";
    }

    @Override
    public void renderFrom(RenderingContext rc) {
        this.getLeft().renderFrom(rc);
        rc.append(this.renderJoinType(this.joinType));
        this.getRight().renderFrom(rc);
        if (this.suppliedJoinCondition != null) {
            rc.append(" on ");
            ((AbstractPredicateImpl)this.suppliedJoinCondition).render(rc);
        }
    }

    @Override
    public JoinImplementor on(Predicate ... restrictions) {
        this.suppliedJoinCondition = null;
        if (restrictions != null && restrictions.length > 0) {
            this.suppliedJoinCondition = this.criteriaBuilder().and(restrictions);
        }
        return this;
    }

    @Override
    public JoinImplementor on(Expression<Boolean> restriction) {
        this.suppliedJoinCondition = this.criteriaBuilder().wrap(restriction);
        return this;
    }

    @Override
    public Predicate getOn() {
        return this.suppliedJoinCondition;
    }

    @Override
    public FromImplementor getLeft() {
        return this.left;
    }

    @Override
    public FromImplementor getRight() {
        return this.right;
    }

    @Override
    protected RuntimeException illegalJoin() {
        return new IllegalArgumentException("illegal join");
    }
}

