/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.predicate;

import org.ibatis.persist.criteria.Expression;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.Renderable;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.predicate.AbstractSimplePredicate;

public class BooleanAssertionPredicate
extends AbstractSimplePredicate {
    private final Expression<Boolean> expression;
    private final Boolean assertedValue;

    public BooleanAssertionPredicate(CriteriaBuilderImpl criteriaBuilder, Expression<Boolean> expression, Boolean assertedValue) {
        super(criteriaBuilder);
        this.expression = expression;
        this.assertedValue = assertedValue;
    }

    public Expression<Boolean> getExpression() {
        return this.expression;
    }

    public Boolean getAssertedValue() {
        return this.assertedValue;
    }

    @Override
    public void render(boolean isNegated, RenderingContext rc) {
        String operator = isNegated ? " <> " : " = ";
        String assertionLiteral = this.assertedValue != false ? "true" : "false";
        ((Renderable)((Object)this.expression)).render(rc);
        rc.append(operator).append(assertionLiteral);
    }
}

