/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.predicate;

import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import org.ibatis.persist.criteria.Expression;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.Renderable;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.expression.BinaryOperatorExpression;
import org.ibatis.persist.impl.expression.LiteralExpression;
import org.ibatis.persist.impl.predicate.AbstractSimplePredicate;

public class ComparisonPredicate
extends AbstractSimplePredicate
implements BinaryOperatorExpression<Boolean> {
    private final ComparisonOperator comparisonOperator;
    private final Expression<?> leftHandSide;
    private final Expression<?> rightHandSide;

    public ComparisonPredicate(CriteriaBuilderImpl criteriaBuilder, ComparisonOperator comparisonOperator, Expression<?> leftHandSide, Expression<?> rightHandSide) {
        super(criteriaBuilder);
        this.comparisonOperator = comparisonOperator;
        this.leftHandSide = leftHandSide;
        this.rightHandSide = rightHandSide;
    }

    public ComparisonPredicate(CriteriaBuilderImpl criteriaBuilder, ComparisonOperator comparisonOperator, Expression<?> leftHandSide, Object rightHandSide) {
        super(criteriaBuilder);
        this.comparisonOperator = comparisonOperator;
        this.leftHandSide = leftHandSide;
        this.rightHandSide = TypeHandlerFactory.isNumeric(leftHandSide.getJavaType()) ? new LiteralExpression<Object>(criteriaBuilder, leftHandSide.getJavaType(), rightHandSide) : new LiteralExpression<Object>(criteriaBuilder, rightHandSide);
    }

    public <N extends Number> ComparisonPredicate(CriteriaBuilderImpl criteriaBuilder, ComparisonOperator comparisonOperator, Expression<N> leftHandSide, Number rightHandSide) {
        super(criteriaBuilder);
        this.comparisonOperator = comparisonOperator;
        this.leftHandSide = leftHandSide;
        this.rightHandSide = new LiteralExpression<Number>(criteriaBuilder, rightHandSide);
    }

    public ComparisonOperator getComparisonOperator() {
        return this.getComparisonOperator(this.isNegated());
    }

    public ComparisonOperator getComparisonOperator(boolean isNegated) {
        return isNegated ? this.comparisonOperator.negated() : this.comparisonOperator;
    }

    @Override
    public Expression getLeftHandOperand() {
        return this.leftHandSide;
    }

    @Override
    public Expression getRightHandOperand() {
        return this.rightHandSide;
    }

    @Override
    public void render(boolean isNegated, RenderingContext rc) {
        ((Renderable)((Object)this.getLeftHandOperand())).render(rc);
        rc.append(this.getComparisonOperator(isNegated).rendered());
        ((Renderable)((Object)this.getRightHandOperand())).render(rc);
    }

    public static enum ComparisonOperator {
        EQUAL{

            @Override
            public ComparisonOperator negated() {
                return NOT_EQUAL;
            }

            @Override
            public String rendered() {
                return " = ";
            }
        }
        ,
        NOT_EQUAL{

            @Override
            public ComparisonOperator negated() {
                return EQUAL;
            }

            @Override
            public String rendered() {
                return " <> ";
            }
        }
        ,
        LESS_THAN{

            @Override
            public ComparisonOperator negated() {
                return GREATER_THAN_OR_EQUAL;
            }

            @Override
            public String rendered() {
                return " < ";
            }
        }
        ,
        LESS_THAN_OR_EQUAL{

            @Override
            public ComparisonOperator negated() {
                return GREATER_THAN;
            }

            @Override
            public String rendered() {
                return " <= ";
            }
        }
        ,
        GREATER_THAN{

            @Override
            public ComparisonOperator negated() {
                return LESS_THAN_OR_EQUAL;
            }

            @Override
            public String rendered() {
                return " > ";
            }
        }
        ,
        GREATER_THAN_OR_EQUAL{

            @Override
            public ComparisonOperator negated() {
                return LESS_THAN;
            }

            @Override
            public String rendered() {
                return " >= ";
            }
        };


        public abstract ComparisonOperator negated();

        public abstract String rendered();
    }
}

