/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.predicate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ibatis.persist.criteria.Expression;
import org.ibatis.persist.criteria.Predicate;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.Renderable;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.predicate.AbstractPredicateImpl;
import org.ibatis.persist.impl.predicate.NegatedPredicateWrapper;
import org.ibatis.persist.impl.predicate.PredicateImplementor;

public class CompoundPredicate
extends AbstractPredicateImpl {
    private Predicate.BooleanOperator operator;
    private final List<Expression<Boolean>> expressions = new ArrayList<Expression<Boolean>>();

    public CompoundPredicate(CriteriaBuilderImpl criteriaBuilder, Predicate.BooleanOperator operator) {
        super(criteriaBuilder);
        this.operator = operator;
    }

    public CompoundPredicate(CriteriaBuilderImpl criteriaBuilder, Predicate.BooleanOperator operator, Expression<Boolean> ... expressions) {
        this(criteriaBuilder, operator);
        this.applyExpressions(expressions);
    }

    public CompoundPredicate(CriteriaBuilderImpl criteriaBuilder, Predicate.BooleanOperator operator, List<Expression<Boolean>> expressions) {
        this(criteriaBuilder, operator);
        this.applyExpressions(expressions);
    }

    private void applyExpressions(Expression<Boolean> ... expressions) {
        this.applyExpressions(Arrays.asList(expressions));
    }

    private void applyExpressions(List<Expression<Boolean>> expressions) {
        this.expressions.clear();
        this.expressions.addAll(expressions);
    }

    @Override
    public Predicate.BooleanOperator getOperator() {
        return this.operator;
    }

    @Override
    public List<Expression<Boolean>> getExpressions() {
        return this.expressions;
    }

    @Override
    public void render(RenderingContext rc) {
        this.render(this.isNegated(), rc);
    }

    @Override
    public boolean isJunction() {
        return true;
    }

    @Override
    public void render(boolean isNegated, RenderingContext rc) {
        CompoundPredicate.render(this, rc);
    }

    @Override
    public void renderProjection(RenderingContext rc) {
        this.render(rc);
    }

    @Override
    public Predicate not() {
        return new NegatedPredicateWrapper(this);
    }

    public static Predicate.BooleanOperator reverseOperator(Predicate.BooleanOperator operator) {
        return operator == Predicate.BooleanOperator.AND ? Predicate.BooleanOperator.OR : Predicate.BooleanOperator.AND;
    }

    public static void render(PredicateImplementor predicate, RenderingContext rc) {
        if (!predicate.isJunction()) {
            throw new IllegalStateException("CompoundPredicate.render should only be used to render junctions");
        }
        if (predicate.getExpressions().isEmpty()) {
            boolean implicitTrue = predicate.getOperator() == Predicate.BooleanOperator.AND;
            rc.append(implicitTrue ? "1=1" : "0=1");
            return;
        }
        if (predicate.getExpressions().size() == 1) {
            ((Renderable)((Object)predicate.getExpressions().get(0))).render(rc);
            return;
        }
        String sep = "";
        for (Expression<Boolean> expression : predicate.getExpressions()) {
            rc.append(sep).append("( ");
            ((Renderable)((Object)expression)).render(rc);
            rc.append(" )");
            sep = CompoundPredicate.operatorTextWithSeparator(predicate.getOperator());
        }
    }

    private static String operatorTextWithSeparator(Predicate.BooleanOperator operator) {
        return operator == Predicate.BooleanOperator.AND ? " and " : " or ";
    }
}

