/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.impl.predicate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.ibatis.persist.criteria.CriteriaBuilder;
import org.ibatis.persist.criteria.Expression;
import org.ibatis.persist.criteria.Subquery;
import org.ibatis.persist.impl.CriteriaBuilderImpl;
import org.ibatis.persist.impl.Renderable;
import org.ibatis.persist.impl.RenderingContext;
import org.ibatis.persist.impl.expression.LiteralExpression;
import org.ibatis.persist.impl.predicate.AbstractSimplePredicate;

public class InPredicate<T>
extends AbstractSimplePredicate
implements CriteriaBuilder.In<T> {
    private final Expression<? extends T> expression;
    private final List<Expression<? extends T>> values;

    public InPredicate(CriteriaBuilderImpl criteriaBuilder, Expression<? extends T> expression) {
        this(criteriaBuilder, expression, (List<Expression<? extends T>>)new ArrayList<Expression<? extends T>>());
    }

    public InPredicate(CriteriaBuilderImpl criteriaBuilder, Expression<? extends T> expression, Expression<? extends T> ... values) {
        this(criteriaBuilder, expression, Arrays.asList(values));
    }

    public InPredicate(CriteriaBuilderImpl criteriaBuilder, Expression<? extends T> expression, List<Expression<? extends T>> values) {
        super(criteriaBuilder);
        this.expression = expression;
        this.values = values;
    }

    public InPredicate(CriteriaBuilderImpl criteriaBuilder, Expression<? extends T> expression, T ... values) {
        this(criteriaBuilder, expression, (Collection<? extends T>)Arrays.asList(values));
    }

    public InPredicate(CriteriaBuilderImpl criteriaBuilder, Expression<? extends T> expression, Collection<T> values) {
        super(criteriaBuilder);
        this.expression = expression;
        this.values = new ArrayList<Expression<? extends T>>(values.size());
        for (T value : values) {
            this.values.add(new LiteralExpression<T>(criteriaBuilder, value));
        }
    }

    @Override
    public Expression<T> getExpression() {
        return this.expression;
    }

    public Expression<? extends T> getExpressionInternal() {
        return this.expression;
    }

    public List<Expression<? extends T>> getValues() {
        return this.values;
    }

    @Override
    public InPredicate<T> value(T value) {
        return this.value(new LiteralExpression<T>(this.criteriaBuilder(), value));
    }

    @Override
    public InPredicate<T> value(Expression<? extends T> value) {
        this.values.add(value);
        return this;
    }

    @Override
    public void render(boolean isNegated, RenderingContext rc) {
        boolean isInSubqueryPredicate;
        ((Renderable)((Object)this.getExpression())).render(rc);
        if (isNegated) {
            rc.append(" not");
        }
        rc.append(" in ");
        boolean bl = isInSubqueryPredicate = this.getValues().size() == 1 && Subquery.class.isInstance(this.getValues().get(0));
        if (isInSubqueryPredicate) {
            ((Renderable)((Object)this.getValues().get(0))).render(rc);
        } else {
            rc.append('(');
            String sep = "";
            for (Expression<T> value : this.getValues()) {
                rc.append(sep);
                ((Renderable)((Object)value)).render(rc);
                sep = ", ";
            }
            rc.append(')');
        }
    }
}

