/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.persist.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import org.ibatis.cglib.Invoker;

public class Attribute<E, P> {
    final String name;
    final String column;
    final Class<?> type;
    final Invoker getter;
    final Invoker setter;

    public Attribute(String name, String column, Class<?> type, Invoker getter, Invoker setter) {
        this.name = name;
        this.column = column;
        this.type = type;
        this.getter = getter;
        this.setter = setter;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T t = this.getter.getAnnotation(annotationClass);
        if (t == null) {
            t = this.setter.getAnnotation(annotationClass);
        }
        return t;
    }

    public String getName() {
        return this.name;
    }

    public String getColumn() {
        return this.column;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Object getValue(E entity) {
        try {
            return this.getter.invoke(entity, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setValue(E entity, P val) {
        try {
            this.setter.invoke(entity, val);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

