/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.spring;

import com.ibatis.common.logging.ILog;
import com.ibatis.common.logging.ILogFactory;
import com.ibatis.common.resources.Resources;
import com.ibatis.common.xml.NodeletException;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapConfigParser;
import com.ibatis.sqlmap.engine.builder.xml.SqlMapParser;
import com.ibatis.sqlmap.engine.builder.xml.XmlParserState;
import com.ibatis.sqlmap.engine.config.SqlMapConfiguration;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.transaction.TransactionConfig;
import com.ibatis.sqlmap.engine.transaction.TransactionManager;
import com.ibatis.sqlmap.engine.transaction.external.ExternalTransactionConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.ibatis.client.SqlMapClient;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.util.ObjectUtils;

public class SqlMapClientFactoryBean
implements FactoryBean<SqlMapClient>,
InitializingBean {
    private static final ILog log = ILogFactory.getLog(SqlMapClientFactoryBean.class);
    private static final ThreadLocal<LobHandler> configTimeLobHandlerHolder = new ThreadLocal();
    private Resource[] configLocations;
    private Resource[] mappingLocations;
    private Properties sqlMapClientProperties;
    private DataSource dataSource;
    private boolean useTransactionAwareDataSource = true;
    private Class<?> transactionConfigClass = ExternalTransactionConfig.class;
    private Properties transactionConfigProperties = new Properties();
    private LobHandler lobHandler;
    private SqlMapClient sqlMapClient;
    private String dialect;

    public static LobHandler getConfigTimeLobHandler() {
        return configTimeLobHandlerHolder.get();
    }

    public SqlMapClientFactoryBean() {
        this.transactionConfigProperties.setProperty("SetAutoCommitAllowed", "false");
    }

    public void setConfigLocation(Resource configLocation) {
        Resource[] resourceArray;
        if (configLocation != null) {
            Resource[] resourceArray2 = new Resource[1];
            resourceArray = resourceArray2;
            resourceArray2[0] = configLocation;
        } else {
            resourceArray = null;
        }
        this.configLocations = resourceArray;
    }

    public void setConfigLocations(Resource[] configLocations) {
        this.configLocations = configLocations;
    }

    public void setMappingLocations(Resource[] mappingLocations) {
        this.mappingLocations = mappingLocations;
    }

    public void setSqlMapClientProperties(Properties sqlMapClientProperties) {
        this.sqlMapClientProperties = sqlMapClientProperties;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public void setUseTransactionAwareDataSource(boolean useTransactionAwareDataSource) {
        this.useTransactionAwareDataSource = useTransactionAwareDataSource;
    }

    public void setTransactionConfigClass(Class<?> transactionConfigClass) {
        if (transactionConfigClass == null || !TransactionConfig.class.isAssignableFrom(transactionConfigClass)) {
            throw new IllegalArgumentException("Invalid transactionConfigClass: does not implement com.ibatis.sqlmap.engine.transaction.TransactionConfig");
        }
        this.transactionConfigClass = transactionConfigClass;
    }

    public void setTransactionConfigProperties(Properties transactionConfigProperties) {
        this.transactionConfigProperties = transactionConfigProperties;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (this.lobHandler != null) {
            configTimeLobHandlerHolder.set(this.lobHandler);
        }
        try {
            SqlMapClientImpl impl = this.buildSqlMapClient(this.configLocations, this.mappingLocations, this.sqlMapClientProperties);
            this.sqlMapClient = impl;
            if (this.dataSource != null) {
                TransactionConfig transactionConfig = (TransactionConfig)this.transactionConfigClass.newInstance();
                DataSource dataSourceToUse = this.dataSource;
                if (this.useTransactionAwareDataSource && !(this.dataSource instanceof TransactionAwareDataSourceProxy)) {
                    dataSourceToUse = new TransactionAwareDataSourceProxy(this.dataSource);
                }
                impl.setRealDataSource(this.dataSource);
                transactionConfig.setDataSource(dataSourceToUse);
                transactionConfig.setProperties(this.transactionConfigProperties);
                this.applyTransactionConfig(impl, transactionConfig);
            }
        }
        finally {
            if (this.lobHandler != null) {
                configTimeLobHandlerHolder.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SqlMapClientImpl buildSqlMapClient(Resource[] configLocations, Resource[] mappingLocations, Properties properties) throws IOException {
        if (ObjectUtils.isEmpty((Object[])configLocations)) {
            throw new IllegalArgumentException("At least 1 'configLocation' entry is required");
        }
        SqlMapClientImpl client = null;
        SqlMapConfigParser configParser = new SqlMapConfigParser(this.dialect);
        XmlParserState xmlParserState = configParser.getState();
        synchronized (xmlParserState) {
            properties = this.getProperties(properties);
            for (Resource configLocation : configLocations) {
                InputStream is = configLocation.getInputStream();
                try {
                    client = (SqlMapClientImpl)configParser.parse(is, properties);
                }
                catch (RuntimeException ex) {
                    log.error("Failed to parse config resource: " + configLocation, ex);
                    throw new NestedIOException("Failed to parse config resource: " + configLocation, (Throwable)ex);
                }
            }
            if (mappingLocations != null) {
                boolean needRefresh = false;
                SqlMapParser mapParser = new SqlMapParser(configParser.getState());
                SqlMapConfiguration config = configParser.getState().getConfig();
                for (Resource res : mappingLocations) {
                    try {
                        String str = res.toString();
                        config.getErrorContext().setResource(SqlMapClientFactoryBean.getResourcePath(res));
                        mapParser.parse(str, res.getInputStream());
                        needRefresh = true;
                    }
                    catch (NodeletException ex) {
                        log.error("Failed to parse mapping resource: " + res, ex);
                        throw new NestedIOException("Failed to parse mapping resource: " + res, (Throwable)ex);
                    }
                }
                if (needRefresh) {
                    config.finalizeSqlMapConfig();
                }
            }
        }
        return client;
    }

    static String getResourcePath(Resource res) {
        if (res instanceof ContextResource) {
            return ((ContextResource)res).getPathWithinContext();
        }
        if (res instanceof ClassPathResource) {
            ClassPathResource cpRes = (ClassPathResource)res;
            return cpRes.getPath();
        }
        if (res instanceof FileSystemResource) {
            FileSystemResource cpRes = (FileSystemResource)res;
            return cpRes.getPath();
        }
        try {
            String path;
            int idx;
            URL url = res.getURL();
            if (url != null && (idx = (path = url.toString()).lastIndexOf(33)) > 0) {
                return path.substring(idx + 1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (res.getFilename() != null) {
            return res.getFilename();
        }
        return res.getDescription();
    }

    protected Properties getProperties(Properties props) {
        Properties p = new Properties();
        if (props != null) {
            p.putAll((Map<?, ?>)props);
        }
        p.putAll((Map<?, ?>)Resources.getIbatisIniProperties());
        return p;
    }

    protected void applyTransactionConfig(ExtendedSqlMapClient sqlMapClient, TransactionConfig transactionConfig) {
        sqlMapClient.getDelegate().setTxManager(new TransactionManager(transactionConfig));
    }

    public SqlMapClient getObject() {
        return this.sqlMapClient;
    }

    public Class<? extends SqlMapClient> getObjectType() {
        return this.sqlMapClient != null ? this.sqlMapClient.getClass() : SqlMapClient.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

