/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.spring;

import com.ibatis.common.ArrayMap;
import com.ibatis.sqlmap.client.SqlMapExecutor;
import com.ibatis.sqlmap.client.SqlMapSession;
import com.ibatis.sqlmap.client.event.RowHandler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.ibatis.client.Dialect;
import org.ibatis.client.SqlMapClient;
import org.ibatis.persist.criteria.CriteriaBuilder;
import org.ibatis.persist.criteria.CriteriaDelete;
import org.ibatis.persist.criteria.CriteriaQuery;
import org.ibatis.persist.criteria.CriteriaUpdate;
import org.ibatis.spring.SqlMapClientCallback;
import org.ibatis.spring.SqlMapClientOperations;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.JdbcUpdateAffectedIncorrectNumberOfRowsException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.JdbcAccessor;
import org.springframework.util.Assert;

public class SqlMapClientTemplate
extends JdbcAccessor
implements SqlMapClientOperations {
    private SqlMapClient sqlMapClient;

    public SqlMapClientTemplate() {
    }

    public SqlMapClientTemplate(SqlMapClient sqlMapClient) {
        this.setSqlMapClient(sqlMapClient);
        this.afterPropertiesSet();
    }

    public SqlMapClientTemplate(DataSource dataSource, SqlMapClient sqlMapClient) {
        this.setDataSource(dataSource);
        this.setSqlMapClient(sqlMapClient);
        this.afterPropertiesSet();
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    public SqlMapClient getSqlMapClient() {
        return this.sqlMapClient;
    }

    public DataSource getDataSource() {
        DataSource ds = super.getDataSource();
        return ds != null ? ds : this.sqlMapClient.getDataSource();
    }

    public void afterPropertiesSet() {
        if (this.sqlMapClient == null) {
            throw new IllegalArgumentException("Property 'sqlMapClient' is required");
        }
        super.afterPropertiesSet();
    }

    /*
     * Loose catch block
     */
    public <T> T execute(SqlMapClientCallback<T> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Assert.notNull((Object)this.sqlMapClient, (String)"No SqlMapClient specified");
        SqlMapSession session = this.sqlMapClient.openSession();
        if (this.logger.isTraceEnabled()) {
            this.logger.debug((Object)("Opened SqlMapSession [" + session + "] for iBATIS operation"));
        }
        Connection ibatisCon = null;
        try {
            Connection springCon = null;
            DataSource dataSource = this.getDataSource();
            boolean transactionAware = dataSource instanceof TransactionAwareDataSourceProxy;
            try {
                ibatisCon = session.getCurrentConnection();
                if (ibatisCon == null) {
                    springCon = transactionAware ? dataSource.getConnection() : DataSourceUtils.doGetConnection((DataSource)dataSource);
                    session.setUserConnection(springCon);
                    if (this.logger.isTraceEnabled()) {
                        this.logger.debug((Object)("Obtained JDBC Connection [" + springCon + "] for iBATIS operation"));
                    }
                } else if (this.logger.isTraceEnabled()) {
                    this.logger.debug((Object)("Reusing JDBC Connection [" + ibatisCon + "] for iBATIS operation"));
                }
            }
            catch (SQLException ex) {
                throw new CannotGetJdbcConnectionException("Could not get JDBC Connection", ex);
            }
            try {
                T ex = action.doInSqlMapClient(session);
            }
            catch (SQLException ex) {
                throw this.getExceptionTranslator().translate("SqlMapClient operation", null, ex);
            }
            finally {
                try {
                    if (springCon != null) {
                        if (transactionAware) {
                            springCon.close();
                        } else {
                            DataSourceUtils.doReleaseConnection((Connection)springCon, (DataSource)dataSource);
                        }
                    }
                }
                catch (Throwable ex) {
                    this.logger.debug((Object)"Could not close JDBC Connection", ex);
                }
            }
            return ex;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (ibatisCon == null) {
                session.close();
            }
        }
    }

    @Override
    public <T> T queryForObject(String id) throws DataAccessException {
        return this.queryForObject(id, null);
    }

    @Override
    public <T> T queryForObject(final String id, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<T>(){

            @Override
            public T doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForObject(id, parameterObject);
            }
        });
    }

    @Override
    public <T> T queryForObject(final String id, final Object parameterObject, final Object resultObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<T>(){

            @Override
            public T doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForObject(id, parameterObject, resultObject);
            }
        });
    }

    @Override
    public <T> List<T> queryForList(String id) throws DataAccessException {
        return this.queryForList(id, null);
    }

    @Override
    public <T> List<T> queryForList(final String id, final Object parameterObject) throws DataAccessException {
        return (List)this.execute(new SqlMapClientCallback<List<T>>(){

            @Override
            public List<T> doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForList(id, parameterObject);
            }
        });
    }

    @Override
    public <T> List<T> queryForList(String id, int skipResults, int maxResults) throws DataAccessException {
        return this.queryForList(id, null, skipResults, maxResults);
    }

    @Override
    public <T> List<T> queryForList(final String id, final Object parameterObject, final int skipResults, final int maxResults) throws DataAccessException {
        return (List)this.execute(new SqlMapClientCallback<List<T>>(){

            @Override
            public List<T> doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForList(id, parameterObject, skipResults, maxResults);
            }
        });
    }

    @Override
    public void queryWithRowHandler(String id, RowHandler rowHandler) throws DataAccessException {
        this.queryWithRowHandler(id, (Object)null, rowHandler);
    }

    @Override
    public void queryWithRowHandler(final String id, final Object parameterObject, final RowHandler rowHandler) throws DataAccessException {
        this.execute(new SqlMapClientCallback<Object>(){

            @Override
            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                executor.queryWithRowHandler(id, parameterObject, rowHandler);
                return null;
            }
        });
    }

    @Override
    public void queryWithRowHandler(String id, RowHandler rowHandler, Object ... args) throws DataAccessException {
        this.queryWithRowHandler(id, this.toParameter(args), rowHandler);
    }

    @Override
    public <K, V> Map<K, V> queryForMap(final String id, final Object parameterObject, final String keyProperty) throws DataAccessException {
        return (Map)this.execute(new SqlMapClientCallback<Map<K, V>>(){

            @Override
            public Map<K, V> doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForMap(id, parameterObject, keyProperty);
            }
        });
    }

    @Override
    public <K, V> Map<K, V> queryForMap(final String id, final Object parameterObject, final String keyProperty, final String valueProperty) throws DataAccessException {
        return (Map)this.execute(new SqlMapClientCallback<Map<K, V>>(){

            @Override
            public Map<K, V> doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForMap(id, parameterObject, keyProperty, valueProperty);
            }
        });
    }

    @Override
    public <K, V> Map<K, V> queryForMap(final String id, final Object parameterObject, final String keyProperty, final Class<K> keyType, final String valueProperty, final Class<V> valueType) throws DataAccessException {
        return (Map)this.execute(new SqlMapClientCallback<Map<K, V>>(){

            @Override
            public Map<K, V> doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForMap(id, parameterObject, keyProperty, keyType, valueProperty, valueType);
            }
        });
    }

    @Override
    public <T> T insert(String id) throws DataAccessException {
        return this.insert(id, null);
    }

    @Override
    public <T> T insert(final String id, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<T>(){

            @Override
            public T doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.insert(id, parameterObject);
            }
        });
    }

    @Override
    public int update(String id) throws DataAccessException {
        return this.update(id, null);
    }

    @Override
    public int update(final String id, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Integer>(){

            @Override
            public Integer doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.update(id, parameterObject);
            }
        });
    }

    @Override
    public void update(String id, Object parameterObject, int requiredRowsAffected) throws DataAccessException {
        int actualRowsAffected = this.update(id, parameterObject);
        if (actualRowsAffected != requiredRowsAffected) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException(id, requiredRowsAffected, actualRowsAffected);
        }
    }

    @Override
    public int delete(String id) throws DataAccessException {
        return this.delete(id, null);
    }

    @Override
    public int delete(final String id, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Integer>(){

            @Override
            public Integer doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.delete(id, parameterObject);
            }
        });
    }

    @Override
    public void delete(String id, Object parameterObject, int requiredRowsAffected) throws DataAccessException {
        int actualRowsAffected = this.delete(id, parameterObject);
        if (actualRowsAffected != requiredRowsAffected) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException(id, requiredRowsAffected, actualRowsAffected);
        }
    }

    @Override
    public <T> T insertArgs(String id, Object ... args) throws DataAccessException {
        return this.insert(id, this.toParameter(args));
    }

    @Override
    public int updateArgs(String id, Object ... args) throws DataAccessException {
        return this.update(id, this.toParameter(args));
    }

    @Override
    public int deleteArgs(String id, Object ... args) throws DataAccessException {
        return this.delete(id, this.toParameter(args));
    }

    @Override
    public <T> List<T> queryForListArgs(String id, Object ... args) throws DataAccessException {
        return this.queryForList(id, this.toParameter(args));
    }

    @Override
    public <T> List<T> queryForListArgs(int skip, int max, String id, Object ... args) throws DataAccessException {
        return this.queryForList(id, this.toParameter(args), skip, max);
    }

    @Override
    public <T> int queryForPage(List<T> page, String id, int skip, int max) throws DataAccessException {
        return this.queryForPage(page, id, null, skip, max);
    }

    @Override
    public <T> int queryForPage(final List<T> page, final String id, final Object paramObject, final int skip, final int max) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Integer>(){

            @Override
            public Integer doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForPage(page, id, paramObject, skip, max);
            }
        });
    }

    @Override
    public <T> int queryForPageArgs(List<T> page, String id, int skip, int max, Object ... args) throws DataAccessException {
        return this.queryForPage(page, id, this.toParameter(args), skip, max);
    }

    @Override
    public <K, V> Map<K, V> queryForMapArgs(String id, String keyProp, Object ... args) throws DataAccessException {
        return this.queryForMap(id, this.toParameter(args), keyProp);
    }

    @Override
    public <K, V> Map<K, V> queryForMapArgs(String id, String keyProp, String valueProp, Object ... args) throws DataAccessException {
        return this.queryForMap(id, this.toParameter(args), keyProp, valueProp);
    }

    @Override
    public <K, V> Map<K, V> queryForMapArgs(String id, String keyProp, Class<K> keyType, String valueProp, Class<V> valueType, Object ... args) throws DataAccessException {
        return this.queryForMap(id, this.toParameter(args), keyProp, keyType, valueProp, valueType);
    }

    @Override
    public <T> T queryForObjectArgs(String id, Object ... args) throws DataAccessException {
        return this.queryForObject(id, this.toParameter(args));
    }

    @Override
    public <T> T queryForFirstArgs(String id, Object ... args) throws DataAccessException {
        return this.queryForFirst(id, this.toParameter(args));
    }

    @Override
    public <T> T queryForFirst(String id) throws DataAccessException {
        List<T> list = this.queryForList(id, 0, 1);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <T> T queryForFirst(String id, Object parameterObject) throws DataAccessException {
        List<T> list = this.queryForList(id, parameterObject, 0, 1);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public Dialect getDialect() {
        return this.sqlMapClient.getDialect();
    }

    Map<String, Object> toParameter(Object[] args) {
        if (args == null || args.length == 0) {
            return Collections.emptyMap();
        }
        return new ArrayMap(args);
    }

    @Override
    public <E> E insertEntity(final Class<E> cls, final E entity) throws DataAccessException {
        return (E)this.execute(new SqlMapClientCallback<E>(){

            @Override
            public E doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.insertEntity(cls, entity);
            }
        });
    }

    @Override
    public <E, K> int updateEntity(final Class<E> cls, final E entity) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Integer>(){

            @Override
            public Integer doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.updateEntity(cls, entity);
            }
        });
    }

    @Override
    public <E, K> int deleteEntity(final Class<E> cls, final K key) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Integer>(){

            @Override
            public Integer doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.deleteEntity(cls, key);
            }
        });
    }

    @Override
    public <E, K> E findEntity(final Class<E> cls, final K key) throws DataAccessException {
        return (E)this.execute(new SqlMapClientCallback<E>(){

            @Override
            public E doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.findEntity(cls, key);
            }
        });
    }

    @Override
    public <T> T executeQueryObject(final CriteriaQuery<T> criteriaQuery) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<T>(){

            @Override
            public T doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.executeQueryObject(criteriaQuery);
            }
        });
    }

    @Override
    public <T> List<T> executeQuery(final CriteriaQuery<T> criteriaQuery) throws DataAccessException {
        return (List)this.execute(new SqlMapClientCallback<List<T>>(){

            @Override
            public List<T> doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.executeQuery(criteriaQuery);
            }
        });
    }

    @Override
    public <T> List<T> executeQuery(final CriteriaQuery<T> criteriaQuery, final int startPosition, final int maxResult) throws DataAccessException {
        return (List)this.execute(new SqlMapClientCallback<List<T>>(){

            @Override
            public List<T> doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.executeQuery(criteriaQuery, startPosition, maxResult);
            }
        });
    }

    @Override
    public <T> int executeQueryPage(final CriteriaQuery<T> criteriaQuery, final List<T> page, final int startPosition, final int maxResult) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Integer>(){

            @Override
            public Integer doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.executeQueryPage(criteriaQuery, page, startPosition, maxResult);
            }
        });
    }

    @Override
    public <T> int executeUpdate(final CriteriaUpdate<T> updateQuery) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Integer>(){

            @Override
            public Integer doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.executeUpdate(updateQuery);
            }
        });
    }

    @Override
    public <T> int executeDelete(final CriteriaDelete<T> deleteQuery) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Integer>(){

            @Override
            public Integer doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.executeDelete(deleteQuery);
            }
        });
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() throws DataAccessException {
        return this.sqlMapClient.getCriteriaBuilder();
    }

    @Override
    public ResultSet queryForResultSetArgs(String id, Object ... args) throws DataAccessException {
        return this.queryForResultSet(id, this.toParameter(args));
    }

    @Override
    public ResultSet queryForResultSet(String id) throws DataAccessException {
        return this.queryForResultSet(id, null);
    }

    @Override
    public ResultSet queryForResultSet(final String id, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<ResultSet>(){

            @Override
            public ResultSet doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForResultSet(id, parameterObject);
            }
        });
    }

    @Override
    public String getGlobalProperty(String name) {
        return this.sqlMapClient.getGlobalProperty(name);
    }
}

