/*
 * Decompiled with CFR 0.152.
 */
package org.ibatis.spring.support;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.ibatis.spring.support.SqlMapClientDaoSupport;

public abstract class AbstractDaoSupport<E>
extends SqlMapClientDaoSupport {
    private Class<E> entityClass = this.findEntityClass(this.getClass().getGenericSuperclass());

    Class<E> findEntityClass(Type t) {
        if (t instanceof ParameterizedType) {
            Type pt = ((ParameterizedType)t).getActualTypeArguments()[0];
            if (pt instanceof Class) {
                return (Class)pt;
            }
        } else if (t instanceof Class) {
            return this.findEntityClass(((Class)t).getGenericSuperclass());
        }
        return null;
    }

    protected Class<E> getEntityClass() {
        return this.entityClass;
    }

    protected void setEntityClass(Class<E> entityClass) {
        this.entityClass = entityClass;
    }

    public E saveEntity(E entity) {
        return this.getSqlMapClientTemplate().insertEntity(this.getEntityClass(), entity);
    }

    public int updateEntity(E entity) {
        return this.getSqlMapClientTemplate().updateEntity(this.getEntityClass(), entity);
    }

    public int deleteEntity(Object key) {
        return this.getSqlMapClientTemplate().deleteEntity(this.getEntityClass(), key);
    }

    public E findEntity(Object key) {
        return this.getSqlMapClientTemplate().findEntity(this.getEntityClass(), key);
    }
}

