/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.experimental.aot;

import com.dylibso.chicory.experimental.aot.AotUtil;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.ValueType;
import java.util.ArrayList;
import java.util.List;

final class AotContext {
    private final String internalClassName;
    private final List<ValueType> globalTypes;
    private final List<FunctionType> functionTypes;
    private final FunctionType[] types;
    private final int funcId;
    private final FunctionType type;
    private final FunctionBody body;
    private final List<Integer> slots;
    private final int memorySlot;
    private final int instanceSlot;
    private final int tempSlot;

    public AotContext(String internalClassName, List<ValueType> globalTypes, List<FunctionType> functionTypes, FunctionType[] types, int funcId, FunctionType type, FunctionBody body) {
        this.internalClassName = internalClassName;
        this.globalTypes = globalTypes;
        this.functionTypes = functionTypes;
        this.types = types;
        this.funcId = funcId;
        this.type = type;
        this.body = body;
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int slot = 0;
        for (ValueType param : type.params()) {
            slots.add(slot);
            slot += AotUtil.slotCount(param);
        }
        this.memorySlot = slot++;
        this.instanceSlot = slot++;
        for (ValueType local : body.localTypes()) {
            slots.add(slot);
            slot += AotUtil.slotCount(local);
        }
        this.slots = List.copyOf(slots);
        this.tempSlot = slot;
    }

    public String internalClassName() {
        return this.internalClassName;
    }

    public List<ValueType> globalTypes() {
        return this.globalTypes;
    }

    public List<FunctionType> functionTypes() {
        return this.functionTypes;
    }

    public FunctionType[] types() {
        return this.types;
    }

    public int getId() {
        return this.funcId;
    }

    public FunctionType getType() {
        return this.type;
    }

    public FunctionBody getBody() {
        return this.body;
    }

    public int localSlotIndex(int localIndex) {
        return this.slots.get(localIndex);
    }

    public int memorySlot() {
        return this.memorySlot;
    }

    public int instanceSlot() {
        return this.instanceSlot;
    }

    public int tempSlot() {
        return this.tempSlot;
    }
}

