/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.experimental.aot;

import com.dylibso.chicory.experimental.aot.AotContext;
import com.dylibso.chicory.experimental.aot.AotInstruction;
import com.dylibso.chicory.experimental.aot.AotMethodRefs;
import com.dylibso.chicory.experimental.aot.AotOpCode;
import com.dylibso.chicory.experimental.aot.AotUtil;
import com.dylibso.chicory.runtime.OpCodeIdentifier;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.ValueType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

final class AotEmitters {
    private AotEmitters() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void TRAP(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.THROW_TRAP_EXCEPTION);
        asm.athrow();
    }

    public static void DROP_KEEP(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        ValueType type;
        int i;
        int keepStart = (int)ins.operand(0) + 1;
        int slot = ctx.tempSlot();
        for (i = ins.operandCount() - 1; i >= keepStart; --i) {
            type = ValueType.forId((int)((int)ins.operand(i)));
            asm.store(slot, AotUtil.asmType(type));
            slot += AotUtil.slotCount(type);
        }
        for (i = keepStart - 1; i >= 1; --i) {
            AotUtil.emitPop((MethodVisitor)asm, ValueType.forId((int)((int)ins.operand(i))));
        }
        for (i = keepStart; i < ins.operandCount(); ++i) {
            type = ValueType.forId((int)((int)ins.operand(i)));
            asm.load(slot -= AotUtil.slotCount(type), AotUtil.asmType(type));
        }
    }

    public static void RETURN(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        if (ctx.getType().returns().size() > 1) {
            asm.invokestatic(ctx.internalClassName(), AotUtil.valueMethodName(ctx.getType().returns()), AotUtil.valueMethodType(ctx.getType().returns()).toMethodDescriptorString(), false);
        }
        asm.areturn(Type.getType(AotUtil.jvmReturnType(ctx.getType())));
    }

    public static void DROP(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotUtil.emitPop((MethodVisitor)asm, ValueType.forId((int)((int)ins.operand(0))));
    }

    public static void ELEM_DROP(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        int index = (int)ins.operand(0);
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        asm.iconst(index);
        asm.aconst(null);
        AotUtil.emitInvokeVirtual((MethodVisitor)asm, AotMethodRefs.INSTANCE_SET_ELEMENT);
    }

    public static void SELECT(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        ValueType type = ValueType.forId((int)((int)ins.operand(0)));
        Label endLabel = new Label();
        asm.ifne(endLabel);
        if (AotUtil.slotCount(type) == 1) {
            asm.swap();
        } else {
            asm.dup2X2();
            asm.pop2();
        }
        asm.mark(endLabel);
        AotUtil.emitPop((MethodVisitor)asm, type);
    }

    public static void CALL(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        int funcId = (int)ins.operand(0);
        FunctionType functionType = ctx.functionTypes().get(funcId);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.CHECK_INTERRUPTION);
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeFunction((MethodVisitor)asm, ctx.internalClassName(), funcId, functionType);
        if (functionType.returns().size() > 1) {
            AotEmitters.emitUnboxResult(asm, ctx, functionType.returns());
        }
    }

    public static void CALL_INDIRECT(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        int typeId = (int)ins.operand(0);
        int tableIdx = (int)ins.operand(1);
        FunctionType functionType = ctx.types()[typeId];
        asm.iconst(tableIdx);
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        asm.invokestatic(ctx.internalClassName(), AotUtil.callIndirectMethodName(typeId), AotUtil.callIndirectMethodType(functionType).toMethodDescriptorString(), false);
        if (functionType.returns().size() > 1) {
            AotEmitters.emitUnboxResult(asm, ctx, functionType.returns());
        }
    }

    public static void REF_FUNC(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
    }

    public static void REF_NULL(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.iconst(-1);
    }

    public static void REF_IS_NULL(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.REF_IS_NULL);
    }

    public static void LOCAL_GET(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        int loadIndex = (int)ins.operand(0);
        ValueType localType = AotUtil.localType(ctx.getType(), ctx.getBody(), loadIndex);
        asm.load(ctx.localSlotIndex(loadIndex), AotUtil.asmType(localType));
    }

    public static void LOCAL_SET(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        int index = (int)ins.operand(0);
        ValueType localType = AotUtil.localType(ctx.getType(), ctx.getBody(), index);
        asm.store(ctx.localSlotIndex(index), AotUtil.asmType(localType));
    }

    public static void LOCAL_TEE(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        if (AotUtil.slotCount(ValueType.forId((int)((int)ins.operand(1)))) == 1) {
            asm.dup();
        } else {
            asm.dup2();
        }
        AotEmitters.LOCAL_SET(ctx, ins, asm);
    }

    public static void GLOBAL_GET(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        int globalIndex = (int)ins.operand(0);
        asm.iconst(globalIndex);
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.READ_GLOBAL);
        AotUtil.emitLongToJvm((MethodVisitor)asm, ctx.globalTypes().get(globalIndex));
    }

    public static void GLOBAL_SET(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        int globalIndex = (int)ins.operand(0);
        AotUtil.emitJvmToLong((MethodVisitor)asm, ctx.globalTypes().get(globalIndex));
        asm.iconst(globalIndex);
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.WRITE_GLOBAL);
    }

    public static void TABLE_GET(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.TABLE_GET);
    }

    public static void TABLE_SET(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.TABLE_SET);
    }

    public static void TABLE_SIZE(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.TABLE_SIZE);
    }

    public static void TABLE_GROW(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.TABLE_GROW);
    }

    public static void TABLE_FILL(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.TABLE_FILL);
    }

    public static void TABLE_COPY(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.iconst((int)ins.operand(1));
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.TABLE_COPY);
    }

    public static void TABLE_INIT(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.iconst((int)ins.operand(1));
        asm.load(ctx.instanceSlot(), InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.TABLE_INIT);
    }

    public static void MEMORY_INIT(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.MEMORY_INIT);
    }

    public static void MEMORY_COPY(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.MEMORY_COPY);
    }

    public static void MEMORY_FILL(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.MEMORY_FILL);
    }

    public static void MEMORY_GROW(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.MEMORY_GROW);
    }

    public static void MEMORY_SIZE(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.MEMORY_PAGES);
    }

    public static void DATA_DROP(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.MEMORY_DROP);
    }

    public static void I32_ADD(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(96);
    }

    public static void I32_AND(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(126);
    }

    public static void I32_CONST(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.iconst((int)ins.operand(0));
    }

    public static void I32_MUL(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(104);
    }

    public static void I32_OR(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(128);
    }

    public static void I32_SHL(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(120);
    }

    public static void I32_SHR_S(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(122);
    }

    public static void I32_SHR_U(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(124);
    }

    public static void I32_SUB(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(100);
    }

    public static void I32_WRAP_I64(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(136);
    }

    public static void I32_XOR(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(130);
    }

    public static void I64_ADD(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(97);
    }

    public static void I64_AND(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(127);
    }

    public static void I64_CONST(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.lconst(ins.operand(0));
    }

    public static void I64_EXTEND_I32_S(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(133);
    }

    public static void I64_MUL(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(105);
    }

    public static void I64_OR(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(129);
    }

    public static void I64_SHL(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(136);
        asm.visitInsn(121);
    }

    public static void I64_SHR_S(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(136);
        asm.visitInsn(123);
    }

    public static void I64_SHR_U(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(136);
        asm.visitInsn(125);
    }

    public static void I64_SUB(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(101);
    }

    public static void I64_XOR(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(131);
    }

    public static void F32_ADD(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(98);
    }

    public static void F32_CONST(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.fconst(Float.intBitsToFloat((int)ins.operand(0)));
    }

    public static void F32_DEMOTE_F64(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(144);
    }

    public static void F32_DIV(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(110);
    }

    public static void F32_MUL(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(106);
    }

    public static void F32_NEG(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(118);
    }

    public static void F32_SUB(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(102);
    }

    public static void F64_ADD(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(99);
    }

    public static void F64_CONST(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.dconst(Double.longBitsToDouble(ins.operand(0)));
    }

    public static void F64_DIV(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(111);
    }

    public static void F64_MUL(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(107);
    }

    public static void F64_NEG(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(119);
    }

    public static void F64_PROMOTE_F32(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(141);
    }

    public static void F64_SUB(AotContext ctx, AotInstruction ins, MethodVisitor asm) {
        asm.visitInsn(103);
    }

    public static void I32_LOAD(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.emitLoadOrStore(ctx, ins, asm, AotMethodRefs.MEMORY_READ_INT);
    }

    public static void I32_LOAD8_S(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.emitLoadOrStore(ctx, ins, asm, AotMethodRefs.MEMORY_READ_BYTE);
    }

    public static void I32_LOAD8_U(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.I32_LOAD8_S(ctx, ins, asm);
        asm.iconst(255);
        asm.visitInsn(126);
    }

    public static void I32_LOAD16_S(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.emitLoadOrStore(ctx, ins, asm, AotMethodRefs.MEMORY_READ_SHORT);
    }

    public static void I32_LOAD16_U(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.I32_LOAD16_S(ctx, ins, asm);
        asm.iconst(65535);
        asm.visitInsn(126);
    }

    public static void F32_LOAD(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.emitLoadOrStore(ctx, ins, asm, AotMethodRefs.MEMORY_READ_FLOAT);
    }

    public static void I64_LOAD(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.emitLoadOrStore(ctx, ins, asm, AotMethodRefs.MEMORY_READ_LONG);
    }

    public static void I64_LOAD8_S(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.I32_LOAD8_S(ctx, ins, asm);
        asm.visitInsn(133);
    }

    public static void I64_LOAD8_U(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.I32_LOAD8_U(ctx, ins, asm);
        asm.visitInsn(133);
    }

    public static void I64_LOAD16_S(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.I32_LOAD16_S(ctx, ins, asm);
        asm.visitInsn(133);
    }

    public static void I64_LOAD16_U(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.I32_LOAD16_U(ctx, ins, asm);
        asm.visitInsn(133);
    }

    public static void I64_LOAD32_S(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.I32_LOAD(ctx, ins, asm);
        asm.visitInsn(133);
    }

    public static void I64_LOAD32_U(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.I32_LOAD(ctx, ins, asm);
        asm.visitInsn(133);
        asm.lconst(0xFFFFFFFFL);
        asm.visitInsn(127);
    }

    public static void F64_LOAD(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.emitLoadOrStore(ctx, ins, asm, AotMethodRefs.MEMORY_READ_DOUBLE);
    }

    public static void I32_STORE(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.emitLoadOrStore(ctx, ins, asm, AotMethodRefs.MEMORY_WRITE_INT);
    }

    public static void I32_STORE8(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.visitInsn(145);
        AotEmitters.emitLoadOrStore(ctx, ins, asm, AotMethodRefs.MEMORY_WRITE_BYTE);
    }

    public static void I32_STORE16(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.visitInsn(147);
        AotEmitters.emitLoadOrStore(ctx, ins, asm, AotMethodRefs.MEMORY_WRITE_SHORT);
    }

    public static void F32_STORE(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.emitLoadOrStore(ctx, ins, asm, AotMethodRefs.MEMORY_WRITE_FLOAT);
    }

    public static void I64_STORE8(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.visitInsn(136);
        AotEmitters.I32_STORE8(ctx, ins, asm);
    }

    public static void I64_STORE16(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.visitInsn(136);
        AotEmitters.I32_STORE16(ctx, ins, asm);
    }

    public static void I64_STORE32(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        asm.visitInsn(136);
        AotEmitters.emitLoadOrStore(ctx, ins, asm, AotMethodRefs.MEMORY_WRITE_INT);
    }

    public static void I64_STORE(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.emitLoadOrStore(ctx, ins, asm, AotMethodRefs.MEMORY_WRITE_LONG);
    }

    public static void F64_STORE(AotContext ctx, AotInstruction ins, InstructionAdapter asm) {
        AotEmitters.emitLoadOrStore(ctx, ins, asm, AotMethodRefs.MEMORY_WRITE_DOUBLE);
    }

    private static void emitLoadOrStore(AotContext ctx, AotInstruction ins, InstructionAdapter asm, Method method) {
        long offset = ins.operand(1);
        if (offset < 0L || offset >= Integer.MAX_VALUE) {
            AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.THROW_OUT_OF_BOUNDS_MEMORY_ACCESS);
            asm.athrow();
        }
        asm.iconst((int)offset);
        asm.load(ctx.memorySlot(), InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, method);
    }

    private static void emitUnboxResult(InstructionAdapter asm, AotContext ctx, List<ValueType> types) {
        asm.store(ctx.tempSlot(), InstructionAdapter.OBJECT_TYPE);
        for (int i = 0; i < types.size(); ++i) {
            asm.load(ctx.tempSlot(), InstructionAdapter.OBJECT_TYPE);
            asm.iconst(i);
            asm.aload(Type.LONG_TYPE);
            AotUtil.emitLongToJvm((MethodVisitor)asm, types.get(i));
        }
    }

    public static BytecodeEmitter intrinsify(AotOpCode opcode, Class<?> staticHelpers) {
        for (Method method : staticHelpers.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(OpCodeIdentifier.class) || method.getAnnotation(OpCodeIdentifier.class).value() != opcode.opcode()) continue;
            return (ctx, ins, asm) -> AotUtil.emitInvokeStatic((MethodVisitor)asm, method);
        }
        throw new IllegalArgumentException("Static helper " + staticHelpers.getName() + " does not provide an implementation of opcode " + opcode.name());
    }

    static class Builder {
        private final Map<AotOpCode, BytecodeEmitter> emitters = new EnumMap<AotOpCode, BytecodeEmitter>(AotOpCode.class);

        Builder() {
        }

        public Builder intrinsic(AotOpCode opCode, BytecodeEmitter emitter) {
            this.emitters.put(opCode, emitter);
            return this;
        }

        public Builder shared(AotOpCode opCode, Class<?> staticHelpers) {
            this.emitters.put(opCode, AotEmitters.intrinsify(opCode, staticHelpers));
            return this;
        }

        public Map<AotOpCode, BytecodeEmitter> build() {
            return Map.copyOf(this.emitters);
        }
    }

    @FunctionalInterface
    static interface BytecodeEmitter {
        public void emit(AotContext var1, AotInstruction var2, InstructionAdapter var3);
    }
}

