/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.experimental.aot;

import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Memory;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Value;
import com.dylibso.chicory.wasm.types.ValueType;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class AotUtil {
    private static final Method LONG_TO_F32;
    private static final Method LONG_TO_F64;
    private static final Method F32_TO_LONG;
    private static final Method F64_TO_LONG;

    private AotUtil() {
    }

    public static Class<?> jvmType(ValueType type) {
        switch (type) {
            case I32: 
            case ExternRef: 
            case FuncRef: {
                return Integer.TYPE;
            }
            case I64: {
                return Long.TYPE;
            }
            case F32: {
                return Float.TYPE;
            }
            case F64: {
                return Double.TYPE;
            }
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + type.name());
    }

    public static Type asmType(ValueType type) {
        switch (type) {
            case I32: 
            case ExternRef: 
            case FuncRef: {
                return Type.INT_TYPE;
            }
            case I64: {
                return Type.LONG_TYPE;
            }
            case F32: {
                return Type.FLOAT_TYPE;
            }
            case F64: {
                return Type.DOUBLE_TYPE;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
    }

    public static ValueType localType(FunctionType type, FunctionBody body, int localIndex) {
        if (localIndex < type.params().size()) {
            return (ValueType)type.params().get(localIndex);
        }
        return (ValueType)body.localTypes().get(localIndex - type.params().size());
    }

    public static void emitLongToJvm(MethodVisitor asm, ValueType type) {
        switch (type) {
            case I32: 
            case ExternRef: 
            case FuncRef: {
                asm.visitInsn(136);
                return;
            }
            case I64: {
                return;
            }
            case F32: {
                AotUtil.emitInvokeStatic(asm, LONG_TO_F32);
                return;
            }
            case F64: {
                AotUtil.emitInvokeStatic(asm, LONG_TO_F64);
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + type.name());
    }

    public static void emitJvmToLong(MethodVisitor asm, ValueType type) {
        switch (type) {
            case I32: 
            case ExternRef: 
            case FuncRef: {
                asm.visitInsn(133);
                return;
            }
            case I64: {
                return;
            }
            case F32: {
                AotUtil.emitInvokeStatic(asm, F32_TO_LONG);
                return;
            }
            case F64: {
                AotUtil.emitInvokeStatic(asm, F64_TO_LONG);
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + type.name());
    }

    public static MethodType valueMethodType(List<ValueType> types) {
        return MethodType.methodType(long[].class, AotUtil.jvmTypes(types));
    }

    public static MethodType callIndirectMethodType(FunctionType functionType) {
        return AotUtil.rawMethodTypeFor(functionType).appendParameterTypes(Integer.TYPE, Integer.TYPE, Memory.class, Instance.class);
    }

    public static MethodType methodTypeFor(FunctionType type) {
        return AotUtil.rawMethodTypeFor(type).appendParameterTypes(Memory.class, Instance.class);
    }

    public static MethodType rawMethodTypeFor(FunctionType type) {
        return MethodType.methodType(AotUtil.jvmReturnType(type), AotUtil.jvmParameterTypes(type));
    }

    public static Class<?>[] jvmTypes(List<ValueType> types) {
        return (Class[])types.stream().map(AotUtil::jvmType).toArray(Class[]::new);
    }

    public static Class<?>[] jvmParameterTypes(FunctionType type) {
        return AotUtil.jvmTypes(type.params());
    }

    public static Class<?> jvmReturnType(FunctionType type) {
        switch (type.returns().size()) {
            case 0: {
                return Void.TYPE;
            }
            case 1: {
                return AotUtil.jvmType((ValueType)type.returns().get(0));
            }
        }
        return long[].class;
    }

    public static Object defaultValue(ValueType type) {
        switch (type) {
            case I32: {
                return 0;
            }
            case I64: {
                return 0L;
            }
            case F32: {
                return Float.valueOf(0.0f);
            }
            case F64: {
                return 0.0;
            }
            case ExternRef: 
            case FuncRef: {
                return -1;
            }
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + type.name());
    }

    public static int slotCount(ValueType type) {
        switch (type) {
            case I32: 
            case ExternRef: 
            case FuncRef: 
            case F32: {
                return 1;
            }
            case I64: 
            case F64: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
    }

    public static void emitPop(MethodVisitor asm, ValueType type) {
        asm.visitInsn(AotUtil.slotCount(type) == 1 ? 87 : 88);
    }

    public static void emitInvokeStatic(MethodVisitor asm, Method method) {
        assert (Modifier.isStatic(method.getModifiers()));
        asm.visitMethodInsn(184, Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor((Method)method), false);
    }

    public static void emitInvokeVirtual(MethodVisitor asm, Method method) {
        assert (!Modifier.isStatic(method.getModifiers()));
        assert (!method.getDeclaringClass().isInterface());
        asm.visitMethodInsn(182, Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor((Method)method), false);
    }

    public static void emitInvokeFunction(MethodVisitor asm, String internalClassName, int funcId, FunctionType functionType) {
        asm.visitMethodInsn(184, internalClassName, AotUtil.methodNameFor(funcId), AotUtil.methodTypeFor(functionType).toMethodDescriptorString(), false);
    }

    public static String valueMethodName(List<ValueType> types) {
        return "value_" + types.stream().map(type -> type.name().toLowerCase(Locale.ROOT)).collect(Collectors.joining("_"));
    }

    public static String methodNameFor(int funcId) {
        return "func_" + funcId;
    }

    public static String callIndirectMethodName(int typeId) {
        return "call_indirect_" + typeId;
    }

    public static String internalClassName(String name) {
        return name.replace('.', '/');
    }

    static {
        try {
            LONG_TO_F32 = Value.class.getMethod("longToFloat", Long.TYPE);
            LONG_TO_F64 = Value.class.getMethod("longToDouble", Long.TYPE);
            F32_TO_LONG = Value.class.getMethod("floatToLong", Float.TYPE);
            F64_TO_LONG = Value.class.getMethod("doubleToLong", Double.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

