/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.experimental.aot;

import com.dylibso.chicory.experimental.aot.AotAnalyzer;
import com.dylibso.chicory.experimental.aot.AotClassLoader;
import com.dylibso.chicory.experimental.aot.AotContext;
import com.dylibso.chicory.experimental.aot.AotEmitterMap;
import com.dylibso.chicory.experimental.aot.AotEmitters;
import com.dylibso.chicory.experimental.aot.AotInstruction;
import com.dylibso.chicory.experimental.aot.AotMethodInliner;
import com.dylibso.chicory.experimental.aot.AotMethodRefs;
import com.dylibso.chicory.experimental.aot.AotUtil;
import com.dylibso.chicory.experimental.aot.CompilerResult;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Machine;
import com.dylibso.chicory.runtime.Memory;
import com.dylibso.chicory.wasm.ChicoryException;
import com.dylibso.chicory.wasm.WasmModule;
import com.dylibso.chicory.wasm.types.ExternalType;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.ValueType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodTooLargeException;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.util.CheckClassAdapter;

public final class AotCompiler {
    public static final String DEFAULT_CLASS_NAME = "com.dylibso.chicory.$gen.CompiledMachine";
    private static final MethodType CALL_METHOD_TYPE = MethodType.methodType(long[].class, Instance.class, Memory.class, long[].class);
    private static final MethodType MACHINE_CALL_METHOD_TYPE = MethodType.methodType(long[].class, Instance.class, Memory.class, Integer.TYPE, long[].class);
    private static final int MAX_MACHINE_CALL_METHODS = 1024;
    private final AotClassLoader classLoader = new AotClassLoader();
    private final String className;
    private final WasmModule module;
    private final AotAnalyzer analyzer;
    private final int functionImports;
    private final List<FunctionType> functionTypes;
    private final Map<String, byte[]> extraClasses;

    private AotCompiler(WasmModule module, String className) {
        this.className = Objects.requireNonNull(className, "className");
        this.module = Objects.requireNonNull(module, "module");
        this.analyzer = new AotAnalyzer(module);
        this.functionImports = module.importSection().count(ExternalType.FUNCTION);
        this.functionTypes = this.analyzer.functionTypes();
        this.extraClasses = this.compileExtraClasses();
    }

    public static CompilerResult compileModule(WasmModule module) {
        return AotCompiler.compileModule(module, DEFAULT_CLASS_NAME);
    }

    public static CompilerResult compileModule(WasmModule module, String className) {
        AotCompiler compiler = new AotCompiler(module, className);
        byte[] bytes = compiler.compileClass();
        Function<Instance, Machine> factory = compiler.createMachineFactory(bytes);
        LinkedHashMap<String, byte[]> classBytes = new LinkedHashMap<String, byte[]>();
        classBytes.put(className, bytes);
        classBytes.putAll(compiler.extraClasses);
        return new CompilerResult(factory, classBytes);
    }

    private Function<Instance, Machine> createMachineFactory(byte[] classBytes) {
        try {
            Class<Machine> clazz = this.loadClass(classBytes).asSubclass(Machine.class);
            Constructor<Machine> constructor = clazz.getConstructor(Instance.class);
            MethodHandle handle = MethodHandles.publicLookup().unreflectConstructor(constructor);
            Function function = MethodHandleProxies.asInterfaceInstance(Function.class, handle);
            return function;
        }
        catch (ReflectiveOperationException e) {
            throw new ChicoryException((Throwable)e);
        }
    }

    private Class<?> loadClass(byte[] classBytes) {
        try {
            Class<?> clazz = this.classLoader.loadFromBytes(classBytes);
            Class.forName(clazz.getName(), true, clazz.getClassLoader());
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (VerifyError e) {
            try {
                StringWriter out = new StringWriter().append("ASM verifier:\n\n");
                CheckClassAdapter.verify((ClassReader)new ClassReader(classBytes), (boolean)true, (PrintWriter)new PrintWriter(out));
                e.addSuppressed(new RuntimeException(out.toString()));
            }
            catch (Throwable t) {
                e.addSuppressed(t);
            }
            throw e;
        }
    }

    private void loadExtraClass(Map<String, byte[]> classes, byte[] bytes) {
        Class<?> clazz = this.loadClass(bytes);
        classes.put(clazz.getName(), bytes);
    }

    private Map<String, byte[]> compileExtraClasses() {
        LinkedHashMap<String, byte[]> classes = new LinkedHashMap<String, byte[]>();
        this.loadExtraClass(classes, AotMethodInliner.createAotMethodsClass(this.className));
        if (!this.functionTypes.isEmpty()) {
            this.loadExtraClass(classes, this.compileMachineCallClass());
        }
        return classes;
    }

    private byte[] compileClass() {
        FunctionType type;
        String internalClassName = AotUtil.internalClassName(this.className);
        ClassWriter binaryWriter = new ClassWriter(2);
        ClassRemapper classWriter = AotMethodInliner.aotMethodsRemapper((ClassVisitor)binaryWriter, this.className);
        classWriter.visit(55, 49, internalClassName, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(Machine.class)});
        classWriter.visitSource("wasm", null);
        for (String name : this.extraClasses.keySet()) {
            classWriter.visitNestMember(AotUtil.internalClassName(name));
        }
        classWriter.visitField(18, "instance", Type.getDescriptor(Instance.class), null, null);
        AotCompiler.emitFunction((ClassVisitor)classWriter, "<init>", MethodType.methodType(Void.TYPE, Instance.class), false, asm -> AotCompiler.compileConstructor(asm, internalClassName));
        AotCompiler.emitFunction((ClassVisitor)classWriter, "call", MethodType.methodType(long[].class, Integer.TYPE, long[].class), false, asm -> this.compileMachineCall(internalClassName, (InstructionAdapter)asm));
        int i = 0;
        while (i < this.functionImports) {
            int funcId = i++;
            type = this.functionTypes.get(funcId);
            AotCompiler.emitFunction((ClassVisitor)classWriter, AotUtil.methodNameFor(funcId), AotUtil.methodTypeFor(type), true, asm -> AotCompiler.compileHostFunction(funcId, type, asm));
        }
        for (i = 0; i < this.module.functionSection().functionCount(); ++i) {
            int funcId = this.functionImports + i;
            type = this.functionTypes.get(funcId);
            FunctionBody body = this.module.codeSection().getFunctionBody(i);
            AotCompiler.emitFunction((ClassVisitor)classWriter, AotUtil.methodNameFor(funcId), AotUtil.methodTypeFor(type), true, asm -> this.compileFunction(internalClassName, funcId, type, body, (InstructionAdapter)asm));
        }
        FunctionType[] allTypes = this.module.typeSection().types();
        for (int i2 = 0; i2 < allTypes.length; ++i2) {
            int typeId = i2;
            FunctionType type2 = allTypes[i2];
            AotCompiler.emitFunction((ClassVisitor)classWriter, AotUtil.callIndirectMethodName(typeId), AotUtil.callIndirectMethodType(type2), true, asm -> this.compileCallIndirect(internalClassName, typeId, type2, (InstructionAdapter)asm));
        }
        Set returnTypes = this.functionTypes.stream().map(FunctionType::returns).filter(types -> types.size() > 1).collect(Collectors.toSet());
        for (List types2 : returnTypes) {
            AotCompiler.emitFunction((ClassVisitor)classWriter, AotUtil.valueMethodName(types2), AotUtil.valueMethodType(types2), true, asm -> {
                AotCompiler.emitBoxArguments(asm, types2);
                asm.areturn(InstructionAdapter.OBJECT_TYPE);
            });
        }
        classWriter.visitEnd();
        try {
            return binaryWriter.toByteArray();
        }
        catch (MethodTooLargeException e) {
            Object name = e.getMethodName();
            if (((String)name).startsWith("func_") && this.module.nameSection() != null) {
                int funcId = Integer.parseInt(((String)name).split("_", -1)[1]);
                String function = this.module.nameSection().nameOfFunction(funcId);
                if (function != null) {
                    name = (String)name + " (" + function + ")";
                }
            }
            throw new ChicoryException(String.format("JVM bytecode too large for WASM method: %s size=%d", name, e.getCodeSize()), (Throwable)e);
        }
    }

    private static void emitFunction(ClassVisitor classWriter, String methodName, MethodType methodType, boolean isStatic, Consumer<InstructionAdapter> consumer) {
        MethodVisitor methodWriter = classWriter.visitMethod(1 | (isStatic ? 8 : 0), methodName, methodType.toMethodDescriptorString(), null, null);
        methodWriter.visitCode();
        consumer.accept(new InstructionAdapter(methodWriter));
        methodWriter.visitMaxs(0, 0);
        methodWriter.visitEnd();
    }

    private static void emitCallSuper(InstructionAdapter asm) {
        asm.load(0, InstructionAdapter.OBJECT_TYPE);
        asm.invokespecial(InstructionAdapter.OBJECT_TYPE.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
    }

    private static void compileConstructor(InstructionAdapter asm, String internalClassName) {
        AotCompiler.emitCallSuper(asm);
        asm.load(0, InstructionAdapter.OBJECT_TYPE);
        asm.load(1, InstructionAdapter.OBJECT_TYPE);
        asm.putfield(internalClassName, "instance", Type.getDescriptor(Instance.class));
        asm.areturn(Type.VOID_TYPE);
    }

    private void compileMachineCall(String internalClassName, InstructionAdapter asm) {
        if (this.functionTypes.isEmpty()) {
            asm.load(1, Type.INT_TYPE);
            AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.THROW_UNKNOWN_FUNCTION);
            asm.athrow();
            return;
        }
        Label start = new Label();
        Label end = new Label();
        asm.visitTryCatchBlock(start, end, end, Type.getInternalName(StackOverflowError.class));
        asm.mark(start);
        asm.load(0, InstructionAdapter.OBJECT_TYPE);
        asm.getfield(internalClassName, "instance", Type.getDescriptor(Instance.class));
        asm.dup();
        AotUtil.emitInvokeVirtual((MethodVisitor)asm, AotMethodRefs.INSTANCE_MEMORY);
        asm.load(1, Type.INT_TYPE);
        asm.load(2, InstructionAdapter.OBJECT_TYPE);
        asm.invokestatic(internalClassName + "$MachineCall", "call", MACHINE_CALL_METHOD_TYPE.toMethodDescriptorString(), false);
        asm.areturn(InstructionAdapter.OBJECT_TYPE);
        asm.mark(end);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.THROW_CALL_STACK_EXHAUSTED);
        asm.athrow();
    }

    private byte[] compileMachineCallClass() {
        int i;
        Consumer<InstructionAdapter> callMethod;
        ClassWriter binaryWriter = new ClassWriter(2);
        ClassRemapper classWriter = AotMethodInliner.aotMethodsRemapper((ClassVisitor)binaryWriter, this.className);
        classWriter.visit(55, 48, AotUtil.internalClassName(this.className + "$MachineCall"), null, Type.getInternalName(Object.class), null);
        classWriter.visitNestHost(AotUtil.internalClassName(this.className));
        AotCompiler.emitFunction((ClassVisitor)classWriter, "<init>", MethodType.methodType(Void.TYPE), false, asm -> {
            AotCompiler.emitCallSuper(asm);
            asm.areturn(Type.VOID_TYPE);
        });
        if (this.functionTypes.size() < 1024) {
            callMethod = asm -> this.compileMachineCallInvoke((InstructionAdapter)asm, 0, this.functionTypes.size());
        } else {
            callMethod = this::compileMachineCallDispatch;
            for (i = 0; i < this.functionTypes.size(); i += 1024) {
                int start = i;
                int end = Math.min(start + 1024, this.functionTypes.size());
                AotCompiler.emitFunction((ClassVisitor)classWriter, AotCompiler.callDispatchMethodName(start), MACHINE_CALL_METHOD_TYPE, true, asm -> this.compileMachineCallInvoke((InstructionAdapter)asm, start, end));
            }
        }
        AotCompiler.emitFunction((ClassVisitor)classWriter, "call", MACHINE_CALL_METHOD_TYPE, true, callMethod);
        for (i = 0; i < this.module.functionSection().functionCount(); ++i) {
            int funcId = this.functionImports + i;
            FunctionType type = this.functionTypes.get(funcId);
            AotCompiler.emitFunction((ClassVisitor)classWriter, AotCompiler.callMethodName(funcId), CALL_METHOD_TYPE, true, asm -> this.compileCallFunction(funcId, type, (InstructionAdapter)asm));
        }
        return binaryWriter.toByteArray();
    }

    private void compileMachineCallDispatch(InstructionAdapter asm) {
        int i;
        asm.load(0, InstructionAdapter.OBJECT_TYPE);
        asm.load(1, InstructionAdapter.OBJECT_TYPE);
        asm.load(2, Type.INT_TYPE);
        asm.load(3, InstructionAdapter.OBJECT_TYPE);
        assert (Integer.bitCount(1024) == 1);
        int shift = Integer.numberOfTrailingZeros(1024);
        Label[] labels = new Label[(this.functionTypes.size() - 1 >> shift) + 1];
        for (i = 0; i < labels.length; ++i) {
            labels[i] = new Label();
        }
        asm.load(2, Type.INT_TYPE);
        asm.iconst(shift);
        asm.shr(Type.INT_TYPE);
        asm.tableswitch(0, labels.length - 1, labels[0], labels);
        for (i = 0; i < labels.length; ++i) {
            asm.mark(labels[i]);
            asm.invokestatic(AotUtil.internalClassName(this.className + "$MachineCall"), AotCompiler.callDispatchMethodName(i << shift), MACHINE_CALL_METHOD_TYPE.toMethodDescriptorString(), false);
            asm.areturn(InstructionAdapter.OBJECT_TYPE);
        }
    }

    private void compileMachineCallInvoke(InstructionAdapter asm, int start, int end) {
        int id;
        asm.load(0, InstructionAdapter.OBJECT_TYPE);
        asm.load(1, InstructionAdapter.OBJECT_TYPE);
        asm.load(3, InstructionAdapter.OBJECT_TYPE);
        Label defaultLabel = new Label();
        Label hostLabel = new Label();
        Label[] labels = new Label[end - start];
        for (id = start; id < end; ++id) {
            labels[id - start] = id < this.functionImports ? hostLabel : new Label();
        }
        asm.load(2, Type.INT_TYPE);
        asm.tableswitch(start, end - 1, defaultLabel, labels);
        for (id = Math.max(start, this.functionImports); id < end; ++id) {
            asm.mark(labels[id - start]);
            asm.invokestatic(AotUtil.internalClassName(this.className + "$MachineCall"), AotCompiler.callMethodName(id), CALL_METHOD_TYPE.toMethodDescriptorString(), false);
            asm.areturn(InstructionAdapter.OBJECT_TYPE);
        }
        if (this.functionImports > start) {
            asm.mark(hostLabel);
            asm.pop();
            asm.pop();
            asm.load(2, Type.INT_TYPE);
            asm.load(3, InstructionAdapter.OBJECT_TYPE);
            AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.CALL_HOST_FUNCTION);
            asm.areturn(InstructionAdapter.OBJECT_TYPE);
        }
        asm.mark(defaultLabel);
        asm.load(2, Type.INT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.THROW_UNKNOWN_FUNCTION);
        asm.athrow();
    }

    private void compileCallFunction(int funcId, FunctionType type, InstructionAdapter asm) {
        for (int i = 0; i < type.params().size(); ++i) {
            ValueType param = (ValueType)type.params().get(i);
            asm.load(2, InstructionAdapter.OBJECT_TYPE);
            asm.iconst(i);
            asm.aload(Type.LONG_TYPE);
            AotUtil.emitLongToJvm((MethodVisitor)asm, param);
        }
        asm.load(1, InstructionAdapter.OBJECT_TYPE);
        asm.load(0, InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeFunction((MethodVisitor)asm, AotUtil.internalClassName(this.className), funcId, type);
        Class<?> returnType = AotUtil.jvmReturnType(type);
        if (returnType == Void.TYPE) {
            asm.aconst(null);
        } else if (returnType != long[].class) {
            AotUtil.emitJvmToLong((MethodVisitor)asm, (ValueType)type.returns().get(0));
            asm.store(3, Type.LONG_TYPE);
            asm.iconst(1);
            asm.newarray(Type.LONG_TYPE);
            asm.dup();
            asm.iconst(0);
            asm.load(3, Type.LONG_TYPE);
            asm.astore(Type.LONG_TYPE);
        }
        asm.areturn(InstructionAdapter.OBJECT_TYPE);
    }

    private void compileCallIndirect(String internalClassName, int typeId, FunctionType type, InstructionAdapter asm) {
        int slots;
        int funcTableIdx = slots = type.params().stream().mapToInt(AotUtil::slotCount).sum();
        int tableIdx = slots + 1;
        int memory = slots + 2;
        int instance = slots + 3;
        int table = slots + 4;
        int funcId = slots + 5;
        int refInstance = slots + 6;
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.CHECK_INTERRUPTION);
        asm.load(instance, InstructionAdapter.OBJECT_TYPE);
        asm.load(tableIdx, Type.INT_TYPE);
        AotUtil.emitInvokeVirtual((MethodVisitor)asm, AotMethodRefs.INSTANCE_TABLE);
        asm.store(table, InstructionAdapter.OBJECT_TYPE);
        asm.load(table, InstructionAdapter.OBJECT_TYPE);
        asm.load(funcTableIdx, Type.INT_TYPE);
        AotUtil.emitInvokeVirtual((MethodVisitor)asm, AotMethodRefs.TABLE_REQUIRED_REF);
        asm.store(funcId, Type.INT_TYPE);
        asm.load(table, InstructionAdapter.OBJECT_TYPE);
        asm.load(funcTableIdx, Type.INT_TYPE);
        AotUtil.emitInvokeVirtual((MethodVisitor)asm, AotMethodRefs.TABLE_INSTANCE);
        asm.store(refInstance, InstructionAdapter.OBJECT_TYPE);
        Label local = new Label();
        Label other = new Label();
        asm.load(refInstance, InstructionAdapter.OBJECT_TYPE);
        asm.ifnull(local);
        asm.load(refInstance, InstructionAdapter.OBJECT_TYPE);
        asm.load(instance, InstructionAdapter.OBJECT_TYPE);
        asm.ifacmpne(other);
        asm.mark(local);
        int slot = 0;
        for (ValueType param : type.params()) {
            asm.load(slot, AotUtil.asmType(param));
            slot += AotUtil.slotCount(param);
        }
        asm.load(memory, InstructionAdapter.OBJECT_TYPE);
        asm.load(instance, InstructionAdapter.OBJECT_TYPE);
        ArrayList<Integer> validIds = new ArrayList<Integer>();
        for (int i = 0; i < this.functionTypes.size(); ++i) {
            if (!type.equals(this.functionTypes.get(i))) continue;
            validIds.add(i);
        }
        Label invalid = new Label();
        int[] keys = validIds.stream().mapToInt(x -> x).toArray();
        Label[] labels = (Label[])validIds.stream().map(x -> new Label()).toArray(Label[]::new);
        asm.load(funcId, Type.INT_TYPE);
        asm.lookupswitch(invalid, keys, labels);
        for (int i = 0; i < validIds.size(); ++i) {
            asm.mark(labels[i]);
            AotUtil.emitInvokeFunction((MethodVisitor)asm, internalClassName, keys[i], type);
            asm.areturn(Type.getType(AotUtil.jvmReturnType(type)));
        }
        asm.mark(invalid);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.THROW_INDIRECT_CALL_TYPE_MISMATCH);
        asm.athrow();
        asm.mark(other);
        AotCompiler.emitBoxArguments(asm, type.params());
        asm.iconst(typeId);
        asm.load(funcId, Type.INT_TYPE);
        asm.load(refInstance, InstructionAdapter.OBJECT_TYPE);
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.CALL_INDIRECT);
        AotCompiler.emitUnboxResult(type, asm);
    }

    private static void compileHostFunction(int funcId, FunctionType type, InstructionAdapter asm) {
        int slot = type.params().stream().mapToInt(AotUtil::slotCount).sum();
        asm.load(slot + 1, InstructionAdapter.OBJECT_TYPE);
        asm.iconst(funcId);
        AotCompiler.emitBoxArguments(asm, type.params());
        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.CALL_HOST_FUNCTION);
        AotCompiler.emitUnboxResult(type, asm);
    }

    private static void emitBoxArguments(InstructionAdapter asm, List<ValueType> types) {
        int slot = 0;
        asm.iconst(types.size());
        asm.newarray(Type.LONG_TYPE);
        for (int i = 0; i < types.size(); ++i) {
            asm.dup();
            asm.iconst(i);
            ValueType valueType = types.get(i);
            asm.load(slot, AotUtil.asmType(valueType));
            AotUtil.emitJvmToLong((MethodVisitor)asm, valueType);
            asm.astore(Type.LONG_TYPE);
            slot += AotUtil.slotCount(valueType);
        }
    }

    private static void emitUnboxResult(FunctionType type, InstructionAdapter asm) {
        Class<?> returnType = AotUtil.jvmReturnType(type);
        if (returnType == Void.TYPE) {
            asm.areturn(Type.VOID_TYPE);
        } else if (returnType == long[].class) {
            asm.areturn(InstructionAdapter.OBJECT_TYPE);
        } else {
            asm.iconst(0);
            asm.aload(Type.LONG_TYPE);
            AotUtil.emitLongToJvm((MethodVisitor)asm, (ValueType)type.returns().get(0));
            asm.areturn(Type.getType(returnType));
        }
    }

    private void compileFunction(String internalClassName, int funcId, FunctionType type, FunctionBody body, InstructionAdapter asm) {
        AotContext ctx = new AotContext(internalClassName, this.analyzer.globalTypes(), this.functionTypes, this.module.typeSection().types(), funcId, type, body);
        List<AotInstruction> instructions = this.analyzer.analyze(funcId);
        int localsCount = type.params().size() + body.localTypes().size();
        for (int i = type.params().size(); i < localsCount; ++i) {
            ValueType localType = AotUtil.localType(type, body, i);
            asm.visitLdcInsn(AotUtil.defaultValue(localType));
            asm.store(ctx.localSlotIndex(i), AotUtil.asmType(localType));
        }
        HashMap<Long, Label> labels = new HashMap<Long, Label>();
        for (AotInstruction ins : instructions) {
            for (long target : ins.labelTargets()) {
                labels.put(target, new Label());
            }
        }
        HashSet<Long> visitedTargets = new HashSet<Long>();
        block10: for (AotInstruction ins : instructions) {
            switch (ins.opcode()) {
                case LABEL: {
                    Label label = (Label)labels.get(ins.operand(0));
                    if (label == null) continue block10;
                    asm.mark(label);
                    visitedTargets.add(ins.operand(0));
                    continue block10;
                }
                case GOTO: {
                    if (visitedTargets.contains(ins.operand(0))) {
                        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.CHECK_INTERRUPTION);
                    }
                    asm.goTo((Label)labels.get(ins.operand(0)));
                    continue block10;
                }
                case IFEQ: {
                    if (visitedTargets.contains(ins.operand(0))) {
                        throw new ChicoryException("Unexpected backward jump");
                    }
                    asm.ifeq((Label)labels.get(ins.operand(0)));
                    continue block10;
                }
                case IFNE: {
                    if (visitedTargets.contains(ins.operand(0))) {
                        Label skip = new Label();
                        asm.ifeq(skip);
                        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.CHECK_INTERRUPTION);
                        asm.goTo((Label)labels.get(ins.operand(0)));
                        asm.mark(skip);
                        continue block10;
                    }
                    asm.ifne((Label)labels.get(ins.operand(0)));
                    continue block10;
                }
                case SWITCH: {
                    if (ins.operands().anyMatch(visitedTargets::contains)) {
                        AotUtil.emitInvokeStatic((MethodVisitor)asm, AotMethodRefs.CHECK_INTERRUPTION);
                    }
                    Label[] table = new Label[ins.operandCount() - 1];
                    for (int i = 0; i < table.length; ++i) {
                        table[i] = (Label)labels.get(ins.operand(i));
                    }
                    Label defaultLabel = (Label)labels.get(ins.operand(table.length));
                    asm.tableswitch(0, table.length - 1, defaultLabel, table);
                    continue block10;
                }
            }
            AotEmitters.BytecodeEmitter emitter = AotEmitterMap.EMITTERS.get((Object)ins.opcode());
            if (emitter == null) {
                throw new ChicoryException("Unhandled opcode: " + String.valueOf((Object)ins.opcode()));
            }
            emitter.emit(ctx, ins, asm);
        }
    }

    private static String callMethodName(int funcId) {
        return "call_" + funcId;
    }

    private static String callDispatchMethodName(int start) {
        return "call_dispatch_" + start;
    }
}

