/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.experimental.aot;

import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.OpCode;
import com.dylibso.chicory.wasm.types.ValueType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

final class TypeStack {
    public static final Instruction FUNCTION_SCOPE = new Instruction(-1, OpCode.NOP, Instruction.EMPTY_OPERANDS);
    private final Deque<Deque<ValueType>> types = new ArrayDeque<Deque<ValueType>>();
    private final Deque<Deque<ValueType>> restore = new ArrayDeque<Deque<ValueType>>();
    private final Map<Instruction, Integer> scopes = new HashMap<Instruction, Integer>();

    public TypeStack() {
        this.types.push(new ArrayDeque());
    }

    public ValueType peek() {
        return this.types().getFirst();
    }

    public void push(ValueType type) {
        this.types().push(type);
    }

    public void pop(ValueType expected) {
        ValueType actual = this.types().pop();
        if (expected != actual) {
            throw new IllegalArgumentException("Expected type " + String.valueOf(expected) + " <> " + String.valueOf(actual));
        }
    }

    public void popRef() {
        ValueType actual = this.types().pop();
        if (actual != ValueType.FuncRef && actual != ValueType.ExternRef) {
            throw new IllegalArgumentException("Expected reference type <> " + String.valueOf(actual));
        }
    }

    public void pushTypes() {
        this.types.push(new ArrayDeque<ValueType>(this.types()));
    }

    public void popTypes() {
        this.types.pop();
    }

    public void enterScope(Instruction scope, FunctionType scopeType) {
        this.scopes.put(scope, this.types().size());
        ArrayDeque<ValueType> stack = new ArrayDeque<ValueType>(this.types());
        for (int i = 0; i < scopeType.params().size(); ++i) {
            stack.pop();
        }
        for (ValueType type : scopeType.returns()) {
            stack.push(type);
        }
        this.restore.push(stack);
    }

    public void exitScope(Instruction scope) {
        this.scopes.remove(scope);
        this.restore.pop();
    }

    public void scopeRestore() {
        this.types.pop();
        this.types.push(this.restore.getFirst());
    }

    public int scopeStackSize(Instruction scope) {
        return this.scopes.get(scope);
    }

    public Deque<ValueType> types() {
        return this.types.getFirst();
    }

    public void verifyEmpty() {
        if (this.types.size() != 1) {
            throw new RuntimeException("Bad types stack: " + String.valueOf(this.types));
        }
        if (!this.types().isEmpty()) {
            throw new RuntimeException("Types not empty: " + String.valueOf(this.types()));
        }
    }
}

