/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.build.time.compiler;

import com.dylibso.chicory.compiler.InterpreterFallback;
import java.nio.file.Path;
import java.util.Set;
import java.util.StringJoiner;

public final class Config {
    private final Path wasmFile;
    private final String name;
    private final Path targetClassFolder;
    private final Path targetSourceFolder;
    private final Path targetWasmFolder;
    public final InterpreterFallback interpreterFallback;
    private final Set<Integer> interpretedFunctions;

    private Config(Path wasmFile, String name, Path targetClassFolder, Path targetSourceFolder, Path targetWasmFolder, InterpreterFallback interpreterFallback, Set<Integer> interpretedFunctions) {
        this.wasmFile = wasmFile;
        this.name = name;
        this.targetClassFolder = targetClassFolder;
        this.targetSourceFolder = targetSourceFolder;
        this.targetWasmFolder = targetWasmFolder;
        this.interpreterFallback = interpreterFallback;
        this.interpretedFunctions = interpretedFunctions;
    }

    public Path wasmFile() {
        return this.wasmFile;
    }

    public String name() {
        return this.name;
    }

    public Path targetClassFolder() {
        return this.targetClassFolder;
    }

    public Path targetSourceFolder() {
        return this.targetSourceFolder;
    }

    public Path targetWasmFolder() {
        return this.targetWasmFolder;
    }

    public InterpreterFallback interpreterFallback() {
        return this.interpreterFallback;
    }

    public Set<Integer> interpretedFunctions() {
        return this.interpretedFunctions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPackageName() {
        String[] split = this.name.split("\\.");
        StringJoiner packageName = new StringJoiner(".");
        for (int i = 0; i < split.length - 1; ++i) {
            packageName.add(split[i]);
        }
        return packageName.toString();
    }

    public String getBaseName() {
        String[] split = this.name.split("\\.");
        return split[split.length - 1];
    }

    public static final class Builder {
        private Path wasmFile;
        private String name;
        private Path targetClassFolder;
        private Path targetSourceFolder;
        private Path targetWasmFolder;
        private InterpreterFallback interpreterFallback = InterpreterFallback.FAIL;
        private Set<Integer> interpretedFunctions;

        private Builder() {
        }

        public Builder withWasmFile(Path wasmFile) {
            this.wasmFile = wasmFile;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withTargetClassFolder(Path targetClassFolder) {
            this.targetClassFolder = targetClassFolder;
            return this;
        }

        public Builder withTargetSourceFolder(Path targetSourceFolder) {
            this.targetSourceFolder = targetSourceFolder;
            return this;
        }

        public Builder withTargetWasmFolder(Path targetWasmFolder) {
            this.targetWasmFolder = targetWasmFolder;
            return this;
        }

        public Builder withInterpreterFallback(InterpreterFallback interpreterFallback) {
            this.interpreterFallback = interpreterFallback;
            return this;
        }

        public Builder withInterpretedFunctions(Set<Integer> interpretedFunctions) {
            this.interpretedFunctions = interpretedFunctions;
            return this;
        }

        public Config build() {
            return new Config(this.wasmFile, this.name, this.targetClassFolder, this.targetSourceFolder, this.targetWasmFolder, this.interpreterFallback, this.interpretedFunctions);
        }
    }
}

