/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.build.time.compiler;

import com.dylibso.chicory.build.time.compiler.Config;
import com.dylibso.chicory.compiler.internal.ByteClassCollector;
import com.dylibso.chicory.compiler.internal.Compiler;
import com.dylibso.chicory.compiler.internal.CompilerResult;
import com.dylibso.chicory.runtime.CompiledModule;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Machine;
import com.dylibso.chicory.wasm.Encoding;
import com.dylibso.chicory.wasm.Parser;
import com.dylibso.chicory.wasm.WasmModule;
import com.dylibso.chicory.wasm.WasmWriter;
import com.dylibso.chicory.wasm.types.OpCode;
import com.dylibso.chicory.wasm.types.RawSection;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.ThrowStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.utils.SourceRoot;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class Generator {
    private final Config config;

    public Generator(Config config) {
        this.config = config;
    }

    public Set<Integer> generateResources() throws IOException {
        WasmModule module = Parser.parse((Path)this.config.wasmFile());
        String machineName = this.config.name() + "Machine";
        Compiler compiler = Compiler.builder((WasmModule)module).withClassName(machineName).withClassCollectorFactory(ByteClassCollector::new).withInterpreterFallback(this.config.interpreterFallback()).withInterpretedFunctions(this.config.interpretedFunctions()).build();
        CompilerResult result = compiler.compile();
        Path finalFolder = this.config.targetClassFolder();
        Generator.createFolders(finalFolder, this.config.name().split("\\."));
        for (Map.Entry entry : result.classBytes().entrySet()) {
            String binaryName = ((String)entry.getKey()).replace('.', '/') + ".class";
            Path targetFile = this.config.targetClassFolder().resolve(binaryName);
            Files.write(targetFile, (byte[])entry.getValue(), new OpenOption[0]);
        }
        return result.interpretedFunctions();
    }

    public void generateSources() throws IOException {
        String baseName;
        String machineName = this.config.name() + "Machine";
        String[] split = this.config.name().split("\\.");
        Path finalSourceFolder = this.config.targetSourceFolder();
        Generator.createFolders(finalSourceFolder, split);
        String packageName = this.config.getPackageName();
        SourceRoot dest = new SourceRoot(finalSourceFolder);
        String moduleName = baseName = this.config.getBaseName();
        String wasmName = baseName + ".meta";
        CompilationUnit cu = new CompilationUnit(packageName);
        ClassOrInterfaceDeclaration type = cu.addClass(moduleName, new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.FINAL});
        type.addImplementedType(CompiledModule.class);
        type.addConstructor(new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).createBody();
        Generator.generateCreateMethod(cu, type, machineName);
        Generator.generateWasmModuleHolderInnerClass(type, moduleName, wasmName);
        Generator.generateLoadMethod(cu, type);
        Generator.generateMachineFactoryMethod(cu, type, moduleName);
        Generator.generateWasmModuleMethod(cu, type, moduleName);
        dest.add(packageName, moduleName + ".java", cu);
        dest.saveAll();
    }

    public void generateMetaWasm(Set<Integer> interpretedFunctions) throws IOException {
        byte[] wasmBytes = Files.readAllBytes(this.config.wasmFile());
        Parser.builder().includeSectionId(10).build();
        WasmModule module = Parser.parse((byte[])wasmBytes);
        WasmWriter writer = new WasmWriter();
        Parser.parseWithoutDecoding((byte[])wasmBytes, section -> {
            if (section.sectionId() == 10) {
                ByteBuffer source = ByteBuffer.wrap(((RawSection)section).contents());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                int importFuncs = module.importSection().importCount();
                int count = module.codeSection().functionBodyCount();
                WasmWriter.writeVarUInt32((ByteArrayOutputStream)out, (int)count);
                long actual = Encoding.readVarUInt32((ByteBuffer)source);
                assert ((long)count == actual);
                for (int i = 0; i < count; ++i) {
                    int bodySize;
                    int funcId = importFuncs + i;
                    if (interpretedFunctions.contains(funcId)) {
                        bodySize = (int)Encoding.readVarUInt32((ByteBuffer)source);
                        WasmWriter.writeVarUInt32((ByteArrayOutputStream)out, (int)bodySize);
                        byte[] bodyBytes = new byte[bodySize];
                        source.get(bodyBytes);
                        try {
                            out.write(bodyBytes);
                            continue;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    bodySize = (int)Encoding.readVarUInt32((ByteBuffer)source);
                    source.position(source.position() + bodySize - 1);
                    byte end_op = source.get();
                    assert (end_op == OpCode.END.opcode());
                    WasmWriter.writeVarUInt32((ByteArrayOutputStream)out, (int)3);
                    WasmWriter.writeVarUInt32((ByteArrayOutputStream)out, (int)0);
                    out.write(OpCode.UNREACHABLE.opcode());
                    out.write(OpCode.END.opcode());
                }
                writer.writeSection(10, out.toByteArray());
            } else if (section.sectionId() != 0) {
                writer.writeSection((RawSection)section);
            }
        });
        Path newWasmFile = this.config.targetWasmFolder().resolve(this.config.getPackageName().replace('.', '/')).resolve(this.config.getBaseName() + ".meta");
        Files.createDirectories(newWasmFile.getParent(), new FileAttribute[0]);
        Files.write(newWasmFile, writer.bytes(), new OpenOption[0]);
    }

    private static void createFolders(Path filesFolder, String[] split) throws IOException {
        for (int i = 0; i < split.length - 1; ++i) {
            filesFolder = filesFolder.resolve(split[i]);
        }
        Files.createDirectories(filesFolder, new FileAttribute[0]);
    }

    private static void generateCreateMethod(CompilationUnit cu, ClassOrInterfaceDeclaration type, String machineName) {
        cu.addImport(Instance.class);
        cu.addImport(Machine.class);
        BlockStmt method = ((MethodDeclaration)((MethodDeclaration)type.addMethod("create", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC}).addParameter(StaticJavaParser.parseType((String)"Instance"), "instance")).setType(Machine.class)).createBody();
        ObjectCreationExpr constructorInvocation = new ObjectCreationExpr(null, StaticJavaParser.parseClassOrInterfaceType((String)machineName), NodeList.nodeList((Node[])new Expression[]{new NameExpr("instance")}));
        method.addStatement((Statement)new ReturnStmt((Expression)constructorInvocation));
    }

    private static void generateWasmModuleHolderInnerClass(ClassOrInterfaceDeclaration type, String moduleName, String wasmName) {
        ClassOrInterfaceDeclaration holderClass = new ClassOrInterfaceDeclaration(NodeList.nodeList((Node[])new Modifier[]{new Modifier(Modifier.Keyword.PRIVATE), new Modifier(Modifier.Keyword.STATIC)}), false, "WasmModuleHolder");
        type.addMember((BodyDeclaration)holderClass);
        holderClass.addField(WasmModule.class, "INSTANCE", new Modifier.Keyword[]{Modifier.Keyword.STATIC, Modifier.Keyword.FINAL});
        MethodCallExpr getResource = new MethodCallExpr((Expression)new ClassExpr(StaticJavaParser.parseType((String)moduleName)), "getResourceAsStream", new NodeList((Node[])new Expression[]{new StringLiteralExpr(wasmName)}));
        VariableDeclarationExpr resourceVar = new VariableDeclarationExpr(new VariableDeclarator(StaticJavaParser.parseType((String)"InputStream"), "in", (Expression)getResource));
        ExpressionStmt assignmentStmt = new ExpressionStmt((Expression)new AssignExpr((Expression)new NameExpr("INSTANCE"), (Expression)((MethodCallExpr)new MethodCallExpr().setScope((Expression)new NameExpr("Parser")).setName("parse")).addArgument((Expression)new NameExpr("in")), AssignExpr.Operator.ASSIGN));
        ObjectCreationExpr newException = (ObjectCreationExpr)((ObjectCreationExpr)new ObjectCreationExpr().setType(StaticJavaParser.parseClassOrInterfaceType((String)"UncheckedIOException")).addArgument((Expression)new StringLiteralExpr("Failed to load .meta WASM module"))).addArgument((Expression)new NameExpr("e"));
        CatchClause catchIoException = new CatchClause().setParameter(new Parameter((Type)StaticJavaParser.parseClassOrInterfaceType((String)"IOException"), "e")).setBody(new BlockStmt(new NodeList((Node[])new Statement[]{new ThrowStmt((Expression)newException)})));
        TryStmt staticInitializerBlock = new TryStmt().setResources(new NodeList((Node[])new Expression[]{resourceVar})).setTryBlock(new BlockStmt(new NodeList((Node[])new Statement[]{assignmentStmt}))).setCatchClauses(new NodeList((Node[])new CatchClause[]{catchIoException}));
        BlockStmt staticInitializer = holderClass.addStaticInitializer();
        staticInitializer.addStatement((Statement)staticInitializerBlock);
    }

    private static void generateLoadMethod(CompilationUnit cu, ClassOrInterfaceDeclaration type) {
        cu.addImport(IOException.class);
        cu.addImport(UncheckedIOException.class);
        cu.addImport(Parser.class);
        cu.addImport(WasmModule.class);
        cu.addImport(InputStream.class);
        cu.addImport(ExceptionInInitializerError.class);
        BlockStmt method = ((MethodDeclaration)type.addMethod("load", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC, Modifier.Keyword.STATIC}).setType(WasmModule.class)).createBody();
        method.addStatement((Statement)new ReturnStmt((Expression)new FieldAccessExpr((Expression)new NameExpr("WasmModuleHolder"), "INSTANCE")));
    }

    private static void generateMachineFactoryMethod(CompilationUnit cu, ClassOrInterfaceDeclaration type, String moduleName) {
        cu.addImport(Instance.class);
        cu.addImport(Machine.class);
        cu.addImport(Function.class);
        ClassOrInterfaceType functionType = StaticJavaParser.parseClassOrInterfaceType((String)"Function<Instance, Machine>");
        MethodDeclaration method = type.addMethod("machineFactory", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType((Type)functionType);
        ReturnStmt returnStmt = new ReturnStmt((Expression)new MethodReferenceExpr().setScope((Expression)new NameExpr(moduleName)).setIdentifier("create"));
        method.createBody().addStatement((Statement)returnStmt);
    }

    private static void generateWasmModuleMethod(CompilationUnit cu, ClassOrInterfaceDeclaration type, String moduleName) {
        cu.addImport(WasmModule.class);
        MethodDeclaration method = (MethodDeclaration)type.addMethod("wasmModule", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType(WasmModule.class);
        ReturnStmt returnStmt = new ReturnStmt((Expression)new MethodCallExpr().setScope((Expression)new NameExpr(moduleName)).setName("load"));
        method.createBody().addStatement((Statement)returnStmt);
    }
}

