/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.compiler.internal;

import com.dylibso.chicory.compiler.InterpreterFallback;
import com.dylibso.chicory.compiler.internal.CompilerInstruction;
import com.dylibso.chicory.compiler.internal.CompilerResult;
import com.dylibso.chicory.compiler.internal.CompilerUtil;
import com.dylibso.chicory.compiler.internal.Context;
import com.dylibso.chicory.compiler.internal.EmitterMap;
import com.dylibso.chicory.compiler.internal.Emitters;
import com.dylibso.chicory.compiler.internal.ShadedRefs;
import com.dylibso.chicory.compiler.internal.Shader;
import com.dylibso.chicory.compiler.internal.WasmAnalyzer;
import com.dylibso.chicory.compiler.internal.WasmClassLoader;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Machine;
import com.dylibso.chicory.runtime.Memory;
import com.dylibso.chicory.runtime.internal.CompilerInterpreterMachine;
import com.dylibso.chicory.wasm.ChicoryException;
import com.dylibso.chicory.wasm.WasmModule;
import com.dylibso.chicory.wasm.types.ExternalType;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.ValType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassTooLargeException;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodTooLargeException;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.util.CheckClassAdapter;

public final class Compiler {
    public static final String DEFAULT_CLASS_NAME = "com.dylibso.chicory.$gen.CompiledMachine";
    private static final Type LONG_ARRAY_TYPE = Type.getType(long[].class);
    private static final Type INT_ARRAY_TYPE = Type.getType(int[].class);
    private static final Type AOT_INTERPRETER_MACHINE_TYPE = Type.getType(CompilerInterpreterMachine.class);
    private static final Type INSTANCE_TYPE = Type.getType(Instance.class);
    private static final MethodType CALL_METHOD_TYPE = MethodType.methodType(long[].class, Instance.class, Memory.class, long[].class);
    private static final MethodType MACHINE_CALL_METHOD_TYPE = MethodType.methodType(long[].class, Instance.class, Memory.class, Integer.TYPE, long[].class);
    private static final int MAX_MACHINE_CALL_METHODS = 1024;
    private static final int DEFAULT_MAX_FUNCTIONS_PER_CLASS = 12288;
    private final WasmClassLoader classLoader = new WasmClassLoader();
    private final String className;
    private final WasmModule module;
    private final WasmAnalyzer analyzer;
    private final int functionImports;
    private final InterpreterFallback interpreterFallback;
    private final List<FunctionType> functionTypes;
    private final Map<String, byte[]> extraClasses = new LinkedHashMap<String, byte[]>();
    private int maxFunctionsPerClass;
    private final HashSet<Integer> interpretedFunctions;

    private Compiler(WasmModule module, String className, int maxFunctionsPerClass, InterpreterFallback interpreterFallback, Set<Integer> interpretedFunctions) {
        this.className = Objects.requireNonNull(className, "className");
        this.module = Objects.requireNonNull(module, "module");
        this.analyzer = new WasmAnalyzer(module);
        this.functionImports = module.importSection().count(ExternalType.FUNCTION);
        if (interpretedFunctions == null || interpretedFunctions.isEmpty()) {
            this.interpretedFunctions = new HashSet();
            this.interpreterFallback = Objects.requireNonNullElse(interpreterFallback, InterpreterFallback.WARN);
        } else {
            if (interpreterFallback != InterpreterFallback.FAIL) {
                throw new IllegalArgumentException("InterpreterFallback must be set to FAIL if a fixed set of interpreted functions is provided");
            }
            this.interpretedFunctions = new HashSet<Integer>(interpretedFunctions);
            this.interpreterFallback = InterpreterFallback.FAIL;
        }
        this.functionTypes = this.analyzer.functionTypes();
        this.maxFunctionsPerClass = maxFunctionsPerClass;
        this.compileExtraClasses();
    }

    public static Builder builder(WasmModule module) {
        return new Builder(module);
    }

    public CompilerResult compile() {
        byte[] bytes = this.compileClass();
        Function<Instance, Machine> factory = this.createMachineFactory(bytes);
        LinkedHashMap<String, byte[]> classBytes = new LinkedHashMap<String, byte[]>();
        classBytes.put(this.className, bytes);
        classBytes.putAll(this.extraClasses);
        return new CompilerResult(factory, classBytes, Set.copyOf(this.interpretedFunctions));
    }

    private Function<Instance, Machine> createMachineFactory(byte[] classBytes) {
        try {
            Class<Machine> clazz = this.loadClass(classBytes).asSubclass(Machine.class);
            Constructor<Machine> constructor = clazz.getConstructor(Instance.class);
            MethodHandle handle = MethodHandles.publicLookup().unreflectConstructor(constructor);
            Function function = MethodHandleProxies.asInterfaceInstance(Function.class, handle);
            return function;
        }
        catch (ReflectiveOperationException e) {
            throw new ChicoryException((Throwable)e);
        }
    }

    private Class<?> loadClass(byte[] classBytes) {
        return this.loadClass(this.classLoader, classBytes);
    }

    private Class<?> loadClass(WasmClassLoader classLoader, byte[] classBytes) {
        try {
            Class<?> clazz = classLoader.loadFromBytes(classBytes);
            Class.forName(clazz.getName(), true, clazz.getClassLoader());
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        catch (VerifyError e) {
            try {
                StringWriter out = new StringWriter().append("ASM verifier:\n\n");
                CheckClassAdapter.verify((ClassReader)new ClassReader(classBytes), (boolean)true, (PrintWriter)new PrintWriter(out));
                e.addSuppressed(new RuntimeException(out.toString()));
            }
            catch (Throwable t) {
                e.addSuppressed(t);
            }
            throw e;
        }
    }

    private String loadExtraClass(byte[] bytes) {
        Class<?> clazz = this.loadClass(bytes);
        this.extraClasses.put(clazz.getName(), bytes);
        return clazz.getName();
    }

    private void compileExtraClasses() {
        this.loadExtraClass(Shader.createShadedClass(this.className));
        int totalFunctions = this.functionImports + this.module.functionSection().functionCount();
        int originalMaxFunctionsPerClass = this.maxFunctionsPerClass;
        while (true) {
            try {
                this.maxFunctionsPerClass = this.loadChunkedClass(totalFunctions, this.maxFunctionsPerClass, (start, end, chunkSize) -> {
                    this.maxFunctionsPerClass = chunkSize;
                    String className = this.classNameForFuncGroup(start);
                    return this.compileExtraClass(className, this.emitFunctionGroup(start, end, CompilerUtil.internalClassName(this.className)));
                });
            }
            catch (MethodTooLargeException e) {
                String methodName = e.getMethodName();
                if (methodName.startsWith("func_")) {
                    String name;
                    int funcId = Integer.parseInt(methodName.substring("func_".length()));
                    String functionDescription = "WASM function index: " + funcId;
                    if (this.module.nameSection() != null && (name = this.module.nameSection().nameOfFunction(funcId)) != null) {
                        functionDescription = functionDescription + String.format(" (name: %s)", name);
                    }
                    switch (this.interpreterFallback) {
                        case SILENT: {
                            break;
                        }
                        case WARN: {
                            System.err.println("Warning: using interpreted mode for " + functionDescription);
                            break;
                        }
                        case FAIL: {
                            throw new ChicoryException("WASM function size exceeds the Java method size limits and cannot be compiled to Java bytecode. It can only be run in the interpreter. Either reduce the size of the function or enable the interpreter fallback mode: " + functionDescription, (Throwable)e);
                        }
                    }
                    this.interpretedFunctions.add(funcId);
                    this.maxFunctionsPerClass = originalMaxFunctionsPerClass;
                    continue;
                }
                throw e;
            }
            break;
        }
        if (!this.functionTypes.isEmpty()) {
            this.loadExtraClass(this.compileMachineCallClass());
        }
    }

    int loadChunkedClass(int size, int chunkSize, ChunkedClassEmitter emitter) {
        ArrayList<byte[]> generated = new ArrayList<byte[]>();
        WasmClassLoader classLoader = new WasmClassLoader();
        while (true) {
            try {
                int chunks = size / chunkSize + (size % chunkSize == 0 ? 0 : 1);
                for (int i = 0; i < chunks; ++i) {
                    int start = i * chunkSize;
                    int end = Math.min(start + chunkSize, size);
                    byte[] bytes = emitter.emit(start, end, chunkSize);
                    this.loadClass(classLoader, bytes);
                    generated.add(bytes);
                }
            }
            catch (ClassTooLargeException e) {
                if ((chunkSize >>= 1) == 0) {
                    throw e;
                }
                generated.clear();
                classLoader = new WasmClassLoader();
                continue;
            }
            break;
        }
        for (byte[] bytes : generated) {
            this.loadExtraClass(bytes);
        }
        return chunkSize;
    }

    private String classNameForFuncGroup(int funcId) {
        return "FuncGroup_" + funcId / this.maxFunctionsPerClass;
    }

    private Consumer<ClassVisitor> emitFunctionGroup(int start, int end, String internalClassName) {
        return classWriter -> {
            for (int i = start; i < end; ++i) {
                FunctionBody body = null;
                try {
                    int funcId = i;
                    FunctionType type = this.functionTypes.get(funcId);
                    if (i < this.functionImports) {
                        Compiler.emitFunction(classWriter, CompilerUtil.methodNameForFunc(funcId), CompilerUtil.methodTypeFor(type), true, asm -> Compiler.compileHostFunction(funcId, type, asm));
                        continue;
                    }
                    FunctionBody bodyCopy = body = this.module.codeSection().getFunctionBody(i - this.functionImports);
                    Compiler.emitFunction(classWriter, CompilerUtil.methodNameForFunc(funcId), CompilerUtil.methodTypeFor(type), true, asm -> this.compileFunction(internalClassName, funcId, type, bodyCopy, (InstructionAdapter)asm));
                    Compiler.emitFunction(classWriter, CompilerUtil.callMethodName(funcId), CALL_METHOD_TYPE, true, asm -> this.compileCallFunction(funcId, type, (InstructionAdapter)asm));
                    continue;
                }
                catch (MethodTooLargeException e) {
                    throw Compiler.handleMethodTooLarge(e, this.module);
                }
            }
        };
    }

    private byte[] compileClass() {
        String internalClassName = CompilerUtil.internalClassName(this.className);
        ClassWriter binaryWriter = new ClassWriter(2);
        ClassRemapper classWriter = Shader.shadedClassRemapper((ClassVisitor)binaryWriter, this.className);
        classWriter.visit(55, 49, internalClassName, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(Machine.class)});
        classWriter.visitSource("wasm", null);
        classWriter.visitField(18, "instance", Type.getDescriptor(Instance.class), null, null);
        if (!this.interpretedFunctions.isEmpty()) {
            classWriter.visitField(18, "compilerInterpreterMachine", Type.getDescriptor(CompilerInterpreterMachine.class), null, null);
        }
        Compiler.emitFunction((ClassVisitor)classWriter, "<init>", MethodType.methodType(Void.TYPE, Instance.class), false, asm -> this.compileConstructor((InstructionAdapter)asm, internalClassName));
        Compiler.emitFunction((ClassVisitor)classWriter, "call", MethodType.methodType(long[].class, Integer.TYPE, long[].class), false, asm -> this.compileMachineCall(internalClassName, (InstructionAdapter)asm));
        FunctionType[] allTypes = this.module.typeSection().types();
        for (int i = 0; i < allTypes.length; ++i) {
            int typeId = i;
            FunctionType type = allTypes[i];
            Compiler.emitFunction((ClassVisitor)classWriter, CompilerUtil.callIndirectMethodName(typeId), CompilerUtil.callIndirectMethodType(type), true, asm -> this.compileCallIndirect(internalClassName, typeId, type, (InstructionAdapter)asm));
        }
        Set returnTypes = this.functionTypes.stream().map(FunctionType::returns).filter(types -> types.size() > 1).collect(Collectors.toSet());
        for (List types2 : returnTypes) {
            Compiler.emitFunction((ClassVisitor)classWriter, CompilerUtil.valueMethodName(types2), CompilerUtil.valueMethodType(types2), true, asm -> {
                Compiler.emitBoxArguments(asm, types2);
                asm.areturn(InstructionAdapter.OBJECT_TYPE);
            });
        }
        classWriter.visitEnd();
        try {
            return binaryWriter.toByteArray();
        }
        catch (MethodTooLargeException e) {
            throw Compiler.handleMethodTooLarge(e, this.module);
        }
    }

    private static RuntimeException handleMethodTooLarge(MethodTooLargeException e, WasmModule module) {
        Object name = e.getMethodName();
        if (((String)name).startsWith("func_") && module.nameSection() != null) {
            int funcId = Integer.parseInt(((String)name).split("_", -1)[1]);
            String function = module.nameSection().nameOfFunction(funcId);
            if (function != null) {
                name = (String)name + " (" + function + ")";
            }
        }
        return new ChicoryException(String.format("JVM bytecode too large for WASM method: %s size=%d", name, e.getCodeSize()), (Throwable)e);
    }

    private static void emitFunction(ClassVisitor classWriter, String methodName, MethodType methodType, boolean isStatic, Consumer<InstructionAdapter> consumer) {
        MethodVisitor methodWriter = classWriter.visitMethod(1 | (isStatic ? 8 : 0), methodName, methodType.toMethodDescriptorString(), null, null);
        methodWriter.visitCode();
        consumer.accept(new InstructionAdapter(methodWriter));
        methodWriter.visitMaxs(0, 0);
        methodWriter.visitEnd();
    }

    private static void emitCallSuper(InstructionAdapter asm) {
        asm.load(0, InstructionAdapter.OBJECT_TYPE);
        asm.invokespecial(InstructionAdapter.OBJECT_TYPE.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
    }

    private void compileConstructor(InstructionAdapter asm, String internalClassName) {
        Compiler.emitCallSuper(asm);
        asm.load(0, InstructionAdapter.OBJECT_TYPE);
        asm.load(1, InstructionAdapter.OBJECT_TYPE);
        asm.putfield(internalClassName, "instance", Type.getDescriptor(Instance.class));
        if (!this.interpretedFunctions.isEmpty()) {
            asm.load(0, InstructionAdapter.OBJECT_TYPE);
            asm.anew(AOT_INTERPRETER_MACHINE_TYPE);
            asm.dup();
            asm.load(1, InstructionAdapter.OBJECT_TYPE);
            ArrayList<Integer> funcIds = new ArrayList<Integer>(this.interpretedFunctions);
            asm.iconst(funcIds.size());
            asm.newarray(Type.INT_TYPE);
            for (int i = 0; i < funcIds.size(); ++i) {
                asm.dup();
                asm.iconst(i);
                asm.iconst(funcIds.get(i).intValue());
                asm.astore(Type.INT_TYPE);
            }
            asm.invokespecial(AOT_INTERPRETER_MACHINE_TYPE.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{INSTANCE_TYPE, INT_ARRAY_TYPE}), false);
            asm.putfield(internalClassName, "compilerInterpreterMachine", Type.getDescriptor(CompilerInterpreterMachine.class));
        }
        asm.areturn(Type.VOID_TYPE);
    }

    private void compileMachineCall(String internalClassName, InstructionAdapter asm) {
        if (this.functionTypes.isEmpty()) {
            asm.load(1, Type.INT_TYPE);
            CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.THROW_UNKNOWN_FUNCTION);
            asm.athrow();
            return;
        }
        if (!this.interpretedFunctions.isEmpty()) {
            Label invalid = new Label();
            int[] keys = this.interpretedFunctions.stream().mapToInt(x -> x).sorted().toArray();
            Label[] labels = (Label[])this.interpretedFunctions.stream().map(x -> new Label()).toArray(Label[]::new);
            asm.load(1, Type.INT_TYPE);
            asm.lookupswitch(invalid, keys, labels);
            for (int i = 0; i < this.interpretedFunctions.size(); ++i) {
                asm.mark(labels[i]);
                asm.load(0, InstructionAdapter.OBJECT_TYPE);
                asm.getfield(internalClassName, "compilerInterpreterMachine", Type.getDescriptor(CompilerInterpreterMachine.class));
                asm.load(1, Type.INT_TYPE);
                asm.load(2, InstructionAdapter.OBJECT_TYPE);
                asm.visitMethodInsn(182, AOT_INTERPRETER_MACHINE_TYPE.getInternalName(), "call", Type.getMethodDescriptor((Method)ShadedRefs.AOT_INTERPRETER_MACHINE_CALL), false);
                asm.areturn(InstructionAdapter.OBJECT_TYPE);
            }
            asm.mark(invalid);
        }
        Label start = new Label();
        Label end = new Label();
        asm.visitTryCatchBlock(start, end, end, Type.getInternalName(StackOverflowError.class));
        asm.mark(start);
        asm.load(0, InstructionAdapter.OBJECT_TYPE);
        asm.getfield(internalClassName, "instance", Type.getDescriptor(Instance.class));
        asm.dup();
        CompilerUtil.emitInvokeVirtual((MethodVisitor)asm, ShadedRefs.INSTANCE_MEMORY);
        asm.load(1, Type.INT_TYPE);
        asm.load(2, InstructionAdapter.OBJECT_TYPE);
        asm.invokestatic(internalClassName + "MachineCall", "call", MACHINE_CALL_METHOD_TYPE.toMethodDescriptorString(), false);
        asm.areturn(InstructionAdapter.OBJECT_TYPE);
        asm.mark(end);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.THROW_CALL_STACK_EXHAUSTED);
        asm.athrow();
    }

    private byte[] compileMachineCallClass() {
        Consumer<InstructionAdapter> callMethod;
        ClassWriter binaryWriter = new ClassWriter(2);
        ClassRemapper classWriter = Shader.shadedClassRemapper((ClassVisitor)binaryWriter, this.className);
        classWriter.visit(55, 48, CompilerUtil.internalClassName(this.className + "MachineCall"), null, Type.getInternalName(Object.class), null);
        Compiler.emitFunction((ClassVisitor)classWriter, "<init>", MethodType.methodType(Void.TYPE), false, asm -> {
            Compiler.emitCallSuper(asm);
            asm.areturn(Type.VOID_TYPE);
        });
        if (this.functionTypes.size() < 1024) {
            callMethod = asm -> this.compileMachineCallInvoke((InstructionAdapter)asm, 0, this.functionTypes.size());
        } else {
            int maxMachineCallMethods = 4096;
            maxMachineCallMethods = this.loadChunkedClass(this.functionTypes.size(), maxMachineCallMethods, (start, end, chunkSize) -> this.compileExtraClass(CompilerUtil.classNameForDispatch(start), cw -> Compiler.emitFunction(cw, CompilerUtil.callDispatchMethodName(start), MACHINE_CALL_METHOD_TYPE, true, asm -> this.compileMachineCallInvoke((InstructionAdapter)asm, start, end))));
            callMethod = this.compileMachineCallDispatch(maxMachineCallMethods);
        }
        Compiler.emitFunction((ClassVisitor)classWriter, "call", MACHINE_CALL_METHOD_TYPE, true, callMethod);
        return binaryWriter.toByteArray();
    }

    private byte[] compileExtraClass(String name, Consumer<ClassVisitor> consumer) {
        ClassWriter binaryWriter = new ClassWriter(2);
        ClassRemapper classWriter = Shader.shadedClassRemapper((ClassVisitor)binaryWriter, this.className);
        String internalClassName = CompilerUtil.internalClassName(this.className + name);
        classWriter.visit(55, 48, internalClassName, null, Type.getInternalName(Object.class), null);
        consumer.accept((ClassVisitor)classWriter);
        return binaryWriter.toByteArray();
    }

    private Consumer<InstructionAdapter> compileMachineCallDispatch(int maxMachineCallMethods) {
        return asm -> {
            int i;
            asm.load(0, InstructionAdapter.OBJECT_TYPE);
            asm.load(1, InstructionAdapter.OBJECT_TYPE);
            asm.load(2, Type.INT_TYPE);
            asm.load(3, InstructionAdapter.OBJECT_TYPE);
            assert (Integer.bitCount(maxMachineCallMethods) == 1);
            int shift = Integer.numberOfTrailingZeros(maxMachineCallMethods);
            Label[] labels = new Label[(this.functionTypes.size() - 1 >> shift) + 1];
            for (i = 0; i < labels.length; ++i) {
                labels[i] = new Label();
            }
            asm.load(2, Type.INT_TYPE);
            asm.iconst(shift);
            asm.shr(Type.INT_TYPE);
            asm.tableswitch(0, labels.length - 1, labels[0], labels);
            for (i = 0; i < labels.length; ++i) {
                asm.mark(labels[i]);
                asm.invokestatic(CompilerUtil.internalClassName(this.className + CompilerUtil.classNameForDispatch(i << shift)), CompilerUtil.callDispatchMethodName(i << shift), MACHINE_CALL_METHOD_TYPE.toMethodDescriptorString(), false);
                asm.areturn(InstructionAdapter.OBJECT_TYPE);
            }
        };
    }

    private void compileMachineCallInvoke(InstructionAdapter asm, int start, int end) {
        int id;
        asm.load(0, InstructionAdapter.OBJECT_TYPE);
        asm.load(1, InstructionAdapter.OBJECT_TYPE);
        asm.load(3, InstructionAdapter.OBJECT_TYPE);
        Label defaultLabel = new Label();
        Label hostLabel = new Label();
        Label[] labels = new Label[end - start];
        for (id = start; id < end; ++id) {
            labels[id - start] = id < this.functionImports ? hostLabel : new Label();
        }
        asm.load(2, Type.INT_TYPE);
        asm.tableswitch(start, end - 1, defaultLabel, labels);
        for (id = Math.max(start, this.functionImports); id < end; ++id) {
            asm.mark(labels[id - start]);
            asm.invokestatic(CompilerUtil.internalClassName(this.className + this.classNameForFuncGroup(id)), CompilerUtil.callMethodName(id), CALL_METHOD_TYPE.toMethodDescriptorString(), false);
            asm.areturn(InstructionAdapter.OBJECT_TYPE);
        }
        if (this.functionImports > start) {
            asm.mark(hostLabel);
            asm.pop();
            asm.pop();
            asm.load(2, Type.INT_TYPE);
            asm.load(3, InstructionAdapter.OBJECT_TYPE);
            CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.CALL_HOST_FUNCTION);
            asm.areturn(InstructionAdapter.OBJECT_TYPE);
        }
        asm.mark(defaultLabel);
        asm.load(2, Type.INT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.THROW_UNKNOWN_FUNCTION);
        asm.athrow();
    }

    private void compileCallFunction(int funcId, FunctionType type, InstructionAdapter asm) {
        if (CompilerUtil.hasTooManyParameters(type)) {
            asm.load(2, LONG_ARRAY_TYPE);
        } else {
            for (int i = 0; i < type.params().size(); ++i) {
                ValType param = (ValType)type.params().get(i);
                asm.load(2, InstructionAdapter.OBJECT_TYPE);
                asm.iconst(i);
                asm.aload(Type.LONG_TYPE);
                CompilerUtil.emitLongToJvm((MethodVisitor)asm, param);
            }
        }
        asm.load(1, InstructionAdapter.OBJECT_TYPE);
        asm.load(0, InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeFunction((MethodVisitor)asm, CompilerUtil.internalClassName(this.className) + this.classNameForFuncGroup(funcId), funcId, type);
        Class<?> returnType = CompilerUtil.jvmReturnType(type);
        if (returnType == Void.TYPE) {
            asm.aconst(null);
        } else if (returnType != long[].class) {
            CompilerUtil.emitJvmToLong((MethodVisitor)asm, (ValType)type.returns().get(0));
            asm.store(3, Type.LONG_TYPE);
            asm.iconst(1);
            asm.newarray(Type.LONG_TYPE);
            asm.dup();
            asm.iconst(0);
            asm.load(3, Type.LONG_TYPE);
            asm.astore(Type.LONG_TYPE);
        }
        asm.areturn(InstructionAdapter.OBJECT_TYPE);
    }

    private void compileCallIndirect(String internalClassName, int typeId, FunctionType type, InstructionAdapter asm) {
        int slots = type.params().stream().mapToInt(CompilerUtil::slotCount).sum();
        if (CompilerUtil.hasTooManyParameters(type)) {
            slots = 1;
        }
        ArrayList<Integer> validIds = new ArrayList<Integer>();
        for (int i = 0; i < this.functionTypes.size(); ++i) {
            if (!type.equals(this.functionTypes.get(i))) continue;
            validIds.add(i);
        }
        Label invalid = new Label();
        int funcTableIdx = slots;
        int tableIdx = slots + 1;
        int memory = slots + 2;
        int instance = slots + 3;
        int table = slots + 4;
        int funcId = slots + 5;
        int refInstance = slots + 6;
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.CHECK_INTERRUPTION);
        asm.load(instance, InstructionAdapter.OBJECT_TYPE);
        asm.load(tableIdx, Type.INT_TYPE);
        CompilerUtil.emitInvokeVirtual((MethodVisitor)asm, ShadedRefs.INSTANCE_TABLE);
        asm.store(table, InstructionAdapter.OBJECT_TYPE);
        asm.load(table, InstructionAdapter.OBJECT_TYPE);
        asm.load(funcTableIdx, Type.INT_TYPE);
        CompilerUtil.emitInvokeVirtual((MethodVisitor)asm, ShadedRefs.TABLE_REQUIRED_REF);
        asm.store(funcId, Type.INT_TYPE);
        asm.load(table, InstructionAdapter.OBJECT_TYPE);
        asm.load(funcTableIdx, Type.INT_TYPE);
        CompilerUtil.emitInvokeVirtual((MethodVisitor)asm, ShadedRefs.TABLE_INSTANCE);
        asm.store(refInstance, InstructionAdapter.OBJECT_TYPE);
        Label local = new Label();
        Label other = new Label();
        asm.load(refInstance, InstructionAdapter.OBJECT_TYPE);
        asm.ifnull(local);
        asm.load(refInstance, InstructionAdapter.OBJECT_TYPE);
        asm.load(instance, InstructionAdapter.OBJECT_TYPE);
        asm.ifacmpne(other);
        asm.mark(local);
        if (CompilerUtil.hasTooManyParameters(type)) {
            asm.load(0, LONG_ARRAY_TYPE);
        } else {
            int slot = 0;
            for (ValType param : type.params()) {
                asm.load(slot, CompilerUtil.asmType(param));
                slot += CompilerUtil.slotCount(param);
            }
        }
        asm.load(memory, InstructionAdapter.OBJECT_TYPE);
        asm.load(instance, InstructionAdapter.OBJECT_TYPE);
        if (validIds.size() <= 1024) {
            int[] keys = validIds.stream().mapToInt(x -> x).toArray();
            Label[] labels = (Label[])validIds.stream().map(x -> new Label()).toArray(Label[]::new);
            asm.load(funcId, Type.INT_TYPE);
            asm.lookupswitch(invalid, keys, labels);
            for (int i = 0; i < validIds.size(); ++i) {
                asm.mark(labels[i]);
                CompilerUtil.emitInvokeFunction((MethodVisitor)asm, internalClassName + this.classNameForFuncGroup(keys[i]), keys[i], type);
                asm.areturn(Type.getType(CompilerUtil.jvmReturnType(type)));
            }
            asm.mark(invalid);
            CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.THROW_INDIRECT_CALL_TYPE_MISMATCH);
            asm.athrow();
        } else {
            int i;
            MethodType applyParams = CompilerUtil.rawMethodTypeFor(type).appendParameterTypes(Memory.class, Instance.class, Integer.TYPE);
            int maxMachineCallMethods = 4096;
            this.loadChunkedClass(this.functionTypes.size(), maxMachineCallMethods, (start, end, chunkSize) -> this.compileExtraClass(CompilerUtil.classNameForCallIndirect(typeId, start), cw -> Compiler.emitFunction(cw, "apply", applyParams, true, a -> this.compileCallIndirectApply(internalClassName, type, (InstructionAdapter)a, start, end))));
            assert (Integer.bitCount(maxMachineCallMethods) == 1);
            int shift = Integer.numberOfTrailingZeros(maxMachineCallMethods);
            Label[] labels = new Label[(this.functionTypes.size() - 1 >> shift) + 1];
            for (i = 0; i < labels.length; ++i) {
                labels[i] = new Label();
            }
            asm.load(funcId, Type.INT_TYPE);
            asm.iconst(shift);
            asm.shr(Type.INT_TYPE);
            asm.tableswitch(0, labels.length - 1, labels[0], labels);
            for (i = 0; i < labels.length; ++i) {
                asm.mark(labels[i]);
                asm.load(funcId, Type.INT_TYPE);
                asm.invokestatic(internalClassName + CompilerUtil.classNameForCallIndirect(typeId, i << shift), "apply", applyParams.toMethodDescriptorString(), false);
                asm.areturn(Type.getType(CompilerUtil.jvmReturnType(type)));
            }
        }
        asm.mark(other);
        if (CompilerUtil.hasTooManyParameters(type)) {
            asm.load(0, LONG_ARRAY_TYPE);
        } else {
            Compiler.emitBoxArguments(asm, type.params());
        }
        asm.iconst(typeId);
        asm.load(funcId, Type.INT_TYPE);
        asm.load(refInstance, InstructionAdapter.OBJECT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.CALL_INDIRECT);
        Compiler.emitUnboxResult(type, asm);
    }

    private void compileCallIndirectApply(String internalClassName, FunctionType type, InstructionAdapter asm, int startFunc, int endFunc) {
        int i;
        int slots = type.params().stream().mapToInt(CompilerUtil::slotCount).sum();
        if (CompilerUtil.hasTooManyParameters(type)) {
            slots = 1;
        }
        int memory = slots;
        int instance = slots + 1;
        int funcId = slots + 2;
        ArrayList<Integer> validIds = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.functionTypes.size(); ++i2) {
            if (!type.equals(this.functionTypes.get(i2)) || startFunc > i2 || i2 >= endFunc) continue;
            validIds.add(i2);
        }
        Label invalid = new Label();
        int[] keys = validIds.stream().mapToInt(x -> x).toArray();
        Label[] labels = (Label[])validIds.stream().map(x -> new Label()).toArray(Label[]::new);
        for (i = 0; i < type.params().size(); ++i) {
            asm.load(i, CompilerUtil.asmType((ValType)type.params().get(i)));
        }
        asm.load(memory, InstructionAdapter.OBJECT_TYPE);
        asm.load(instance, InstructionAdapter.OBJECT_TYPE);
        asm.load(funcId, Type.INT_TYPE);
        asm.lookupswitch(invalid, keys, labels);
        for (i = 0; i < validIds.size(); ++i) {
            asm.mark(labels[i]);
            CompilerUtil.emitInvokeFunction((MethodVisitor)asm, internalClassName + this.classNameForFuncGroup(keys[i]), keys[i], type);
            asm.areturn(Type.getType(CompilerUtil.jvmReturnType(type)));
            asm.areturn(InstructionAdapter.OBJECT_TYPE);
        }
        asm.mark(invalid);
        asm.load(funcId, Type.INT_TYPE);
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.THROW_UNKNOWN_FUNCTION);
        asm.athrow();
    }

    private static void compileHostFunction(int funcId, FunctionType type, InstructionAdapter asm) {
        int slot = type.params().stream().mapToInt(CompilerUtil::slotCount).sum();
        asm.load(slot + 1, InstructionAdapter.OBJECT_TYPE);
        asm.iconst(funcId);
        Compiler.emitBoxArguments(asm, type.params());
        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.CALL_HOST_FUNCTION);
        Compiler.emitUnboxResult(type, asm);
    }

    private static void emitBoxArguments(InstructionAdapter asm, List<ValType> types) {
        int slot = 0;
        asm.iconst(types.size());
        asm.newarray(Type.LONG_TYPE);
        for (int i = 0; i < types.size(); ++i) {
            asm.dup();
            asm.iconst(i);
            ValType valType = types.get(i);
            asm.load(slot, CompilerUtil.asmType(valType));
            CompilerUtil.emitJvmToLong((MethodVisitor)asm, valType);
            asm.astore(Type.LONG_TYPE);
            slot += CompilerUtil.slotCount(valType);
        }
    }

    private static void emitUnboxResult(FunctionType type, InstructionAdapter asm) {
        Class<?> returnType = CompilerUtil.jvmReturnType(type);
        if (returnType == Void.TYPE) {
            asm.areturn(Type.VOID_TYPE);
        } else if (returnType == long[].class) {
            asm.areturn(InstructionAdapter.OBJECT_TYPE);
        } else {
            asm.iconst(0);
            asm.aload(Type.LONG_TYPE);
            CompilerUtil.emitLongToJvm((MethodVisitor)asm, (ValType)type.returns().get(0));
            asm.areturn(Type.getType(returnType));
        }
    }

    private void compileFunction(String internalClassName, int funcId, FunctionType type, FunctionBody body, InstructionAdapter asm) {
        int i;
        if (this.interpretedFunctions.contains(funcId)) {
            int slots = 0;
            if (CompilerUtil.hasTooManyParameters(type)) {
                asm.load(0, LONG_ARRAY_TYPE);
                slots = 1;
            } else {
                Compiler.emitBoxArguments(asm, type.params());
                slots = type.params().stream().mapToInt(CompilerUtil::slotCount).sum();
            }
            int refInstance = slots + 1;
            asm.iconst(funcId);
            asm.load(refInstance, InstructionAdapter.OBJECT_TYPE);
            CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.CALL_INDIRECT_ON_INTERPRETER);
            Compiler.emitUnboxResult(type, asm);
            return;
        }
        Context ctx = new Context(internalClassName, this.maxFunctionsPerClass, this.analyzer.globalTypes(), this.functionTypes, this.module.typeSection().types(), funcId, type, body);
        List<CompilerInstruction> instructions = this.analyzer.analyze(funcId);
        int localsCount = type.params().size();
        if (CompilerUtil.hasTooManyParameters(type)) {
            for (i = 0; i < type.params().size(); ++i) {
                ValType param = (ValType)type.params().get(i);
                asm.load(0, InstructionAdapter.OBJECT_TYPE);
                asm.iconst(i);
                asm.aload(Type.LONG_TYPE);
                CompilerUtil.emitLongToJvm((MethodVisitor)asm, param);
                asm.store(ctx.localSlotIndex(i), CompilerUtil.asmType(param));
            }
            localsCount = 1;
        }
        localsCount += body.localTypes().size();
        for (i = type.params().size(); i < localsCount; ++i) {
            ValType localType = CompilerUtil.localType(type, body, i);
            asm.visitLdcInsn(CompilerUtil.defaultValue(localType));
            asm.store(ctx.localSlotIndex(i), CompilerUtil.asmType(localType));
        }
        HashMap<Long, Label> labels = new HashMap<Long, Label>();
        for (CompilerInstruction ins : instructions) {
            for (long target : ins.labelTargets()) {
                labels.put(target, new Label());
            }
        }
        HashSet<Long> visitedTargets = new HashSet<Long>();
        block11: for (CompilerInstruction ins : instructions) {
            switch (ins.opcode()) {
                case LABEL: {
                    Label label = (Label)labels.get(ins.operand(0));
                    if (label == null) continue block11;
                    asm.mark(label);
                    visitedTargets.add(ins.operand(0));
                    continue block11;
                }
                case GOTO: {
                    if (visitedTargets.contains(ins.operand(0))) {
                        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.CHECK_INTERRUPTION);
                    }
                    asm.goTo((Label)labels.get(ins.operand(0)));
                    continue block11;
                }
                case IFEQ: {
                    if (visitedTargets.contains(ins.operand(0))) {
                        throw new ChicoryException("Unexpected backward jump");
                    }
                    asm.ifeq((Label)labels.get(ins.operand(0)));
                    continue block11;
                }
                case IFNE: {
                    if (visitedTargets.contains(ins.operand(0))) {
                        Label skip = new Label();
                        asm.ifeq(skip);
                        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.CHECK_INTERRUPTION);
                        asm.goTo((Label)labels.get(ins.operand(0)));
                        asm.mark(skip);
                        continue block11;
                    }
                    asm.ifne((Label)labels.get(ins.operand(0)));
                    continue block11;
                }
                case SWITCH: {
                    if (ins.operands().anyMatch(visitedTargets::contains)) {
                        CompilerUtil.emitInvokeStatic((MethodVisitor)asm, ShadedRefs.CHECK_INTERRUPTION);
                    }
                    Label[] table = new Label[ins.operandCount() - 1];
                    for (int i2 = 0; i2 < table.length; ++i2) {
                        table[i2] = (Label)labels.get(ins.operand(i2));
                    }
                    Label defaultLabel = (Label)labels.get(ins.operand(table.length));
                    asm.tableswitch(0, table.length - 1, defaultLabel, table);
                    continue block11;
                }
            }
            Emitters.BytecodeEmitter emitter = EmitterMap.EMITTERS.get((Object)ins.opcode());
            if (emitter == null) {
                throw new ChicoryException("Unhandled opcode: " + String.valueOf((Object)ins.opcode()));
            }
            emitter.emit(ctx, ins, asm);
        }
    }

    public static final class Builder {
        private final WasmModule module;
        private String className;
        private int maxFunctionsPerClass;
        private InterpreterFallback interpreterFallback;
        private Set<Integer> interpretedFunctions;

        private Builder(WasmModule module) {
            this.module = module;
        }

        public Builder withClassName(String className) {
            this.className = className;
            return this;
        }

        public Builder withMaxFunctionsPerClass(int maxFunctionsPerClass) {
            this.maxFunctionsPerClass = maxFunctionsPerClass;
            return this;
        }

        public Builder withInterpreterFallback(InterpreterFallback interpreterFallback) {
            this.interpreterFallback = interpreterFallback;
            return this;
        }

        public Builder withInterpretedFunctions(Set<Integer> interpretedFunctions) {
            this.interpretedFunctions = interpretedFunctions;
            return this;
        }

        public Compiler build() {
            int maxFunctionsPerClass;
            String className = this.className;
            if (className == null) {
                className = Compiler.DEFAULT_CLASS_NAME;
            }
            if ((maxFunctionsPerClass = this.maxFunctionsPerClass) <= 0) {
                maxFunctionsPerClass = 12288;
            }
            return new Compiler(this.module, className, maxFunctionsPerClass, this.interpreterFallback, this.interpretedFunctions);
        }
    }

    static interface ChunkedClassEmitter {
        public byte[] emit(int var1, int var2, int var3);
    }
}

