/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.compiler;

import com.dylibso.chicory.compiler.InterpreterFallback;
import com.dylibso.chicory.compiler.internal.Compiler;
import com.dylibso.chicory.compiler.internal.CompilerResult;
import com.dylibso.chicory.compiler.internal.MachineFactory;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Machine;
import com.dylibso.chicory.wasm.WasmModule;
import java.util.Set;
import java.util.function.Function;

public final class MachineFactoryCompiler {
    private MachineFactoryCompiler() {
    }

    public static Machine compile(Instance instance) {
        return MachineFactoryCompiler.compile(instance.module()).apply(instance);
    }

    public static Function<Instance, Machine> compile(WasmModule module) {
        return new MachineFactory(module);
    }

    public static Builder builder(WasmModule module) {
        return new Builder(module);
    }

    public static final class Builder {
        private final WasmModule module;
        private final Compiler.Builder compilerBuilder;

        private Builder(WasmModule module) {
            this.module = module;
            this.compilerBuilder = Compiler.builder(module);
        }

        public Builder withClassName(String className) {
            this.compilerBuilder.withClassName(className);
            return this;
        }

        public Builder withMaxFunctionsPerClass(int maxFunctionsPerClass) {
            this.compilerBuilder.withMaxFunctionsPerClass(maxFunctionsPerClass);
            return this;
        }

        public Builder withInterpreterFallback(InterpreterFallback interpreterFallback) {
            this.compilerBuilder.withInterpreterFallback(interpreterFallback);
            return this;
        }

        public Builder withInterpretedFunctions(Set<Integer> interpretedFunctions) {
            this.compilerBuilder.withInterpretedFunctions(interpretedFunctions);
            return this;
        }

        public Function<Instance, Machine> compile() {
            CompilerResult result = this.compilerBuilder.build().compile();
            return new MachineFactory(this.module, result.machineFactory());
        }
    }
}

