/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.compiler.internal;

import com.dylibso.chicory.compiler.internal.CompilerUtil;
import com.dylibso.chicory.wasm.WasmModule;
import com.dylibso.chicory.wasm.types.ExternalType;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.TagImport;
import com.dylibso.chicory.wasm.types.TagSection;
import com.dylibso.chicory.wasm.types.ValType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

final class Context {
    private final WasmModule module;
    private final String internalClassName;
    private final int maxFunctionsPerClass;
    private final List<ValType> globalTypes;
    private final List<FunctionType> functionTypes;
    private final int funcId;
    private final FunctionType type;
    private final FunctionBody body;
    private final List<Integer> slots;
    private final int memorySlot;
    private final int instanceSlot;
    private final int tempSlot;
    private final List<TagImport> tagImports;

    public Context(WasmModule module, String internalClassName, int maxFunctionsPerClass, List<ValType> globalTypes, List<FunctionType> functionTypes, int funcId, FunctionType type, FunctionBody body) {
        this.module = module;
        this.internalClassName = internalClassName;
        this.maxFunctionsPerClass = maxFunctionsPerClass;
        this.globalTypes = globalTypes;
        this.functionTypes = functionTypes;
        this.funcId = funcId;
        this.type = type;
        this.body = body;
        ArrayList<Integer> slots = new ArrayList<Integer>(type.params().size() + body.localTypes().size());
        int slot = 0;
        if (CompilerUtil.hasTooManyParameters(type)) {
            ++slot;
        } else {
            for (ValType param : type.params()) {
                slots.add(slot);
                slot += CompilerUtil.slotCount(param);
            }
        }
        this.memorySlot = slot++;
        this.instanceSlot = slot++;
        if (CompilerUtil.hasTooManyParameters(type)) {
            for (ValType param : type.params()) {
                slots.add(slot);
                slot += CompilerUtil.slotCount(param);
            }
        }
        for (ValType local : body.localTypes()) {
            slots.add(slot);
            slot += CompilerUtil.slotCount(local);
        }
        this.slots = List.copyOf(slots);
        this.tempSlot = slot;
        this.tagImports = module.importSection().stream().filter(x -> x.importType() == ExternalType.TAG).map(x -> (TagImport)x).collect(Collectors.toList());
    }

    public String internalClassName() {
        return this.internalClassName;
    }

    public List<ValType> globalTypes() {
        return this.globalTypes;
    }

    public List<FunctionType> functionTypes() {
        return this.functionTypes;
    }

    public FunctionType type(int idx) {
        return this.module.typeSection().getType(idx);
    }

    public FunctionType[] types() {
        return this.module.typeSection().types();
    }

    public int getId() {
        return this.funcId;
    }

    public FunctionType getType() {
        return this.type;
    }

    public FunctionBody getBody() {
        return this.body;
    }

    public int localSlotIndex(int localIndex) {
        return this.slots.get(localIndex);
    }

    public int memorySlot() {
        return this.memorySlot;
    }

    public int instanceSlot() {
        return this.instanceSlot;
    }

    public int tempSlot() {
        return this.tempSlot;
    }

    public String classNameForFuncGroup(int funcId) {
        return "FuncGroup_" + funcId / this.maxFunctionsPerClass;
    }

    public FunctionType tagFunctionType(int tagId) {
        int idx;
        if (tagId < 0) {
            throw new IllegalArgumentException("Tag ID must be non-negative");
        }
        if (tagId < this.tagImports.size()) {
            TagImport tag = this.tagImports.get(tagId);
            idx = tag.tagType().typeIdx();
        } else {
            if (this.module.tagSection().isEmpty()) {
                throw new IllegalStateException("No tag section available");
            }
            idx = ((TagSection)this.module.tagSection().get()).getTag(tagId - this.tagImports.size()).typeIdx();
        }
        return this.type(idx);
    }
}

