/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.compiler.internal;

import com.dylibso.chicory.compiler.internal.CompilerInstruction;
import com.dylibso.chicory.compiler.internal.CompilerOpCode;
import com.dylibso.chicory.compiler.internal.CompilerUtil;
import com.dylibso.chicory.compiler.internal.TypeStack;
import com.dylibso.chicory.wasm.ChicoryException;
import com.dylibso.chicory.wasm.WasmModule;
import com.dylibso.chicory.wasm.types.AnnotatedInstruction;
import com.dylibso.chicory.wasm.types.CatchOpCode;
import com.dylibso.chicory.wasm.types.ExternalType;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionImport;
import com.dylibso.chicory.wasm.types.FunctionSection;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Global;
import com.dylibso.chicory.wasm.types.GlobalImport;
import com.dylibso.chicory.wasm.types.GlobalSection;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.OpCode;
import com.dylibso.chicory.wasm.types.Table;
import com.dylibso.chicory.wasm.types.TableImport;
import com.dylibso.chicory.wasm.types.TableSection;
import com.dylibso.chicory.wasm.types.TypeSection;
import com.dylibso.chicory.wasm.types.ValType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

final class WasmAnalyzer {
    private final WasmModule module;
    private final List<ValType> globalTypes;
    private final List<FunctionType> functionTypes;
    private final List<ValType> tableTypes;
    private final int functionImports;

    public WasmAnalyzer(WasmModule module) {
        this.module = module;
        this.globalTypes = WasmAnalyzer.getGlobalTypes(module);
        this.functionTypes = WasmAnalyzer.getFunctionTypes(module);
        this.tableTypes = WasmAnalyzer.getTableTypes(module);
        this.functionImports = module.importSection().count(ExternalType.FUNCTION);
    }

    public List<ValType> globalTypes() {
        return this.globalTypes;
    }

    public List<FunctionType> functionTypes() {
        return this.functionTypes;
    }

    public List<CompilerInstruction> analyze(int funcId) {
        FunctionType functionType = this.functionTypes.get(funcId);
        FunctionBody body = this.module.codeSection().getFunctionBody(funcId - this.functionImports);
        TypeStack stack = new TypeStack();
        int nextLabel = body.instructions().size();
        ArrayList<CompilerInstruction> result = new ArrayList<CompilerInstruction>();
        HashSet<Integer> labels = new HashSet<Integer>();
        HashMap<Integer, TryCatchBlock> tryCatchBlocks = new HashMap<Integer, TryCatchBlock>();
        for (int idx = body.instructions().size() - 1; idx >= 0; --idx) {
            AnnotatedInstruction ins = (AnnotatedInstruction)body.instructions().get(idx);
            if (ins.labelTrue() != -1) {
                labels.add(ins.labelTrue());
            }
            if (ins.labelFalse() != -1) {
                labels.add(ins.labelFalse());
            }
            labels.addAll(ins.labelTable());
            labels.addAll(Optional.ofNullable(ins.catches()).map(catches -> catches.stream().map(CatchOpCode.Catch::resolvedLabel).collect(Collectors.toList())).orElse(List.of()));
            if (ins.opcode() != OpCode.TRY_TABLE || ((AnnotatedInstruction)body.instructions().get(idx + 1)).opcode() == OpCode.END) continue;
            int start = nextLabel++;
            int end = nextLabel++;
            int handle = nextLabel++;
            int after = nextLabel++;
            Object afterCatchLabels = new long[ins.catches().size()];
            for (int i = 0; i < ins.catches().size(); ++i) {
                afterCatchLabels[i] = (long)nextLabel++;
            }
            TryCatchBlock block = new TryCatchBlock(ins, start, end, handle, after, (long[])afterCatchLabels);
            tryCatchBlocks.put(ins.address(), block);
            result.add(new CompilerInstruction(CompilerOpCode.TRY_CATCH_BLOCK, block.start, block.end, block.handler));
        }
        stack.enterScope(TypeStack.FUNCTION_SCOPE, FunctionType.of(List.of(), (List)functionType.returns()));
        int exitBlockDepth = -1;
        block22: for (int idx = 0; idx < body.instructions().size(); ++idx) {
            AnnotatedInstruction ins = (AnnotatedInstruction)body.instructions().get(idx);
            if (labels.contains(idx)) {
                result.add(new CompilerInstruction(CompilerOpCode.LABEL, idx));
            }
            if (exitBlockDepth >= 0) {
                if (ins.depth() > exitBlockDepth || ins.opcode() != OpCode.ELSE && ins.opcode() != OpCode.END) continue;
                exitBlockDepth = -1;
                if (ins.opcode() == OpCode.END) {
                    stack.scopeRestore();
                }
            }
            switch (ins.opcode()) {
                case NOP: {
                    continue block22;
                }
                case UNREACHABLE: {
                    exitBlockDepth = ins.depth();
                    result.add(new CompilerInstruction(CompilerOpCode.TRAP));
                    continue block22;
                }
                case BLOCK: 
                case LOOP: {
                    stack.enterScope(ins.scope(), this.blockType((Instruction)ins));
                    continue block22;
                }
                case RETURN: {
                    exitBlockDepth = ins.depth();
                    for (ValType type : WasmAnalyzer.reversed(functionType.returns())) {
                        stack.pop(type);
                    }
                    result.add(new CompilerInstruction(CompilerOpCode.RETURN, WasmAnalyzer.ids(functionType.returns())));
                    continue block22;
                }
                case RETURN_CALL: {
                    result.add(new CompilerInstruction(CompilerOpCode.of(OpCode.CALL), ins.operands()));
                    WasmAnalyzer.updateStack(stack, this.functionTypes.get((int)ins.operand(0)));
                    exitBlockDepth = ins.depth();
                    for (ValType type : WasmAnalyzer.reversed(functionType.returns())) {
                        stack.pop(type);
                    }
                    result.add(new CompilerInstruction(CompilerOpCode.RETURN, WasmAnalyzer.ids(functionType.returns())));
                    continue block22;
                }
                case RETURN_CALL_INDIRECT: {
                    stack.pop(ValType.I32);
                    WasmAnalyzer.updateStack(stack, this.module.typeSection().getType((int)ins.operand(0)));
                    result.add(new CompilerInstruction(CompilerOpCode.of(OpCode.CALL_INDIRECT), ins.operands()));
                    exitBlockDepth = ins.depth();
                    for (ValType type : WasmAnalyzer.reversed(functionType.returns())) {
                        stack.pop(type);
                    }
                    result.add(new CompilerInstruction(CompilerOpCode.RETURN, WasmAnalyzer.ids(functionType.returns())));
                    continue block22;
                }
                case IF: {
                    stack.pop(ValType.I32);
                    stack.enterScope(ins.scope(), this.blockType((Instruction)ins));
                    if (((AnnotatedInstruction)body.instructions().get(ins.labelFalse() - 1)).opcode() == OpCode.ELSE) {
                        stack.pushTypes();
                    }
                    result.add(new CompilerInstruction(CompilerOpCode.IFEQ, ins.labelFalse()));
                    continue block22;
                }
                case ELSE: {
                    stack.popTypes();
                    result.add(new CompilerInstruction(CompilerOpCode.GOTO, ins.labelTrue()));
                    continue block22;
                }
                case BR: {
                    exitBlockDepth = ins.depth();
                    this.unwindStack(functionType, body, ins, ins.labelTrue(), stack).ifPresent(result::add);
                    result.add(new CompilerInstruction(CompilerOpCode.GOTO, ins.labelTrue()));
                    continue block22;
                }
                case BR_IF: {
                    stack.pop(ValType.I32);
                    Optional<CompilerInstruction> ifUnwind = this.unwindStack(functionType, body, ins, ins.labelTrue(), stack);
                    if (ifUnwind.isPresent()) {
                        result.add(new CompilerInstruction(CompilerOpCode.IFEQ, ins.labelFalse()));
                        result.add(ifUnwind.get());
                        result.add(new CompilerInstruction(CompilerOpCode.GOTO, ins.labelTrue()));
                        continue block22;
                    }
                    result.add(new CompilerInstruction(CompilerOpCode.IFNE, ins.labelTrue()));
                    continue block22;
                }
                case BR_TABLE: {
                    exitBlockDepth = ins.depth();
                    stack.pop(ValType.I32);
                    if (ins.labelTable().size() == 1) {
                        result.add(new CompilerInstruction(CompilerOpCode.DROP, ValType.I32.id()));
                        this.unwindStack(functionType, body, ins, (Integer)ins.labelTable().get(0), stack).ifPresent(result::add);
                        result.add(new CompilerInstruction(CompilerOpCode.GOTO, ((Integer)ins.labelTable().get(0)).intValue()));
                        continue block22;
                    }
                    ArrayList<CompilerInstruction> unwinds = new ArrayList<CompilerInstruction>();
                    HashMap<Integer, Integer> targets = new HashMap<Integer, Integer>();
                    for (Integer target : ins.labelTable()) {
                        if (targets.containsKey(target)) continue;
                        int label = target;
                        Optional<CompilerInstruction> unwind = this.unwindStack(functionType, body, ins, target, stack);
                        if (unwind.isPresent()) {
                            label = nextLabel++;
                            unwinds.add(new CompilerInstruction(CompilerOpCode.LABEL, label));
                            unwinds.add(unwind.get());
                            unwinds.add(new CompilerInstruction(CompilerOpCode.GOTO, target.intValue()));
                        }
                        targets.put(target, label);
                    }
                    long[] operands = ins.labelTable().stream().mapToLong(targets::get).toArray();
                    result.add(new CompilerInstruction(CompilerOpCode.SWITCH, operands));
                    result.addAll(unwinds);
                    continue block22;
                }
                case TRY_TABLE: {
                    if (((AnnotatedInstruction)body.instructions().get(idx + 1)).opcode() == OpCode.END) {
                        ++idx;
                        continue block22;
                    }
                    stack.enterScope(ins.scope(), this.blockType((Instruction)ins));
                    TryCatchBlock tryCatchBlock = (TryCatchBlock)tryCatchBlocks.get(ins.address());
                    result.add(new CompilerInstruction(CompilerOpCode.LABEL, tryCatchBlock.start));
                    continue block22;
                }
                case END: {
                    TryCatchBlock tryCatchBlock;
                    if (ins.scope().opcode() == OpCode.TRY_TABLE && (tryCatchBlock = (TryCatchBlock)tryCatchBlocks.remove(ins.scope().address())) != null) {
                        WasmAnalyzer.analyzeTryCatchEnd(result, tryCatchBlock);
                    }
                    stack.exitScope(ins.scope());
                    continue block22;
                }
                case THROW: {
                    result.add(new CompilerInstruction(CompilerOpCode.of(OpCode.THROW), ins.operands()));
                    exitBlockDepth = ins.depth();
                    continue block22;
                }
                case THROW_REF: {
                    result.add(new CompilerInstruction(CompilerOpCode.of(OpCode.THROW_REF), ins.operands()));
                    exitBlockDepth = ins.depth();
                    continue block22;
                }
                case SELECT: 
                case SELECT_T: {
                    stack.pop(ValType.I32);
                    ValType selectType = stack.peek();
                    stack.pop(selectType);
                    stack.pop(selectType);
                    stack.push(selectType);
                    result.add(new CompilerInstruction(CompilerOpCode.SELECT, selectType.id()));
                    continue block22;
                }
                case DROP: {
                    ValType dropType = stack.peek();
                    stack.pop(dropType);
                    result.add(new CompilerInstruction(CompilerOpCode.DROP, dropType.id()));
                    continue block22;
                }
                case LOCAL_TEE: {
                    ValType teeType = stack.peek();
                    stack.pop(teeType);
                    stack.push(teeType);
                    long[] teeOperands = new long[]{ins.operand(0), teeType.id()};
                    result.add(new CompilerInstruction(CompilerOpCode.LOCAL_TEE, teeOperands));
                    continue block22;
                }
                default: {
                    this.analyzeSimple(result, stack, (Instruction)ins, functionType, body);
                }
            }
        }
        for (ValType type : WasmAnalyzer.reversed(functionType.returns())) {
            stack.pop(type);
        }
        result.add(new CompilerInstruction(CompilerOpCode.RETURN, WasmAnalyzer.ids(functionType.returns())));
        stack.verifyEmpty();
        return result;
    }

    private static void analyzeTryCatchEnd(List<CompilerInstruction> result, TryCatchBlock tryCatchBlock) {
        result.add(new CompilerInstruction(CompilerOpCode.LABEL, tryCatchBlock.end));
        result.add(new CompilerInstruction(CompilerOpCode.GOTO, tryCatchBlock.after));
        result.add(new CompilerInstruction(CompilerOpCode.LABEL, tryCatchBlock.handler));
        result.add(new CompilerInstruction(CompilerOpCode.CATCH_START));
        for (int i = 0; i < tryCatchBlock.ins.catches().size(); ++i) {
            CatchOpCode.Catch catchCondition = (CatchOpCode.Catch)tryCatchBlock.ins.catches().get(i);
            long afterCatchLabel = tryCatchBlock.afterCatch[i];
            switch (catchCondition.opcode()) {
                case CATCH: {
                    result.add(new CompilerInstruction(CompilerOpCode.CATCH_COMPARE_TAG, catchCondition.tag()));
                    result.add(new CompilerInstruction(CompilerOpCode.IFEQ, afterCatchLabel));
                    result.add(new CompilerInstruction(CompilerOpCode.CATCH_UNBOX_PARAMS, catchCondition.tag()));
                    break;
                }
                case CATCH_REF: {
                    result.add(new CompilerInstruction(CompilerOpCode.CATCH_COMPARE_TAG, catchCondition.tag()));
                    result.add(new CompilerInstruction(CompilerOpCode.IFEQ, afterCatchLabel));
                    result.add(new CompilerInstruction(CompilerOpCode.CATCH_UNBOX_PARAMS, catchCondition.tag()));
                    result.add(new CompilerInstruction(CompilerOpCode.CATCH_REGISTER_EXCEPTION));
                    break;
                }
                case CATCH_ALL: {
                    break;
                }
                case CATCH_ALL_REF: {
                    result.add(new CompilerInstruction(CompilerOpCode.CATCH_REGISTER_EXCEPTION));
                }
            }
            result.add(new CompilerInstruction(CompilerOpCode.GOTO, catchCondition.resolvedLabel()));
            result.add(new CompilerInstruction(CompilerOpCode.LABEL, afterCatchLabel));
        }
        result.add(new CompilerInstruction(CompilerOpCode.CATCH_END));
        result.add(new CompilerInstruction(CompilerOpCode.LABEL, tryCatchBlock.after));
    }

    private void analyzeSimple(List<CompilerInstruction> out, TypeStack stack, Instruction ins, FunctionType functionType, FunctionBody body) {
        switch (ins.opcode()) {
            case I32_CLZ: 
            case I32_CTZ: 
            case I32_EQZ: 
            case I32_EXTEND_16_S: 
            case I32_EXTEND_8_S: 
            case I32_LOAD16_S: 
            case I32_LOAD16_U: 
            case I32_LOAD8_S: 
            case I32_LOAD8_U: 
            case I32_LOAD: 
            case I32_POPCNT: 
            case MEMORY_GROW: 
            case I32_ATOMIC_LOAD: 
            case I32_ATOMIC_LOAD8_U: 
            case I32_ATOMIC_LOAD16_U: {
                stack.pop(ValType.I32);
                stack.push(ValType.I32);
                break;
            }
            case F32_CONVERT_I32_S: 
            case F32_CONVERT_I32_U: 
            case F32_LOAD: 
            case F32_REINTERPRET_I32: {
                stack.pop(ValType.I32);
                stack.push(ValType.F32);
                break;
            }
            case F32_ABS: 
            case F32_CEIL: 
            case F32_FLOOR: 
            case F32_NEAREST: 
            case F32_NEG: 
            case F32_SQRT: 
            case F32_TRUNC: {
                stack.pop(ValType.F32);
                stack.push(ValType.F32);
                break;
            }
            case I32_REINTERPRET_F32: 
            case I32_TRUNC_F32_S: 
            case I32_TRUNC_F32_U: 
            case I32_TRUNC_SAT_F32_S: 
            case I32_TRUNC_SAT_F32_U: {
                stack.pop(ValType.F32);
                stack.push(ValType.I32);
                break;
            }
            case I32_WRAP_I64: 
            case I64_EQZ: {
                stack.pop(ValType.I64);
                stack.push(ValType.I32);
                break;
            }
            case F32_CONVERT_I64_S: 
            case F32_CONVERT_I64_U: {
                stack.pop(ValType.I64);
                stack.push(ValType.F32);
                break;
            }
            case F32_DEMOTE_F64: {
                stack.pop(ValType.F64);
                stack.push(ValType.F32);
                break;
            }
            case I32_TRUNC_F64_S: 
            case I32_TRUNC_F64_U: 
            case I32_TRUNC_SAT_F64_S: 
            case I32_TRUNC_SAT_F64_U: {
                stack.pop(ValType.F64);
                stack.push(ValType.I32);
                break;
            }
            case I32_ADD: 
            case I32_AND: 
            case I32_DIV_S: 
            case I32_DIV_U: 
            case I32_EQ: 
            case I32_GE_S: 
            case I32_GE_U: 
            case I32_GT_S: 
            case I32_GT_U: 
            case I32_LE_S: 
            case I32_LE_U: 
            case I32_LT_S: 
            case I32_LT_U: 
            case I32_MUL: 
            case I32_NE: 
            case I32_OR: 
            case I32_REM_S: 
            case I32_REM_U: 
            case I32_ROTL: 
            case I32_ROTR: 
            case I32_SHL: 
            case I32_SHR_S: 
            case I32_SHR_U: 
            case I32_SUB: 
            case I32_XOR: 
            case I32_ATOMIC_RMW_ADD: 
            case I32_ATOMIC_RMW_SUB: 
            case I32_ATOMIC_RMW_AND: 
            case I32_ATOMIC_RMW_OR: 
            case I32_ATOMIC_RMW_XOR: 
            case I32_ATOMIC_RMW_XCHG: 
            case MEM_ATOMIC_NOTIFY: 
            case I32_ATOMIC_RMW8_ADD_U: 
            case I32_ATOMIC_RMW8_SUB_U: 
            case I32_ATOMIC_RMW8_AND_U: 
            case I32_ATOMIC_RMW8_OR_U: 
            case I32_ATOMIC_RMW8_XOR_U: 
            case I32_ATOMIC_RMW8_XCHG_U: 
            case I32_ATOMIC_RMW16_ADD_U: 
            case I32_ATOMIC_RMW16_SUB_U: 
            case I32_ATOMIC_RMW16_AND_U: 
            case I32_ATOMIC_RMW16_OR_U: 
            case I32_ATOMIC_RMW16_XOR_U: 
            case I32_ATOMIC_RMW16_XCHG_U: {
                stack.pop(ValType.I32);
                stack.pop(ValType.I32);
                stack.push(ValType.I32);
                break;
            }
            case I64_EQ: 
            case I64_GE_S: 
            case I64_GE_U: 
            case I64_GT_S: 
            case I64_GT_U: 
            case I64_LE_S: 
            case I64_LE_U: 
            case I64_LT_S: 
            case I64_LT_U: 
            case I64_NE: {
                stack.pop(ValType.I64);
                stack.pop(ValType.I64);
                stack.push(ValType.I32);
                break;
            }
            case F32_ADD: 
            case F32_COPYSIGN: 
            case F32_DIV: 
            case F32_MAX: 
            case F32_MIN: 
            case F32_MUL: 
            case F32_SUB: {
                stack.pop(ValType.F32);
                stack.pop(ValType.F32);
                stack.push(ValType.F32);
                break;
            }
            case F32_EQ: 
            case F32_GE: 
            case F32_GT: 
            case F32_LE: 
            case F32_LT: 
            case F32_NE: {
                stack.pop(ValType.F32);
                stack.pop(ValType.F32);
                stack.push(ValType.I32);
                break;
            }
            case F64_EQ: 
            case F64_GE: 
            case F64_GT: 
            case F64_LE: 
            case F64_LT: 
            case F64_NE: {
                stack.pop(ValType.F64);
                stack.pop(ValType.F64);
                stack.push(ValType.I32);
                break;
            }
            case I64_CLZ: 
            case I64_CTZ: 
            case I64_EXTEND_16_S: 
            case I64_EXTEND_32_S: 
            case I64_EXTEND_8_S: 
            case I64_POPCNT: {
                stack.pop(ValType.I64);
                stack.push(ValType.I64);
                break;
            }
            case I64_REINTERPRET_F64: 
            case I64_TRUNC_F64_S: 
            case I64_TRUNC_F64_U: 
            case I64_TRUNC_SAT_F64_S: 
            case I64_TRUNC_SAT_F64_U: {
                stack.pop(ValType.F64);
                stack.push(ValType.I64);
                break;
            }
            case F64_TRUNC: 
            case F64_SQRT: 
            case F64_NEAREST: 
            case F64_ABS: 
            case F64_CEIL: 
            case F64_FLOOR: 
            case F64_NEG: {
                stack.pop(ValType.F64);
                stack.push(ValType.F64);
                break;
            }
            case F64_CONVERT_I64_S: 
            case F64_CONVERT_I64_U: 
            case F64_REINTERPRET_I64: {
                stack.pop(ValType.I64);
                stack.push(ValType.F64);
                break;
            }
            case I64_EXTEND_I32_S: 
            case I64_EXTEND_I32_U: 
            case I64_LOAD16_S: 
            case I64_LOAD16_U: 
            case I64_LOAD32_S: 
            case I64_LOAD32_U: 
            case I64_LOAD8_S: 
            case I64_LOAD8_U: 
            case I64_LOAD: 
            case I64_ATOMIC_LOAD: 
            case I64_ATOMIC_LOAD8_U: 
            case I64_ATOMIC_LOAD16_U: 
            case I64_ATOMIC_LOAD32_U: {
                stack.pop(ValType.I32);
                stack.push(ValType.I64);
                break;
            }
            case I64_TRUNC_F32_S: 
            case I64_TRUNC_F32_U: 
            case I64_TRUNC_SAT_F32_S: 
            case I64_TRUNC_SAT_F32_U: {
                stack.pop(ValType.F32);
                stack.push(ValType.I64);
                break;
            }
            case F64_CONVERT_I32_S: 
            case F64_CONVERT_I32_U: 
            case F64_LOAD: {
                stack.pop(ValType.I32);
                stack.push(ValType.F64);
                break;
            }
            case F64_PROMOTE_F32: {
                stack.pop(ValType.F32);
                stack.push(ValType.F64);
                break;
            }
            case I64_ADD: 
            case I64_AND: 
            case I64_DIV_S: 
            case I64_DIV_U: 
            case I64_MUL: 
            case I64_OR: 
            case I64_REM_S: 
            case I64_REM_U: 
            case I64_ROTL: 
            case I64_ROTR: 
            case I64_SHL: 
            case I64_SHR_S: 
            case I64_SHR_U: 
            case I64_SUB: 
            case I64_XOR: {
                stack.pop(ValType.I64);
                stack.pop(ValType.I64);
                stack.push(ValType.I64);
                break;
            }
            case F64_ADD: 
            case F64_COPYSIGN: 
            case F64_DIV: 
            case F64_MAX: 
            case F64_MIN: 
            case F64_MUL: 
            case F64_SUB: {
                stack.pop(ValType.F64);
                stack.pop(ValType.F64);
                stack.push(ValType.F64);
                break;
            }
            case I32_STORE: 
            case I32_STORE8: 
            case I32_STORE16: 
            case I32_ATOMIC_STORE: 
            case I32_ATOMIC_STORE8: 
            case I32_ATOMIC_STORE16: {
                stack.pop(ValType.I32);
                stack.pop(ValType.I32);
                break;
            }
            case F32_STORE: {
                stack.pop(ValType.F32);
                stack.pop(ValType.I32);
                break;
            }
            case I64_STORE: 
            case I64_STORE8: 
            case I64_STORE16: 
            case I64_STORE32: 
            case I64_ATOMIC_STORE: 
            case I64_ATOMIC_STORE8: 
            case I64_ATOMIC_STORE16: 
            case I64_ATOMIC_STORE32: {
                stack.pop(ValType.I64);
                stack.pop(ValType.I32);
                break;
            }
            case F64_STORE: {
                stack.pop(ValType.F64);
                stack.pop(ValType.I32);
                break;
            }
            case I32_CONST: 
            case MEMORY_SIZE: 
            case TABLE_SIZE: {
                stack.push(ValType.I32);
                break;
            }
            case F32_CONST: {
                stack.push(ValType.F32);
                break;
            }
            case I64_CONST: {
                stack.push(ValType.I64);
                break;
            }
            case F64_CONST: {
                stack.push(ValType.F64);
                break;
            }
            case REF_FUNC: {
                stack.push(ValType.FuncRef);
                break;
            }
            case REF_NULL: {
                stack.push(ValType.builder().withOpcode(99).withTypeIdx((int)ins.operand(0)).build(arg_0 -> ((TypeSection)this.module.typeSection()).getType(arg_0)));
                break;
            }
            case REF_IS_NULL: {
                stack.popRef();
                stack.push(ValType.I32);
                break;
            }
            case MEMORY_COPY: 
            case MEMORY_FILL: 
            case MEMORY_INIT: 
            case TABLE_COPY: 
            case TABLE_INIT: {
                stack.pop(ValType.I32);
                stack.pop(ValType.I32);
                stack.pop(ValType.I32);
                break;
            }
            case TABLE_FILL: {
                stack.pop(ValType.I32);
                stack.pop(stack.peek());
                stack.pop(ValType.I32);
                break;
            }
            case TABLE_GET: {
                stack.pop(ValType.I32);
                stack.push(this.tableTypes.get((int)ins.operand(0)));
                break;
            }
            case TABLE_GROW: {
                stack.pop(ValType.I32);
                stack.pop(this.tableTypes.get((int)ins.operand(0)));
                stack.push(ValType.I32);
                break;
            }
            case TABLE_SET: {
                stack.pop(this.tableTypes.get((int)ins.operand(0)));
                stack.pop(ValType.I32);
                break;
            }
            case CALL: {
                WasmAnalyzer.updateStack(stack, this.functionTypes.get((int)ins.operand(0)));
                break;
            }
            case CALL_INDIRECT: {
                stack.pop(ValType.I32);
                WasmAnalyzer.updateStack(stack, this.module.typeSection().getType((int)ins.operand(0)));
                break;
            }
            case GLOBAL_SET: 
            case LOCAL_SET: {
                stack.pop(stack.peek());
                break;
            }
            case LOCAL_GET: {
                stack.push(CompilerUtil.localType(functionType, body, (int)ins.operand(0)));
                break;
            }
            case GLOBAL_GET: {
                stack.push(this.globalTypes.get((int)ins.operand(0)));
                break;
            }
            case DATA_DROP: 
            case ELEM_DROP: {
                break;
            }
            case I32_ATOMIC_RMW_CMPXCHG: 
            case I32_ATOMIC_RMW8_CMPXCHG_U: 
            case I32_ATOMIC_RMW16_CMPXCHG_U: {
                stack.pop(ValType.I32);
                stack.pop(ValType.I32);
                stack.pop(ValType.I32);
                stack.push(ValType.I32);
                break;
            }
            case I64_ATOMIC_RMW_ADD: 
            case I64_ATOMIC_RMW_SUB: 
            case I64_ATOMIC_RMW_AND: 
            case I64_ATOMIC_RMW_OR: 
            case I64_ATOMIC_RMW_XOR: 
            case I64_ATOMIC_RMW_XCHG: 
            case I64_ATOMIC_RMW8_ADD_U: 
            case I64_ATOMIC_RMW8_SUB_U: 
            case I64_ATOMIC_RMW8_AND_U: 
            case I64_ATOMIC_RMW8_OR_U: 
            case I64_ATOMIC_RMW8_XOR_U: 
            case I64_ATOMIC_RMW8_XCHG_U: 
            case I64_ATOMIC_RMW16_ADD_U: 
            case I64_ATOMIC_RMW16_SUB_U: 
            case I64_ATOMIC_RMW16_AND_U: 
            case I64_ATOMIC_RMW16_OR_U: 
            case I64_ATOMIC_RMW16_XOR_U: 
            case I64_ATOMIC_RMW16_XCHG_U: 
            case I64_ATOMIC_RMW32_ADD_U: 
            case I64_ATOMIC_RMW32_SUB_U: 
            case I64_ATOMIC_RMW32_AND_U: 
            case I64_ATOMIC_RMW32_OR_U: 
            case I64_ATOMIC_RMW32_XOR_U: 
            case I64_ATOMIC_RMW32_XCHG_U: {
                stack.pop(ValType.I64);
                stack.pop(ValType.I32);
                stack.push(ValType.I64);
                break;
            }
            case I64_ATOMIC_RMW_CMPXCHG: 
            case I64_ATOMIC_RMW8_CMPXCHG_U: 
            case I64_ATOMIC_RMW16_CMPXCHG_U: 
            case I64_ATOMIC_RMW32_CMPXCHG_U: {
                stack.pop(ValType.I64);
                stack.pop(ValType.I64);
                stack.pop(ValType.I32);
                stack.push(ValType.I64);
                break;
            }
            case MEM_ATOMIC_WAIT32: {
                stack.pop(ValType.I64);
                stack.pop(ValType.I32);
                stack.pop(ValType.I32);
                stack.push(ValType.I32);
                break;
            }
            case MEM_ATOMIC_WAIT64: {
                stack.pop(ValType.I64);
                stack.pop(ValType.I64);
                stack.pop(ValType.I32);
                stack.push(ValType.I32);
                break;
            }
            default: {
                throw new ChicoryException("Unhandled opcode: " + String.valueOf(ins.opcode()));
            }
        }
        out.add(new CompilerInstruction(CompilerOpCode.of(ins.opcode()), ins.operands()));
    }

    private static void updateStack(TypeStack stack, FunctionType functionType) {
        for (ValType type : WasmAnalyzer.reversed(functionType.params())) {
            stack.pop(type);
        }
        for (ValType type : functionType.returns()) {
            stack.push(type);
        }
    }

    private Optional<CompilerInstruction> unwindStack(FunctionType functionType, FunctionBody body, AnnotatedInstruction ins, int label, TypeStack stack) {
        FunctionType blockType;
        Instruction scope;
        boolean forward = true;
        AnnotatedInstruction target = (AnnotatedInstruction)body.instructions().get(label);
        if (target.address() <= ins.address()) {
            target = (AnnotatedInstruction)body.instructions().get(label - 1);
            forward = false;
        }
        if ((scope = target.scope()).opcode() == OpCode.END) {
            scope = TypeStack.FUNCTION_SCOPE;
            blockType = functionType;
        } else {
            blockType = this.blockType(scope);
        }
        List types = forward ? blockType.returns() : blockType.params();
        int keep = types.size();
        int drop = stack.types().size() - stack.scopeStackSize(scope);
        if (forward) {
            drop -= types.size();
        }
        if (drop <= 0) {
            return Optional.empty();
        }
        LongStream.Builder operands = LongStream.builder();
        operands.add(drop);
        List dropKeepTypes = stack.types().stream().limit(drop + keep).collect(Collectors.toCollection(ArrayList::new));
        Collections.reverse(dropKeepTypes);
        dropKeepTypes.stream().mapToLong(ValType::id).forEach(operands::add);
        return Optional.of(new CompilerInstruction(CompilerOpCode.DROP_KEEP, operands.build().toArray()));
    }

    private FunctionType blockType(Instruction ins) {
        long typeId = ins.operand(0);
        if (typeId == 64L) {
            return FunctionType.empty();
        }
        if (ValType.isValid((long)typeId)) {
            return FunctionType.returning((ValType)ValType.builder().fromId(typeId).build(arg_0 -> ((TypeSection)this.module.typeSection()).getType(arg_0)));
        }
        return this.module.typeSection().getType((int)typeId);
    }

    private static List<ValType> getGlobalTypes(WasmModule module) {
        Stream<ValType> importedGlobals = module.importSection().stream().filter(GlobalImport.class::isInstance).map(GlobalImport.class::cast).map(GlobalImport::type);
        GlobalSection globals = module.globalSection();
        Stream<ValType> moduleGlobals = IntStream.range(0, globals.globalCount()).mapToObj(arg_0 -> ((GlobalSection)globals).getGlobal(arg_0)).map(Global::valueType);
        return Stream.concat(importedGlobals, moduleGlobals).collect(Collectors.toUnmodifiableList());
    }

    private static List<FunctionType> getFunctionTypes(WasmModule module) {
        Stream<FunctionType> importedFunctions = module.importSection().stream().filter(FunctionImport.class::isInstance).map(FunctionImport.class::cast).map(function -> module.typeSection().getType(function.typeIndex()));
        FunctionSection functions = module.functionSection();
        Stream<FunctionType> moduleFunctions = IntStream.range(0, functions.functionCount()).mapToObj(i -> functions.getFunctionType(i, module.typeSection()));
        return Stream.concat(importedFunctions, moduleFunctions).collect(Collectors.toUnmodifiableList());
    }

    private static List<ValType> getTableTypes(WasmModule module) {
        Stream<ValType> importedTables = module.importSection().stream().filter(TableImport.class::isInstance).map(TableImport.class::cast).map(TableImport::entryType);
        TableSection tables = module.tableSection();
        Stream<ValType> moduleTables = IntStream.range(0, tables.tableCount()).mapToObj(arg_0 -> ((TableSection)tables).getTable(arg_0)).map(Table::elementType);
        return Stream.concat(importedTables, moduleTables).collect(Collectors.toUnmodifiableList());
    }

    private static <T> List<T> reversed(List<T> list) {
        if (list.size() <= 1) {
            return list;
        }
        ArrayList<T> reversed = new ArrayList<T>(list);
        Collections.reverse(reversed);
        return reversed;
    }

    private static long[] ids(List<ValType> types) {
        return types.stream().mapToLong(ValType::id).toArray();
    }

    public static class TryCatchBlock {
        final AnnotatedInstruction ins;
        final long start;
        final long end;
        final long handler;
        final long after;
        final long[] afterCatch;

        public TryCatchBlock(AnnotatedInstruction ins, long start, long end, long handler, long after, long[] afterCatch) {
            this.ins = ins;
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.after = after;
            this.afterCatch = afterCatch;
        }
    }
}

