/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.TableInstance;
import com.dylibso.chicory.wasm.exceptions.InvalidException;
import com.dylibso.chicory.wasm.exceptions.MalformedException;
import com.dylibso.chicory.wasm.types.DataSegment;
import com.dylibso.chicory.wasm.types.Element;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.MutabilityType;
import com.dylibso.chicory.wasm.types.OpCode;
import com.dylibso.chicory.wasm.types.PassiveDataSegment;
import com.dylibso.chicory.wasm.types.ValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TypeValidator {
    private List<ValueType> valueTypeStack = new ArrayList<ValueType>();
    private List<CtrlFrame> ctrlFrameStack = new ArrayList<CtrlFrame>();

    private boolean isNum(ValueType t) {
        return t.isNumeric() || t == ValueType.UNKNOWN;
    }

    private boolean isRef(ValueType t) {
        return t.isReference() || t == ValueType.UNKNOWN;
    }

    private void pushVal(ValueType valType) {
        this.valueTypeStack.add(valType);
    }

    private ValueType popVal() {
        CtrlFrame frame = this.peekCtrl();
        if (this.valueTypeStack.size() == frame.height && frame.unreachable) {
            return ValueType.UNKNOWN;
        }
        if (this.valueTypeStack.size() == frame.height) {
            throw new InvalidException("type mismatch, popVal(), stack reached limit at " + frame.height);
        }
        return this.valueTypeStack.remove(this.valueTypeStack.size() - 1);
    }

    private ValueType popVal(ValueType expected) {
        ValueType actual = this.popVal();
        if (actual != expected && actual != ValueType.UNKNOWN && expected != ValueType.UNKNOWN) {
            throw new InvalidException("type mismatch, popVal(expected), expected: " + expected + " but got: " + actual);
        }
        return actual;
    }

    private void pushVals(List<ValueType> valTypes) {
        for (ValueType t : valTypes) {
            this.pushVal(t);
        }
    }

    private List<ValueType> popVals(List<ValueType> valTypes) {
        ValueType[] popped = new ValueType[valTypes.size()];
        for (int i = 0; i < valTypes.size(); ++i) {
            popped[i] = this.popVal(valTypes.get(valTypes.size() - 1 - i));
        }
        return Arrays.asList(popped);
    }

    private void pushCtrl(OpCode opCode, List<ValueType> in, List<ValueType> out) {
        CtrlFrame frame = new CtrlFrame(opCode, in, out, this.valueTypeStack.size(), false, false);
        this.pushCtrl(frame);
        this.pushVals(in);
    }

    private CtrlFrame popCtrl() {
        if (this.ctrlFrameStack.isEmpty()) {
            throw new InvalidException("type mismatch, control frame stack empty");
        }
        CtrlFrame frame = this.peekCtrl();
        this.popVals(frame.endTypes);
        if (this.valueTypeStack.size() != frame.height) {
            throw new InvalidException("type mismatch, mismatching stack height");
        }
        this.ctrlFrameStack.remove(this.ctrlFrameStack.size() - 1);
        return frame;
    }

    private void pushCtrl(CtrlFrame frame) {
        this.ctrlFrameStack.add(frame);
    }

    private CtrlFrame peekCtrl() {
        return this.ctrlFrameStack.get(this.ctrlFrameStack.size() - 1);
    }

    private CtrlFrame getCtrl(int n) {
        return this.ctrlFrameStack.get(this.ctrlFrameStack.size() - 1 - n);
    }

    private List<ValueType> labelTypes(CtrlFrame frame) {
        if (frame.opCode == OpCode.LOOP) {
            return frame.startTypes;
        }
        return frame.endTypes;
    }

    private void resetAtStackLimit() {
        CtrlFrame frame = this.peekCtrl();
        while (this.valueTypeStack.size() > frame.height) {
            this.valueTypeStack.remove(this.valueTypeStack.size() - 1);
        }
    }

    private void unreachable() {
        CtrlFrame frame = this.peekCtrl();
        this.resetAtStackLimit();
        frame.unreachable = true;
    }

    private static void validateMemory(Instance instance, int memIds) {
        TypeValidator.validateMemory(instance, memIds, -1);
    }

    private static void validateMemory(Instance instance, int memIds, int dataSegmentIdx) {
        if (instance.memory() == null || memIds > 0) {
            throw new InvalidException("unknown memory " + memIds);
        }
        if (instance.memory().dataSegments() == null || dataSegmentIdx >= instance.memory().dataSegments().length) {
            throw new InvalidException("unknown data segment " + dataSegmentIdx);
        }
    }

    private List<ValueType> getReturns(Instruction op, Instance instance) {
        int typeId = (int)op.operands()[0];
        if (typeId == 64) {
            return List.of();
        }
        if (ValueType.isValid((int)typeId)) {
            return List.of(ValueType.forId((int)typeId));
        }
        return instance.type(typeId).returns();
    }

    private List<ValueType> getParams(Instruction op, Instance instance) {
        int typeId = (int)op.operands()[0];
        if (typeId == 64) {
            return List.of();
        }
        if (ValueType.isValid((int)typeId)) {
            return List.of();
        }
        if (typeId >= instance.typeCount()) {
            throw new MalformedException("unexpected end");
        }
        return instance.type(typeId).params();
    }

    private static ValueType getLocalType(List<ValueType> localTypes, int idx) {
        if (idx >= localTypes.size()) {
            throw new InvalidException("unknown local " + idx);
        }
        return localTypes.get(idx);
    }

    public void validate(int funcIdx, FunctionBody body, FunctionType functionType, Instance instance) {
        List localTypes = body.localTypes();
        int inputLen = functionType.params().size();
        this.pushCtrl(null, new ArrayList<ValueType>(), functionType.returns());
        block75: for (int i = 0; i < body.instructions().size(); ++i) {
            ValueType t2;
            Instruction op = (Instruction)body.instructions().get(i);
            switch (op.opcode()) {
                case UNREACHABLE: {
                    this.unreachable();
                    break;
                }
                case IF: {
                    this.popVal(ValueType.I32);
                }
                case LOOP: 
                case BLOCK: {
                    List<ValueType> t1 = this.getParams(op, instance);
                    t2 = this.getReturns(op, instance);
                    this.popVals(t1);
                    this.pushCtrl(op.opcode(), t1, (List<ValueType>)t2);
                    break;
                }
                case END: {
                    CtrlFrame frame = this.popCtrl();
                    if (frame.opCode == OpCode.IF && !frame.hasElse && frame.startTypes.size() != frame.endTypes.size()) {
                        throw new InvalidException("type mismatch, unbalanced if branches");
                    }
                    this.pushVals(frame.endTypes);
                    break;
                }
                case ELSE: {
                    CtrlFrame frame = this.popCtrl();
                    if (frame.opCode != OpCode.IF) {
                        throw new InvalidException("else doesn't belong to if");
                    }
                    this.pushCtrl(op.opcode(), frame.startTypes, frame.endTypes);
                    this.peekCtrl().hasElse = true;
                    break;
                }
                case BR: {
                    int n = (int)op.operands()[0];
                    if (op.labelTrue() == null) {
                        throw new InvalidException("unknown label " + n);
                    }
                    this.popVals(this.labelTypes(this.getCtrl(n)));
                    this.unreachable();
                    break;
                }
                case BR_IF: {
                    this.popVal(ValueType.I32);
                    int n = (int)op.operands()[0];
                    if (op.labelTrue() == null) {
                        throw new InvalidException("unknown label " + n);
                    }
                    List<ValueType> labelTypes = this.labelTypes(this.getCtrl(n));
                    this.popVals(labelTypes);
                    this.pushVals(labelTypes);
                    break;
                }
                case BR_TABLE: {
                    this.popVal(ValueType.I32);
                    int m = (int)op.operands()[op.operands().length - 1];
                    if (this.ctrlFrameStack.size() - 1 - m < 0) {
                        throw new InvalidException("unknown label " + m);
                    }
                    List<ValueType> defaultBranchLabelTypes = this.labelTypes(this.getCtrl(m));
                    int arity = defaultBranchLabelTypes.size();
                    for (int idx = 0; idx < op.operands().length - 1; ++idx) {
                        int n = (int)op.operands()[idx];
                        CtrlFrame ctrlFrame = null;
                        try {
                            ctrlFrame = this.getCtrl(n);
                        }
                        catch (IndexOutOfBoundsException e) {
                            throw new InvalidException("unknown label", (Throwable)e);
                        }
                        List<ValueType> labelTypes = this.labelTypes(ctrlFrame);
                        if (!ctrlFrame.unreachable) {
                            if (labelTypes.size() != arity) {
                                throw new InvalidException("type mismatch, mismatched arity in BR_TABLE for label " + n);
                            }
                            for (int t = 0; t < arity; ++t) {
                                if (labelTypes.get(t) == defaultBranchLabelTypes.get(t)) continue;
                                throw new InvalidException("type mismatch, br_table labels have inconsistent types: expected: " + defaultBranchLabelTypes.get(t) + ", got: " + labelTypes.get(t));
                            }
                        }
                        this.pushVals(this.popVals(labelTypes));
                    }
                    ArrayList<ValueType> reversed = new ArrayList<ValueType>(defaultBranchLabelTypes);
                    Collections.reverse(reversed);
                    this.popVals(reversed);
                    this.unreachable();
                    break;
                }
                case RETURN: {
                    this.popVals(this.labelTypes(this.ctrlFrameStack.get(0)));
                    this.unreachable();
                    break;
                }
            }
            switch (op.opcode()) {
                case MEMORY_COPY: {
                    TypeValidator.validateMemory(instance, (int)op.operands()[0]);
                    TypeValidator.validateMemory(instance, (int)op.operands()[1]);
                    break;
                }
                case MEMORY_FILL: {
                    TypeValidator.validateMemory(instance, (int)op.operands()[0]);
                    break;
                }
                case MEMORY_INIT: {
                    TypeValidator.validateMemory(instance, (int)op.operands()[1], (int)op.operands()[0]);
                    break;
                }
                case MEMORY_SIZE: 
                case MEMORY_GROW: 
                case I32_LOAD: 
                case I32_LOAD8_U: 
                case I32_LOAD8_S: 
                case I32_LOAD16_U: 
                case I32_LOAD16_S: 
                case I64_LOAD: 
                case I64_LOAD8_S: 
                case I64_LOAD8_U: 
                case I64_LOAD16_S: 
                case I64_LOAD16_U: 
                case I64_LOAD32_S: 
                case I64_LOAD32_U: 
                case F32_LOAD: 
                case F64_LOAD: 
                case I32_STORE: 
                case I32_STORE8: 
                case I32_STORE16: 
                case I64_STORE: 
                case I64_STORE8: 
                case I64_STORE16: 
                case I64_STORE32: 
                case F32_STORE: 
                case F64_STORE: {
                    TypeValidator.validateMemory(instance, 0);
                    break;
                }
            }
            switch (op.opcode()) {
                case UNREACHABLE: 
                case IF: 
                case LOOP: 
                case BLOCK: 
                case END: 
                case ELSE: 
                case BR: 
                case BR_IF: 
                case BR_TABLE: 
                case RETURN: 
                case NOP: {
                    continue block75;
                }
                case DATA_DROP: {
                    int index = (int)op.operands()[0];
                    DataSegment[] dataSegments = instance.dataSegments();
                    if (dataSegments != null && dataSegments.length > index && instance.dataSegments()[index] instanceof PassiveDataSegment || instance.memory() != null && instance.memory().dataSegments() != null && index < instance.memory().dataSegments().length) continue block75;
                    throw new InvalidException("unknown data segment " + index);
                }
                case DROP: {
                    this.popVal();
                    continue block75;
                }
                case I32_STORE: 
                case I32_STORE8: 
                case I32_STORE16: {
                    this.popVal(ValueType.I32);
                    this.popVal(ValueType.I32);
                    continue block75;
                }
                case MEMORY_GROW: 
                case I32_LOAD: 
                case I32_LOAD8_U: 
                case I32_LOAD8_S: 
                case I32_LOAD16_U: 
                case I32_LOAD16_S: 
                case I32_CLZ: 
                case I32_CTZ: 
                case I32_POPCNT: 
                case I32_EXTEND_8_S: 
                case I32_EXTEND_16_S: 
                case I32_EQZ: {
                    this.popVal(ValueType.I32);
                    this.pushVal(ValueType.I32);
                    continue block75;
                }
                case MEMORY_SIZE: 
                case TABLE_SIZE: 
                case I32_CONST: {
                    this.pushVal(ValueType.I32);
                    continue block75;
                }
                case I32_ADD: 
                case I32_SUB: 
                case I32_MUL: 
                case I32_DIV_S: 
                case I32_DIV_U: 
                case I32_REM_S: 
                case I32_REM_U: 
                case I32_AND: 
                case I32_OR: 
                case I32_XOR: 
                case I32_EQ: 
                case I32_NE: 
                case I32_LT_S: 
                case I32_LT_U: 
                case I32_LE_S: 
                case I32_LE_U: 
                case I32_GT_S: 
                case I32_GT_U: 
                case I32_GE_S: 
                case I32_GE_U: 
                case I32_SHL: 
                case I32_SHR_U: 
                case I32_SHR_S: 
                case I32_ROTL: 
                case I32_ROTR: {
                    this.popVal(ValueType.I32);
                    this.popVal(ValueType.I32);
                    this.pushVal(ValueType.I32);
                    continue block75;
                }
                case I32_WRAP_I64: 
                case I64_EQZ: {
                    this.popVal(ValueType.I64);
                    this.pushVal(ValueType.I32);
                    continue block75;
                }
                case I32_TRUNC_F32_S: 
                case I32_TRUNC_F32_U: 
                case I32_TRUNC_SAT_F32_S: 
                case I32_TRUNC_SAT_F32_U: 
                case I32_REINTERPRET_F32: {
                    this.popVal(ValueType.F32);
                    this.pushVal(ValueType.I32);
                    continue block75;
                }
                case I32_TRUNC_F64_S: 
                case I32_TRUNC_F64_U: 
                case I32_TRUNC_SAT_F64_S: 
                case I32_TRUNC_SAT_F64_U: {
                    this.popVal(ValueType.F64);
                    this.pushVal(ValueType.I32);
                    continue block75;
                }
                case I64_LOAD: 
                case I64_LOAD8_S: 
                case I64_LOAD8_U: 
                case I64_LOAD16_S: 
                case I64_LOAD16_U: 
                case I64_LOAD32_S: 
                case I64_LOAD32_U: 
                case I64_EXTEND_I32_U: 
                case I64_EXTEND_I32_S: {
                    this.popVal(ValueType.I32);
                    this.pushVal(ValueType.I64);
                    continue block75;
                }
                case I64_CONST: {
                    this.pushVal(ValueType.I64);
                    continue block75;
                }
                case I64_STORE: 
                case I64_STORE8: 
                case I64_STORE16: 
                case I64_STORE32: {
                    this.popVal(ValueType.I64);
                    this.popVal(ValueType.I32);
                    continue block75;
                }
                case I64_ADD: 
                case I64_SUB: 
                case I64_MUL: 
                case I64_DIV_S: 
                case I64_DIV_U: 
                case I64_REM_S: 
                case I64_REM_U: 
                case I64_AND: 
                case I64_OR: 
                case I64_XOR: 
                case I64_SHL: 
                case I64_SHR_U: 
                case I64_SHR_S: 
                case I64_ROTL: 
                case I64_ROTR: {
                    this.popVal(ValueType.I64);
                    this.popVal(ValueType.I64);
                    this.pushVal(ValueType.I64);
                    continue block75;
                }
                case I64_EQ: 
                case I64_NE: 
                case I64_LT_S: 
                case I64_LT_U: 
                case I64_LE_S: 
                case I64_LE_U: 
                case I64_GT_S: 
                case I64_GT_U: 
                case I64_GE_S: 
                case I64_GE_U: {
                    this.popVal(ValueType.I64);
                    this.popVal(ValueType.I64);
                    this.pushVal(ValueType.I32);
                    continue block75;
                }
                case I64_CLZ: 
                case I64_CTZ: 
                case I64_POPCNT: 
                case I64_EXTEND_8_S: 
                case I64_EXTEND_16_S: 
                case I64_EXTEND_32_S: {
                    this.popVal(ValueType.I64);
                    this.pushVal(ValueType.I64);
                    continue block75;
                }
                case I64_REINTERPRET_F64: 
                case I64_TRUNC_F64_S: 
                case I64_TRUNC_F64_U: 
                case I64_TRUNC_SAT_F64_S: 
                case I64_TRUNC_SAT_F64_U: {
                    this.popVal(ValueType.F64);
                    this.pushVal(ValueType.I64);
                    continue block75;
                }
                case I64_TRUNC_F32_S: 
                case I64_TRUNC_F32_U: 
                case I64_TRUNC_SAT_F32_S: 
                case I64_TRUNC_SAT_F32_U: {
                    this.popVal(ValueType.F32);
                    this.pushVal(ValueType.I64);
                    continue block75;
                }
                case F32_STORE: {
                    this.popVal(ValueType.F32);
                    this.popVal(ValueType.I32);
                    continue block75;
                }
                case F32_CONST: {
                    this.pushVal(ValueType.F32);
                    continue block75;
                }
                case F32_LOAD: 
                case F32_CONVERT_I32_S: 
                case F32_CONVERT_I32_U: 
                case F32_REINTERPRET_I32: {
                    this.popVal(ValueType.I32);
                    this.pushVal(ValueType.F32);
                    continue block75;
                }
                case F32_CONVERT_I64_S: 
                case F32_CONVERT_I64_U: {
                    this.popVal(ValueType.I64);
                    this.pushVal(ValueType.F32);
                    continue block75;
                }
                case F64_LOAD: 
                case F64_CONVERT_I32_S: 
                case F64_CONVERT_I32_U: {
                    this.popVal(ValueType.I32);
                    this.pushVal(ValueType.F64);
                    continue block75;
                }
                case F64_CONVERT_I64_S: 
                case F64_CONVERT_I64_U: 
                case F64_REINTERPRET_I64: {
                    this.popVal(ValueType.I64);
                    this.pushVal(ValueType.F64);
                    continue block75;
                }
                case F64_PROMOTE_F32: {
                    this.popVal(ValueType.F32);
                    this.pushVal(ValueType.F64);
                    continue block75;
                }
                case F32_DEMOTE_F64: {
                    this.popVal(ValueType.F64);
                    this.pushVal(ValueType.F32);
                    continue block75;
                }
                case F32_SQRT: 
                case F32_ABS: 
                case F32_NEG: 
                case F32_CEIL: 
                case F32_FLOOR: 
                case F32_TRUNC: 
                case F32_NEAREST: {
                    this.popVal(ValueType.F32);
                    this.pushVal(ValueType.F32);
                    continue block75;
                }
                case F32_ADD: 
                case F32_SUB: 
                case F32_MUL: 
                case F32_DIV: 
                case F32_MIN: 
                case F32_MAX: 
                case F32_COPYSIGN: {
                    this.popVal(ValueType.F32);
                    this.popVal(ValueType.F32);
                    this.pushVal(ValueType.F32);
                    continue block75;
                }
                case F32_EQ: 
                case F32_NE: 
                case F32_LT: 
                case F32_LE: 
                case F32_GT: 
                case F32_GE: {
                    this.popVal(ValueType.F32);
                    this.popVal(ValueType.F32);
                    this.pushVal(ValueType.I32);
                    continue block75;
                }
                case F64_STORE: {
                    this.popVal(ValueType.F64);
                    this.popVal(ValueType.I32);
                    continue block75;
                }
                case F64_CONST: {
                    this.pushVal(ValueType.F64);
                    continue block75;
                }
                case F64_SQRT: 
                case F64_ABS: 
                case F64_NEG: 
                case F64_CEIL: 
                case F64_FLOOR: 
                case F64_TRUNC: 
                case F64_NEAREST: {
                    this.popVal(ValueType.F64);
                    this.pushVal(ValueType.F64);
                    continue block75;
                }
                case F64_ADD: 
                case F64_SUB: 
                case F64_MUL: 
                case F64_DIV: 
                case F64_MIN: 
                case F64_MAX: 
                case F64_COPYSIGN: {
                    this.popVal(ValueType.F64);
                    this.popVal(ValueType.F64);
                    this.pushVal(ValueType.F64);
                    continue block75;
                }
                case F64_EQ: 
                case F64_NE: 
                case F64_LT: 
                case F64_LE: 
                case F64_GT: 
                case F64_GE: {
                    this.popVal(ValueType.F64);
                    this.popVal(ValueType.F64);
                    this.pushVal(ValueType.I32);
                    continue block75;
                }
                case LOCAL_SET: {
                    int index = (int)op.operands()[0];
                    ValueType expectedType = index < inputLen ? (ValueType)functionType.params().get(index) : TypeValidator.getLocalType(localTypes, index - inputLen);
                    this.popVal(expectedType);
                    continue block75;
                }
                case LOCAL_GET: {
                    int index = (int)op.operands()[0];
                    ValueType expectedType = index < inputLen ? (ValueType)functionType.params().get(index) : TypeValidator.getLocalType(localTypes, index - inputLen);
                    this.pushVal(expectedType);
                    continue block75;
                }
                case LOCAL_TEE: {
                    int index = (int)op.operands()[0];
                    ValueType expectedType = index < inputLen ? (ValueType)functionType.params().get(index) : TypeValidator.getLocalType(localTypes, index - inputLen);
                    this.popVal(expectedType);
                    this.pushVal(expectedType);
                    continue block75;
                }
                case GLOBAL_GET: {
                    ValueType type = instance.readGlobal((int)op.operands()[0]).type();
                    this.pushVal(type);
                    continue block75;
                }
                case GLOBAL_SET: {
                    MutabilityType mutabilityType;
                    int id = (int)op.operands()[0];
                    MutabilityType mutabilityType2 = mutabilityType = instance.globalInitializer(id) == null ? instance.imports().global(id).mutabilityType() : instance.globalInitializer(id).mutabilityType();
                    if (mutabilityType == MutabilityType.Const) {
                        throw new InvalidException("global is immutable");
                    }
                    this.popVal(instance.readGlobal(id).type());
                    continue block75;
                }
                case CALL: {
                    int j;
                    int index = (int)op.operands()[0];
                    FunctionType types = instance.type(instance.functionType(index));
                    for (j = types.params().size() - 1; j >= 0; --j) {
                        this.popVal((ValueType)types.params().get(j));
                    }
                    this.pushVals(types.returns());
                    continue block75;
                }
                case CALL_INDIRECT: {
                    int j;
                    int typeId = (int)op.operands()[0];
                    this.popVal(ValueType.I32);
                    instance.table((int)op.operands()[1]);
                    FunctionType types = instance.type(typeId);
                    for (j = types.params().size() - 1; j >= 0; --j) {
                        this.popVal((ValueType)types.params().get(j));
                    }
                    this.pushVals(types.returns());
                    continue block75;
                }
                case REF_NULL: {
                    this.pushVal(ValueType.forId((int)((int)op.operands()[0])));
                    continue block75;
                }
                case REF_IS_NULL: {
                    ValueType ref = this.popVal();
                    if (!this.isRef(ref)) {
                        throw new InvalidException("type mismatch: expected FuncRef or ExtRef, but was " + ref);
                    }
                    this.pushVal(ValueType.I32);
                    continue block75;
                }
                case REF_FUNC: {
                    int idx = (int)op.operands()[0];
                    if (idx == funcIdx && !body.isInitializedByElem()) {
                        throw new InvalidException("undeclared function reference");
                    }
                    this.pushVal(ValueType.FuncRef);
                    continue block75;
                }
                case SELECT: {
                    this.popVal(ValueType.I32);
                    ValueType t1 = this.popVal();
                    t2 = this.popVal();
                    if (!this.isNum(t1) || !this.isNum(t2)) {
                        throw new InvalidException("type mismatch: select should have numeric arguments");
                    }
                    if (t1 != t2 && t1 != ValueType.UNKNOWN && t2 != ValueType.UNKNOWN) {
                        throw new InvalidException("type mismatch, in SELECT t1: " + t1 + ", t2: " + t2);
                    }
                    if (t1 == ValueType.UNKNOWN) {
                        this.pushVal(t2);
                        continue block75;
                    }
                    this.pushVal(t1);
                    continue block75;
                }
                case SELECT_T: {
                    this.popVal(ValueType.I32);
                    ValueType t = ValueType.forId((int)((int)op.operands()[0]));
                    this.popVal(t);
                    this.popVal(t);
                    this.pushVal(t);
                    continue block75;
                }
                case TABLE_COPY: {
                    int table1Idx = (int)op.operands()[1];
                    TableInstance table1 = instance.table(table1Idx);
                    int table2Idx = (int)op.operands()[0];
                    TableInstance table2 = instance.table(table2Idx);
                    if (table1.elementType() != table2.elementType()) {
                        throw new InvalidException("type mismatch, table 1 type: " + table1.elementType() + ", table 2 type: " + table2.elementType());
                    }
                    this.popVal(ValueType.I32);
                    this.popVal(ValueType.I32);
                    this.popVal(ValueType.I32);
                    continue block75;
                }
                case TABLE_INIT: {
                    int tableidx = (int)op.operands()[1];
                    TableInstance table = instance.table(tableidx);
                    int elemIdx = (int)op.operands()[0];
                    Element elem = instance.element(elemIdx);
                    if (table.elementType() != elem.type()) {
                        throw new InvalidException("type mismatch, table type: " + table.elementType() + ", elem type: " + elem.type());
                    }
                    this.popVal(ValueType.I32);
                    this.popVal(ValueType.I32);
                    this.popVal(ValueType.I32);
                    continue block75;
                }
                case MEMORY_COPY: 
                case MEMORY_FILL: 
                case MEMORY_INIT: {
                    this.popVal(ValueType.I32);
                    this.popVal(ValueType.I32);
                    this.popVal(ValueType.I32);
                    continue block75;
                }
                case TABLE_FILL: {
                    this.popVal(ValueType.I32);
                    this.popVal(instance.table((int)op.operands()[0]).elementType());
                    this.popVal(ValueType.I32);
                    continue block75;
                }
                case TABLE_GET: {
                    this.popVal(ValueType.I32);
                    this.pushVal(instance.table((int)op.operands()[0]).elementType());
                    continue block75;
                }
                case TABLE_SET: {
                    this.popVal(instance.table((int)op.operands()[0]).elementType());
                    this.popVal(ValueType.I32);
                    continue block75;
                }
                case TABLE_GROW: {
                    this.popVal(ValueType.I32);
                    this.popVal(instance.table((int)op.operands()[0]).elementType());
                    this.pushVal(ValueType.I32);
                    continue block75;
                }
                case ELEM_DROP: {
                    int index = (int)op.operands()[0];
                    instance.element(index);
                    continue block75;
                }
                default: {
                    throw new IllegalArgumentException("Missing type validation opcode handling for " + op.opcode());
                }
            }
        }
        if (instance.module().wasmModule().codeSection() != null && instance.module().wasmModule().codeSection().isRequiresDataCount() && instance.module().wasmModule().dataCountSection() == null) {
            throw new MalformedException("data count section required");
        }
    }

    private static class CtrlFrame {
        private final OpCode opCode;
        private final List<ValueType> startTypes;
        private final List<ValueType> endTypes;
        private final int height;
        private boolean unreachable;
        private boolean hasElse;

        public CtrlFrame(OpCode opCode, List<ValueType> startTypes, List<ValueType> endTypes, int height, boolean unreachable, boolean hasElse) {
            this.opCode = opCode;
            this.startTypes = startTypes;
            this.endTypes = endTypes;
            this.height = height;
            this.unreachable = unreachable;
            this.hasElse = hasElse;
        }
    }
}

