/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.ExportFunction;
import com.dylibso.chicory.runtime.HostImports;
import com.dylibso.chicory.runtime.Machine;
import com.dylibso.chicory.runtime.Memory;
import com.dylibso.chicory.runtime.Module;
import com.dylibso.chicory.runtime.exceptions.WASMMachineException;
import com.dylibso.chicory.wasm.exceptions.ChicoryException;
import com.dylibso.chicory.wasm.types.DataSegment;
import com.dylibso.chicory.wasm.types.Element;
import com.dylibso.chicory.wasm.types.Export;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Global;
import com.dylibso.chicory.wasm.types.Table;
import com.dylibso.chicory.wasm.types.Value;
import java.util.Arrays;

public class Instance {
    private final Module module;
    private final Machine machine;
    private final FunctionBody[] functions;
    private final Memory memory;
    private final DataSegment[] dataSegments;
    private final Global[] globalInitializers;
    private final Value[] globals;
    private final int importedGlobalsOffset;
    private final int importedFunctionsOffset;
    private final int importedTablesOffset;
    private final FunctionType[] types;
    private final int[] functionTypes;
    private final HostImports imports;
    private final Table[] tables;
    private final Element[] elements;

    public Instance(Module module, Global[] globalInitializers, Value[] globals, int importedGlobalsOffset, int importedFunctionsOffset, int importedTablesOffset, Memory memory, DataSegment[] dataSegments, FunctionBody[] functions, FunctionType[] types, int[] functionTypes, HostImports imports, Table[] tables, Element[] elements) {
        this.module = module;
        this.globalInitializers = (Global[])globalInitializers.clone();
        this.globals = (Value[])globals.clone();
        this.importedGlobalsOffset = importedGlobalsOffset;
        this.importedFunctionsOffset = importedFunctionsOffset;
        this.importedTablesOffset = importedTablesOffset;
        this.memory = memory;
        this.dataSegments = dataSegments;
        this.functions = (FunctionBody[])functions.clone();
        this.types = (FunctionType[])types.clone();
        this.functionTypes = (int[])functionTypes.clone();
        this.imports = imports;
        this.machine = new Machine(this);
        this.tables = (Table[])tables.clone();
        this.elements = (Element[])elements.clone();
        this.initialize();
    }

    private void initialize() {
        if (this.memory != null) {
            this.memory.initialize(this.dataSegments);
        } else if (this.imports.memories().length > 0) {
            this.imports.memories()[0].memory().initialize(this.dataSegments);
        }
        if (this.module.export("_start") != null) {
            this.export("_start").apply(new Value[0]);
        }
    }

    public ExportFunction export(String name) {
        Export export = this.module.export(name);
        if (export == null) {
            throw new ChicoryException("Unknown export with name " + name);
        }
        int funcId = (int)export.desc().index();
        return args -> {
            this.module.logger().debug(() -> "Args: " + Arrays.toString(args));
            try {
                return this.machine.call(funcId, args, true);
            }
            catch (Exception e) {
                throw new WASMMachineException(this.machine.getStackTrace(), e);
            }
        };
    }

    public FunctionBody function(int idx) {
        if (idx < this.importedFunctionsOffset) {
            return null;
        }
        return this.functions[idx - this.importedFunctionsOffset];
    }

    public int functionCount() {
        return this.importedFunctionsOffset + this.functions.length;
    }

    public Memory memory() {
        return this.memory;
    }

    public void writeGlobal(int idx, Value val) {
        if (idx < this.importedGlobalsOffset) {
            this.imports.global(idx).setValue(val);
        }
        this.globals[idx - this.importedGlobalsOffset] = val;
    }

    public Value readGlobal(int idx) {
        if (idx < this.importedGlobalsOffset) {
            return null;
        }
        return this.globals[idx - this.importedGlobalsOffset];
    }

    public Global globalInitializer(int idx) {
        if (idx < this.importedGlobalsOffset) {
            return null;
        }
        return this.globalInitializers[idx - this.importedGlobalsOffset];
    }

    public int globalCount() {
        return this.globals.length;
    }

    public FunctionType type(int idx) {
        return this.types[idx];
    }

    public int functionType(int idx) {
        return this.functionTypes[idx];
    }

    public HostImports imports() {
        return this.imports;
    }

    public Module module() {
        return this.module;
    }

    public Table table(int idx) {
        if (idx < this.importedTablesOffset) {
            return null;
        }
        return this.tables[idx - this.importedTablesOffset];
    }

    public Element element(int idx) {
        return this.elements[idx];
    }

    public int elementCount() {
        return this.elements.length;
    }

    public void setElement(int idx, Element val) {
        this.elements[idx] = val;
    }
}

