/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.log.Logger;
import com.dylibso.chicory.log.SystemLogger;
import com.dylibso.chicory.runtime.FromHost;
import com.dylibso.chicory.runtime.HostFunction;
import com.dylibso.chicory.runtime.HostGlobal;
import com.dylibso.chicory.runtime.HostImports;
import com.dylibso.chicory.runtime.HostMemory;
import com.dylibso.chicory.runtime.HostTable;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Memory;
import com.dylibso.chicory.runtime.ModuleType;
import com.dylibso.chicory.runtime.exceptions.WASMRuntimeException;
import com.dylibso.chicory.wasm.Parser;
import com.dylibso.chicory.wasm.exceptions.ChicoryException;
import com.dylibso.chicory.wasm.exceptions.InvalidException;
import com.dylibso.chicory.wasm.types.CodeSection;
import com.dylibso.chicory.wasm.types.DataSegment;
import com.dylibso.chicory.wasm.types.ElemElem;
import com.dylibso.chicory.wasm.types.ElemFunc;
import com.dylibso.chicory.wasm.types.ElemMem;
import com.dylibso.chicory.wasm.types.ElemTable;
import com.dylibso.chicory.wasm.types.ElemType;
import com.dylibso.chicory.wasm.types.Element;
import com.dylibso.chicory.wasm.types.Export;
import com.dylibso.chicory.wasm.types.ExportDesc;
import com.dylibso.chicory.wasm.types.ExportDescType;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionSection;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Global;
import com.dylibso.chicory.wasm.types.Import;
import com.dylibso.chicory.wasm.types.ImportDescType;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.MemorySection;
import com.dylibso.chicory.wasm.types.NameCustomSection;
import com.dylibso.chicory.wasm.types.OpCode;
import com.dylibso.chicory.wasm.types.Table;
import com.dylibso.chicory.wasm.types.Value;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;

public class Module {
    public static final String START_FUNCTION_NAME = "_start";
    private final com.dylibso.chicory.wasm.Module module;
    private NameCustomSection nameSec;
    private final HashMap<String, Export> exports;
    private final Logger logger;

    protected Module(com.dylibso.chicory.wasm.Module module, Logger logger) {
        this.logger = logger;
        this.module = module;
        this.exports = new HashMap();
        if (module.exportSection() != null) {
            int cnt = module.exportSection().exportCount();
            for (int i = 0; i < cnt; ++i) {
                Export e = module.exportSection().getExport(i);
                this.exports.put(e.name(), e);
            }
        }
    }

    public Logger logger() {
        return this.logger;
    }

    public Instance instantiate() {
        return this.instantiate(new HostImports());
    }

    public Instance instantiate(HostImports hostImports) {
        Global[] globalInitializers = new Global[]{};
        if (this.module.globalSection() != null) {
            globalInitializers = this.module.globalSection().globals();
        }
        Value[] globals = new Value[globalInitializers.length];
        block25: for (int i = 0; i < globalInitializers.length; ++i) {
            Global g = globalInitializers[i];
            if (g.initInstructions().length > 2) {
                throw new RuntimeException("We don't a global initializer with multiple instructions");
            }
            Instruction instr = g.initInstructions()[0];
            switch (instr.opcode()) {
                case I32_CONST: {
                    globals[i] = Value.i32((long)instr.operands()[0]);
                    continue block25;
                }
                case I64_CONST: {
                    globals[i] = Value.i64((long)instr.operands()[0]);
                    continue block25;
                }
                case F32_CONST: {
                    globals[i] = Value.f32((long)instr.operands()[0]);
                    continue block25;
                }
                case F64_CONST: {
                    globals[i] = Value.f64((long)instr.operands()[0]);
                    continue block25;
                }
                case GLOBAL_GET: {
                    int idx = (int)instr.operands()[0];
                    globals[i] = idx < hostImports.globalCount() ? hostImports.global(idx).value() : globals[idx];
                    continue block25;
                }
                case REF_NULL: {
                    globals[i] = Value.EXTREF_NULL;
                    continue block25;
                }
                case REF_FUNC: {
                    globals[i] = Value.funcRef((long)instr.operands()[0]);
                    continue block25;
                }
                default: {
                    throw new RuntimeException("We only support i32.const, i64.const, f32.const, f64.const, global.get, ref.func and ref.null opcodes on global initializers right now. We failed to initialize opcode: " + instr.opcode());
                }
            }
        }
        DataSegment[] dataSegments = new DataSegment[]{};
        if (this.module.dataSection() != null) {
            dataSegments = this.module.dataSection().dataSegments();
        }
        FunctionType[] types = new FunctionType[]{};
        if (this.module.typeSection() != null) {
            types = this.module.typeSection().types();
        }
        int numFuncTypes = 0;
        FunctionSection funcSection = this.module.functionSection();
        if (funcSection != null) {
            numFuncTypes = funcSection.functionCount();
        }
        if (this.module.importSection() != null) {
            numFuncTypes = (int)((long)numFuncTypes + this.module.importSection().stream().filter(is -> is.desc().type() == ImportDescType.FuncIdx).count());
        }
        FunctionBody[] functions = new FunctionBody[]{};
        CodeSection codeSection = this.module.codeSection();
        if (codeSection != null) {
            functions = this.module.codeSection().functionBodies();
        }
        int importId = 0;
        Integer startFuncId = null;
        int[] functionTypes = new int[numFuncTypes];
        Import[] imports = new Import[]{};
        int funcIdx = 0;
        if (this.module.importSection() != null) {
            int cnt = this.module.importSection().importCount();
            imports = new Import[cnt];
            block26: for (int i = 0; i < cnt; ++i) {
                Import imprt = this.module.importSection().getImport(i);
                switch (imprt.desc().type()) {
                    case FuncIdx: {
                        int type;
                        functionTypes[importId] = type = (int)imprt.desc().index();
                        imports[importId++] = imprt;
                        ++funcIdx;
                        continue block26;
                    }
                    case TableIdx: 
                    case MemIdx: 
                    case GlobalIdx: {
                        imports[importId++] = imprt;
                    }
                }
            }
        }
        HostImports mappedHostImports = this.mapHostImports(imports, hostImports);
        if (this.module.startSection() != null) {
            startFuncId = (int)this.module.startSection().startIndex();
            ExportDesc desc = new ExportDesc((long)startFuncId.intValue(), ExportDescType.FuncIdx);
            Export export = new Export(START_FUNCTION_NAME, desc);
            this.exports.put(START_FUNCTION_NAME, export);
        }
        if (this.module.functionSection() != null) {
            int cnt = this.module.functionSection().functionCount();
            for (int i = 0; i < cnt; ++i) {
                functionTypes[funcIdx++] = this.module.functionSection().getFunctionType(i);
            }
        }
        Table[] tables = new Table[]{};
        Element[] elements = new Element[]{};
        if (this.module.tableSection() != null) {
            int tableLength = this.module.tableSection().tableCount();
            tables = new Table[tableLength];
            for (int i = 0; i < tableLength; ++i) {
                tables[i] = this.module.tableSection().getTable(i);
            }
            if (this.module.elementSection() != null) {
                elements = this.module.elementSection().elements();
                block29: for (Element el : this.module.elementSection().elements()) {
                    switch (el.elemType()) {
                        case Type: {
                            ElemType typeElem = (ElemType)el;
                            Instruction[] expr = typeElem.exprInstructions();
                            int addr = Module.computeConstantValue(expr);
                            for (long fi : typeElem.funcIndices()) {
                                tables[0].setRef(addr++, (int)fi);
                            }
                            continue block29;
                        }
                        case Table: {
                            ElemTable tableElem = (ElemTable)el;
                            int idx = (int)tableElem.tableIndex();
                            Instruction[] expr = tableElem.exprInstructions();
                            int addr = Module.computeConstantValue(expr);
                            for (long fi : tableElem.funcIndices()) {
                                tables[idx].setRef(addr++, (int)fi);
                            }
                            continue block29;
                        }
                        case Func: {
                            ElemFunc funcElem = (ElemFunc)el;
                            continue block29;
                        }
                        case Elem: {
                            ElemElem elemElem = (ElemElem)el;
                            continue block29;
                        }
                        case Mem: {
                            ElemMem memElem = (ElemMem)el;
                            continue block29;
                        }
                        default: {
                            throw new ChicoryException("Elment type: " + el.elemType() + " not yet supported");
                        }
                    }
                }
            }
        }
        Memory memory = null;
        if (this.module.memorySection() != null) {
            assert (mappedHostImports.memoryCount() == 0);
            MemorySection memories = this.module.memorySection();
            if (memories.memoryCount() > 1) {
                throw new ChicoryException("Multiple memories are not supported");
            }
            if (memories.memoryCount() > 0) {
                memory = new Memory(memories.getMemory(0).memoryLimits());
            }
        } else if (mappedHostImports.memoryCount() > 0) {
            assert (mappedHostImports.memoryCount() == 1);
            if (mappedHostImports.memory(0) == null || mappedHostImports.memory(0).memory() == null) {
                throw new ChicoryException("Imported memory not defined, cannot run the program");
            }
            memory = mappedHostImports.memory(0).memory();
        }
        int globalImportsOffset = 0;
        int functionImportsOffset = 0;
        int tablesImportsOffset = 0;
        block32: for (int i = 0; i < imports.length; ++i) {
            switch (imports[i].desc().type()) {
                case GlobalIdx: {
                    ++globalImportsOffset;
                    continue block32;
                }
                case FuncIdx: {
                    ++functionImportsOffset;
                    continue block32;
                }
                case TableIdx: {
                    ++tablesImportsOffset;
                    continue block32;
                }
            }
        }
        return new Instance(this, globalInitializers, globals, globalImportsOffset, functionImportsOffset, tablesImportsOffset, memory, dataSegments, functions, types, functionTypes, mappedHostImports, tables, elements);
    }

    public static int computeConstantValue(Instruction[] expr) {
        assert (expr.length == 1);
        if (expr[0].opcode() != OpCode.I32_CONST) {
            throw new RuntimeException("Don't support data segment expressions other than i32.const yet, found: " + expr[0].opcode());
        }
        return (int)expr[0].operands()[0];
    }

    private HostImports mapHostImports(Import[] imports, HostImports hostImports) {
        int hostFuncNum = 0;
        int hostGlobalNum = 0;
        int hostMemNum = 0;
        int hostTableNum = 0;
        block12: for (Import imprt : imports) {
            switch (imprt.desc().type()) {
                case FuncIdx: {
                    ++hostFuncNum;
                    continue block12;
                }
                case GlobalIdx: {
                    ++hostGlobalNum;
                    continue block12;
                }
                case MemIdx: {
                    ++hostMemNum;
                    continue block12;
                }
                case TableIdx: {
                    ++hostTableNum;
                }
            }
        }
        HostFunction[] hostFuncs = new HostFunction[hostFuncNum];
        int hostFuncIdx = 0;
        HostGlobal[] hostGlobals = new HostGlobal[hostGlobalNum];
        int hostGlobalIdx = 0;
        HostMemory[] hostMems = new HostMemory[hostMemNum];
        int hostMemIdx = 0;
        HostTable[] hostTables = new HostTable[hostTableNum];
        int hostTableIdx = 0;
        FromHost[] hostIndex = new FromHost[hostFuncNum + hostGlobalNum + hostMemNum + hostTableNum];
        for (int impIdx = 0; impIdx < imports.length; ++impIdx) {
            Import i = imports[impIdx];
            String name = i.moduleName() + "." + i.fieldName();
            boolean found = false;
            switch (i.desc().type()) {
                case FuncIdx: {
                    int j;
                    int cnt = hostImports.functionCount();
                    for (j = 0; j < cnt; ++j) {
                        HostFunction f = hostImports.function(j);
                        if (!i.moduleName().equals(f.moduleName()) || !i.fieldName().equals(f.fieldName())) continue;
                        hostFuncs[hostFuncIdx] = f;
                        hostIndex[impIdx] = f;
                        found = true;
                        break;
                    }
                    ++hostFuncIdx;
                    break;
                }
                case GlobalIdx: {
                    int j;
                    int cnt = hostImports.globalCount();
                    for (j = 0; j < cnt; ++j) {
                        HostGlobal g = hostImports.global(j);
                        if (!i.moduleName().equals(g.moduleName()) || !i.fieldName().equals(g.fieldName())) continue;
                        hostGlobals[hostGlobalIdx] = g;
                        hostIndex[impIdx] = g;
                        found = true;
                        break;
                    }
                    ++hostGlobalIdx;
                    break;
                }
                case MemIdx: {
                    int j;
                    int cnt = hostImports.memoryCount();
                    for (j = 0; j < cnt; ++j) {
                        HostMemory m = hostImports.memory(j);
                        if (!i.moduleName().equals(m.moduleName()) || !i.fieldName().equals(m.fieldName())) continue;
                        hostMems[hostMemIdx] = m;
                        hostIndex[impIdx] = m;
                        found = true;
                        break;
                    }
                    ++hostMemIdx;
                    break;
                }
                case TableIdx: {
                    int j;
                    int cnt = hostImports.tableCount();
                    for (j = 0; j < cnt; ++j) {
                        HostTable t = hostImports.table(j);
                        if (!i.moduleName().equals(t.moduleName()) || !i.fieldName().equals(t.fieldName())) continue;
                        hostTables[hostTableIdx] = t;
                        hostIndex[impIdx] = t;
                        found = true;
                        break;
                    }
                    ++hostTableIdx;
                }
            }
            if (found) continue;
            this.logger.warnf("Could not find host function for import number: %d named %s", new Object[]{impIdx, name});
        }
        HostImports result = new HostImports(hostFuncs, hostGlobals, hostMems, hostTables);
        result.setIndex(hostIndex);
        return result;
    }

    public Export export(String name) {
        return this.exports.get(name);
    }

    public NameCustomSection nameSection() {
        if (this.nameSec != null) {
            return this.nameSec;
        }
        this.nameSec = this.module.nameSection();
        return this.nameSec;
    }

    public static Builder builder(InputStream input) {
        return new Builder(() -> input);
    }

    public static Builder builder(ByteBuffer buffer) {
        return Module.builder(buffer.array());
    }

    public static Builder builder(byte[] buffer) {
        return new Builder(() -> new ByteArrayInputStream(buffer));
    }

    public static Builder builder(File file) {
        return new Builder(() -> {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("File not found at path: " + file.getPath(), e);
            }
        });
    }

    public static Builder builder(String classpathResource) {
        return new Builder(() -> {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathResource);
            if (is == null) {
                throw new IllegalArgumentException("Resource not found at classpath: " + classpathResource);
            }
            return is;
        });
    }

    public static Builder builder(Path path) {
        return new Builder(() -> {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error opening file: " + path, e);
            }
        });
    }

    public static class Builder {
        private final Supplier<InputStream> inputStreamSupplier;
        private Logger logger;
        private ModuleType moduleType;

        private Builder(Supplier<InputStream> inputStreamSupplier) {
            this.inputStreamSupplier = Objects.requireNonNull(inputStreamSupplier);
            this.moduleType = ModuleType.TEXT;
        }

        public Builder withLogger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder withType(ModuleType type) {
            this.moduleType = type;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Module build() {
            Logger logger = this.logger != null ? this.logger : new SystemLogger();
            Parser parser = new Parser(logger);
            try (InputStream is = this.inputStreamSupplier.get();){
                switch (this.moduleType) {
                    case TEXT: {
                        Module module = new Module(parser.parseModule(is), logger);
                        return module;
                    }
                }
                throw new InvalidException("type mismatch");
            }
            catch (IOException e) {
                throw new WASMRuntimeException(e);
            }
        }
    }
}

