/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.ConstantEvaluators;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.WasmRuntimeException;
import com.dylibso.chicory.wasm.ChicoryException;
import com.dylibso.chicory.wasm.UninstantiableException;
import com.dylibso.chicory.wasm.types.ActiveDataSegment;
import com.dylibso.chicory.wasm.types.DataSegment;
import com.dylibso.chicory.wasm.types.MemoryLimits;
import com.dylibso.chicory.wasm.types.PassiveDataSegment;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public final class Memory {
    public static final int PAGE_SIZE = 65536;
    public static final int RUNTIME_MAX_PAGES = Short.MAX_VALUE;
    private final MemoryLimits limits;
    private DataSegment[] dataSegments;
    private ByteBuffer buffer;
    private int nPages;

    public Memory(MemoryLimits limits) {
        this.limits = limits;
        this.buffer = Memory.allocateByteBuffer(65536 * limits.initialPages());
        this.nPages = limits.initialPages();
    }

    private static ByteBuffer allocateByteBuffer(int capacity) {
        return ByteBuffer.allocate(capacity).order(ByteOrder.LITTLE_ENDIAN);
    }

    public int pages() {
        return this.nPages;
    }

    public int grow(int size) {
        int prevPages = this.nPages;
        int numPages = prevPages + size;
        if (numPages > this.maximumPages() || numPages < prevPages) {
            return -1;
        }
        ByteBuffer oldBuffer = this.buffer;
        ByteBuffer newBuffer = Memory.allocateByteBuffer(oldBuffer.capacity() + 65536 * size);
        int position = oldBuffer.position();
        oldBuffer.rewind();
        newBuffer.put(oldBuffer);
        newBuffer.position(position);
        this.buffer = newBuffer;
        this.nPages = numPages;
        return prevPages;
    }

    public int initialPages() {
        return this.limits.initialPages();
    }

    public int maximumPages() {
        return Math.min(this.limits.maximumPages(), Short.MAX_VALUE);
    }

    void initialize(Instance instance, DataSegment[] dataSegments) {
        this.dataSegments = dataSegments;
        if (dataSegments == null) {
            return;
        }
        for (DataSegment s : dataSegments) {
            if (s instanceof ActiveDataSegment) {
                ActiveDataSegment segment = (ActiveDataSegment)s;
                List offsetExpr = segment.offsetInstructions();
                byte[] data = segment.data();
                long offset = ConstantEvaluators.computeConstantValue(instance, offsetExpr);
                this.write((int)offset, data);
                continue;
            }
            if (s instanceof PassiveDataSegment) continue;
            throw new ChicoryException("Data segment should be active or passive: " + s);
        }
    }

    public void initPassiveSegment(int segmentId, int dest, int offset, int size) {
        DataSegment segment = this.dataSegments[segmentId];
        if (!(segment instanceof PassiveDataSegment)) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
        this.write(dest, segment.data(), offset, size);
    }

    public void writeString(int offset, String data, Charset charSet) {
        this.write(offset, data.getBytes(charSet));
    }

    public void writeString(int offset, String data) {
        this.writeString(offset, data, StandardCharsets.UTF_8);
    }

    public String readString(int addr, int len) {
        return this.readString(addr, len, StandardCharsets.UTF_8);
    }

    public String readString(int addr, int len, Charset charSet) {
        return new String(this.readBytes(addr, len), charSet);
    }

    public void writeCString(int offset, String str) {
        this.writeCString(offset, str, StandardCharsets.UTF_8);
    }

    public void writeCString(int offset, String str, Charset charSet) {
        this.writeString(offset, str + "\u0000", charSet);
    }

    public String readCString(int addr, Charset charSet) {
        int c = addr;
        while (this.read(c) != 0) {
            ++c;
        }
        return new String(this.readBytes(addr, c - addr), charSet);
    }

    public String readCString(int addr) {
        return this.readCString(addr, StandardCharsets.UTF_8);
    }

    public void write(int addr, byte[] data) {
        this.write(addr, data, 0, data.length);
    }

    public void write(int addr, byte[] data, int offset, int size) {
        try {
            this.buffer.position(addr);
            this.buffer.put(data, offset, size);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | BufferOverflowException e) {
            throw new UninstantiableException("out of bounds memory access");
        }
    }

    public byte read(int addr) {
        try {
            return this.buffer.get(addr);
        }
        catch (IndexOutOfBoundsException e) {
            throw new UninstantiableException("out of bounds memory access");
        }
    }

    public byte[] readBytes(int addr, int len) {
        try {
            byte[] bytes = new byte[len];
            this.buffer.position(addr);
            this.buffer.get(bytes);
            return bytes;
        }
        catch (IllegalArgumentException | NegativeArraySizeException | BufferUnderflowException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public void writeI32(int addr, int data) {
        try {
            this.buffer.putInt(addr, data);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public int readInt(int addr) {
        try {
            return this.buffer.getInt(addr);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public long readI32(int addr) {
        return this.readInt(addr);
    }

    public long readU32(int addr) {
        return Integer.toUnsignedLong(this.readInt(addr));
    }

    public void writeLong(int addr, long data) {
        try {
            this.buffer.putLong(addr, data);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public long readLong(int addr) {
        try {
            return this.buffer.getLong(addr);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public long readI64(int addr) {
        return this.readLong(addr);
    }

    public void writeShort(int addr, short data) {
        try {
            this.buffer.putShort(addr, data);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public short readShort(int addr) {
        try {
            return this.buffer.getShort(addr);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public long readI16(int addr) {
        return this.readShort(addr);
    }

    public long readU16(int addr) {
        try {
            return this.buffer.getShort(addr) & 0xFFFF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public void writeByte(int addr, byte data) {
        try {
            this.buffer.put(addr, data);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public long readU8(int addr) {
        try {
            return this.read(addr) & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public long readI8(int addr) {
        try {
            return this.read(addr);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public void writeF32(int addr, float data) {
        try {
            this.buffer.putFloat(addr, data);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public long readF32(int addr) {
        try {
            return this.buffer.getInt(addr);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public float readFloat(int addr) {
        try {
            return this.buffer.getFloat(addr);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public void writeF64(int addr, double data) {
        try {
            this.buffer.putDouble(addr, data);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public double readDouble(int addr) {
        try {
            return this.buffer.getDouble(addr);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public long readF64(int addr) {
        try {
            return this.buffer.getLong(addr);
        }
        catch (IndexOutOfBoundsException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public void zero() {
        this.fill((byte)0);
    }

    public void fill(byte value) {
        this.fill(value, 0, this.buffer.capacity());
    }

    public void fill(byte value, int fromIndex, int toIndex) {
        try {
            Arrays.fill(this.buffer.array(), fromIndex, toIndex, value);
            this.buffer.position(0);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new WasmRuntimeException("out of bounds memory access");
        }
    }

    public void copy(int dest, int src, int size) {
        this.write(dest, this.readBytes(src, size));
    }

    public void drop(int segment) {
        this.dataSegments[segment] = PassiveDataSegment.EMPTY;
    }
}

