/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.CtrlFrame;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.MStack;
import com.dylibso.chicory.wasm.types.AnnotatedInstruction;
import com.dylibso.chicory.wasm.types.NameCustomSection;
import com.dylibso.chicory.wasm.types.OpCode;
import com.dylibso.chicory.wasm.types.Value;
import com.dylibso.chicory.wasm.types.ValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class StackFrame {
    private final List<AnnotatedInstruction> code;
    private AnnotatedInstruction currentInstruction;
    private final int funcId;
    private int pc;
    private final long[] locals;
    private final Instance instance;
    private final List<CtrlFrame> ctrlStack = new ArrayList<CtrlFrame>();

    StackFrame(Instance instance, int funcId, long[] args, List<ValueType> localTypes) {
        this(instance, funcId, args, localTypes, Collections.emptyList());
    }

    StackFrame(Instance instance, int funcId, long[] args, List<ValueType> localTypes, List<AnnotatedInstruction> code) {
        this.code = code;
        this.instance = instance;
        this.funcId = funcId;
        this.locals = Arrays.copyOf(args, args.length + localTypes.size());
        for (int i = 0; i < localTypes.size(); ++i) {
            ValueType type = localTypes.get(i);
            if (type == ValueType.V128) continue;
            this.locals[i + args.length] = Value.zero((ValueType)type);
        }
    }

    void setLocal(int i, long v) {
        this.locals[i] = v;
    }

    long local(int i) {
        return this.locals[i];
    }

    public String toString() {
        String funcName;
        NameCustomSection nameSec = this.instance.module().nameSection();
        String id = "[" + this.funcId + "]";
        if (nameSec != null && (funcName = nameSec.nameOfFunction(this.funcId)) != null) {
            id = funcName + id;
        }
        return id + "\n\tpc=" + this.pc + " locals=" + Arrays.toString(this.locals);
    }

    AnnotatedInstruction loadCurrentInstruction() {
        this.currentInstruction = this.code.get(this.pc++);
        return this.currentInstruction;
    }

    boolean isLastBlock() {
        return this.currentInstruction.depth() == 0;
    }

    boolean terminated() {
        return this.pc >= this.code.size();
    }

    void pushCtrl(CtrlFrame ctrlFrame) {
        this.ctrlStack.add(ctrlFrame);
    }

    void pushCtrl(OpCode opcode, int startValues, int returnValues, int height) {
        this.ctrlStack.add(new CtrlFrame(opcode, startValues, returnValues, height));
    }

    CtrlFrame popCtrl() {
        CtrlFrame ctrlFrame = this.ctrlStack.remove(this.ctrlStack.size() - 1);
        return ctrlFrame;
    }

    CtrlFrame popCtrl(int n) {
        int mostRecentCallHeight = this.ctrlStack.size();
        while (this.ctrlStack.get((int)(--mostRecentCallHeight)).opCode != OpCode.CALL) {
        }
        int finalHeight = this.ctrlStack.size() - (mostRecentCallHeight + n + 1);
        CtrlFrame ctrlFrame = null;
        while (this.ctrlStack.size() > finalHeight) {
            ctrlFrame = this.popCtrl();
        }
        return ctrlFrame;
    }

    CtrlFrame popCtrlTillCall() {
        CtrlFrame ctrlFrame;
        do {
            ctrlFrame = this.popCtrl();
        } while (ctrlFrame.opCode != OpCode.CALL);
        return ctrlFrame;
    }

    void jumpTo(int newPc) {
        this.pc = newPc;
    }

    static void doControlTransfer(CtrlFrame ctrlFrame, MStack stack) {
        int i;
        int endResults = ctrlFrame.startValues + ctrlFrame.endValues;
        long[] returns = new long[endResults];
        for (i = 0; i < returns.length; ++i) {
            if (stack.size() <= 0) continue;
            returns[i] = stack.pop();
        }
        while (stack.size() > ctrlFrame.height) {
            stack.pop();
        }
        for (i = 0; i < returns.length; ++i) {
            long value = returns[returns.length - 1 - i];
            stack.push(value);
        }
    }
}

