/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.OpCode;
import java.util.Arrays;
import java.util.List;

final class ConstantEvaluators {
    private ConstantEvaluators() {
    }

    public static long computeConstantValue(Instance instance, Instruction[] expr) {
        return ConstantEvaluators.computeConstantValue(instance, Arrays.asList(expr));
    }

    public static long computeConstantValue(Instance instance, List<Instruction> expr) {
        long tos = -1L;
        for (Instruction instruction : expr) {
            switch (instruction.opcode()) {
                case F32_CONST: 
                case F64_CONST: 
                case I32_CONST: 
                case I64_CONST: 
                case REF_FUNC: {
                    tos = instruction.operand(0);
                    break;
                }
                case REF_NULL: {
                    tos = -1L;
                    break;
                }
                case GLOBAL_GET: {
                    int idx = (int)instruction.operand(0);
                    tos = instance.global(idx).getValue();
                    break;
                }
            }
        }
        return tos;
    }

    public static Instance computeConstantInstance(Instance instance, List<Instruction> expr) {
        for (Instruction instruction : expr) {
            if (instruction.opcode() != OpCode.GLOBAL_GET) continue;
            return instance.global((int)instruction.operand(0)).getInstance();
        }
        return instance;
    }
}

