/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.Memory;

public final class MemCopyWorkaround {
    static MemoryCopyFunc memoryCopyFunc;

    private MemCopyWorkaround() {
    }

    public static void memoryCopy(int destination, int offset, int size, Memory memory) {
        memoryCopyFunc.apply(destination, offset, size, memory);
    }

    static {
        boolean enableMemCopyWorkaround;
        String workaround = System.getProperty("chicory.enableMemCopyWorkaround");
        if (workaround != null) {
            enableMemCopyWorkaround = Boolean.parseBoolean(workaround);
        } else {
            boolean bl = enableMemCopyWorkaround = Runtime.version().feature() < 21;
        }
        if (enableMemCopyWorkaround) {
            MemoryCopyFunc noop1 = (destination, offset, size, memory) -> {};
            MemoryCopyFunc noop2 = (destination, offset, size, memory) -> {};
            for (int i = 0; i < 1000; ++i) {
                memoryCopyFunc = noop1;
                MemCopyWorkaround.memoryCopy(0, 0, 0, null);
                memoryCopyFunc = noop2;
                MemCopyWorkaround.memoryCopy(0, 0, 0, null);
            }
        }
        memoryCopyFunc = (destination, offset, size, memory) -> memory.copy(destination, offset, size);
    }

    private static interface MemoryCopyFunc {
        public void apply(int var1, int var2, int var3, Memory var4);
    }
}

