/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.Memory;

public final class MemCopyWorkaround {
    static MemoryCopyFunc memoryCopyFunc;

    private MemCopyWorkaround() {
    }

    public static boolean shouldUseMemWorkaround() {
        String version = System.getProperty("java.version");
        if (version == null || version.equals("0")) {
            return false;
        }
        if (version.startsWith("1.")) {
            return true;
        }
        int dotIndex = version.indexOf(".");
        String majorStr = dotIndex != -1 ? version.substring(0, dotIndex) : version;
        return Integer.parseInt(majorStr) <= 17;
    }

    public static void memoryCopy(int destination, int offset, int size, Memory memory) {
        memoryCopyFunc.apply(destination, offset, size, memory);
    }

    static {
        if (MemCopyWorkaround.shouldUseMemWorkaround()) {
            MemoryCopyFunc noop1 = (destination, offset, size, memory) -> {};
            MemoryCopyFunc noop2 = (destination, offset, size, memory) -> {};
            for (int i = 0; i < 1000; ++i) {
                memoryCopyFunc = noop1;
                MemCopyWorkaround.memoryCopy(0, 0, 0, null);
                memoryCopyFunc = noop2;
                MemCopyWorkaround.memoryCopy(0, 0, 0, null);
            }
            memoryCopyFunc = (destination, offset, size, memory) -> memory.copy(destination, offset, size);
        }
    }

    private static interface MemoryCopyFunc {
        public void apply(int var1, int var2, int var3, Memory var4);
    }
}

