/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasi;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeSet;

final class Descriptors {
    private final List<Descriptor> descriptors = new ArrayList<Descriptor>();
    private final NavigableSet<Integer> freeFds = new TreeSet<Integer>();

    Descriptors() {
    }

    public Descriptor get(int fd) {
        if (fd < 0 || fd >= this.descriptors.size()) {
            return null;
        }
        return this.descriptors.get(fd);
    }

    public int allocate(Descriptor descriptor) {
        Integer fd = this.freeFds.pollFirst();
        if (fd != null) {
            this.descriptors.set(fd, descriptor);
            return fd;
        }
        this.descriptors.add(descriptor);
        return this.descriptors.size() - 1;
    }

    public void free(int fd) {
        this.descriptors.set(fd, null);
        this.freeFds.add(fd);
    }

    public void set(int fd, Descriptor descriptor) {
        this.descriptors.set(fd, descriptor);
    }

    public void closeAll() {
        Throwable exception = null;
        for (Descriptor descriptor : this.descriptors) {
            try {
                if (!(descriptor instanceof Closeable)) continue;
                ((Closeable)((Object)descriptor)).close();
            }
            catch (Throwable t) {
                if (exception == null) {
                    exception = new RuntimeException();
                }
                exception.addSuppressed(t);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    static interface Descriptor {
    }

    static final class OpenFile
    implements Descriptor,
    Closeable,
    DataReader,
    DataWriter {
        private final Path path;
        private final FileChannel channel;
        private final int fdFlags;
        private final long rights;

        public OpenFile(Path path, FileChannel channel, int fdFlags, long rights) {
            this.path = Objects.requireNonNull(path);
            this.channel = Objects.requireNonNull(channel);
            this.fdFlags = fdFlags;
            this.rights = rights;
        }

        public Path path() {
            return this.path;
        }

        public FileChannel channel() {
            return this.channel;
        }

        public int fdFlags() {
            return this.fdFlags;
        }

        public long rights() {
            return this.rights;
        }

        @Override
        public int read(byte[] data) throws IOException {
            return this.channel.read(ByteBuffer.wrap(data));
        }

        public int read(byte[] data, long position) throws IOException {
            return this.channel.read(ByteBuffer.wrap(data), position);
        }

        @Override
        public int write(byte[] data) throws IOException {
            return this.channel.write(ByteBuffer.wrap(data));
        }

        public int write(byte[] data, long position) throws IOException {
            return this.channel.write(ByteBuffer.wrap(data), position);
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }
    }

    static final class OpenDirectory
    implements Descriptor,
    Directory {
        private final Path path;

        public OpenDirectory(Path path) {
            this.path = Objects.requireNonNull(path);
        }

        @Override
        public Path path() {
            return this.path;
        }
    }

    static final class PreopenedDirectory
    implements Descriptor,
    Directory {
        private final byte[] name;
        private final Path path;

        public PreopenedDirectory(byte[] name, Path path) {
            this.name = Objects.requireNonNull(name);
            this.path = Objects.requireNonNull(path);
        }

        public byte[] name() {
            return this.name;
        }

        @Override
        public Path path() {
            return this.path;
        }
    }

    static final class OutStream
    implements Descriptor,
    DataWriter {
        private final OutputStream out;

        public OutStream(OutputStream out) {
            this.out = Objects.requireNonNull(out);
        }

        @Override
        public int write(byte[] data) throws IOException {
            this.out.write(data);
            return data.length;
        }
    }

    static final class InStream
    implements Descriptor,
    DataReader {
        private final InputStream in;

        public InStream(InputStream in) {
            this.in = Objects.requireNonNull(in);
        }

        @Override
        public int read(byte[] data) throws IOException {
            return this.in.read(data);
        }
    }

    static interface Directory {
        public Path path();
    }

    static interface DataWriter {
        public int write(byte[] var1) throws IOException;
    }

    static interface DataReader {
        public int read(byte[] var1) throws IOException;
    }
}

