/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm;

import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.OpCode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ControlTree {
    private final Instruction instruction;
    private final int initialInstructionNumber;
    private int finalInstructionNumber = -1;
    private final ControlTree parent;
    private final List<ControlTree> nested;
    private final List<Consumer<Integer>> callbacks;

    public ControlTree() {
        this.instruction = null;
        this.initialInstructionNumber = 0;
        this.parent = null;
        this.nested = new ArrayList<ControlTree>();
        this.callbacks = new ArrayList<Consumer<Integer>>();
    }

    private ControlTree(int initialInstructionNumber, Instruction instruction, ControlTree parent) {
        this.instruction = instruction;
        this.initialInstructionNumber = initialInstructionNumber;
        this.parent = parent;
        this.nested = new ArrayList<ControlTree>();
        this.callbacks = new ArrayList<Consumer<Integer>>();
    }

    public ControlTree spawn(int initialInstructionNumber, Instruction instruction) {
        ControlTree node = new ControlTree(initialInstructionNumber, instruction, this);
        this.addNested(node);
        return node;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public Instruction instruction() {
        return this.instruction;
    }

    public int instructionNumber() {
        return this.initialInstructionNumber;
    }

    public void addNested(ControlTree nested) {
        this.nested.add(nested);
    }

    public ControlTree parent() {
        return this.parent;
    }

    public List<ControlTree> nested() {
        return this.nested;
    }

    public void addCallback(Consumer<Integer> callback) {
        this.callbacks.add(callback);
    }

    public void setFinalInstructionNumber(int finalInstructionNumber, Instruction end) {
        this.finalInstructionNumber = finalInstructionNumber;
        if (end.scope().opcode() == OpCode.LOOP) {
            int lastLoopInstruction = 0;
            for (ControlTree ct : this.parent.nested) {
                if (ct.instruction().opcode() != OpCode.LOOP) continue;
                lastLoopInstruction = ct.instructionNumber();
            }
            this.finalInstructionNumber = lastLoopInstruction + 1;
        }
        for (Consumer<Integer> callback : this.callbacks) {
            callback.accept(this.finalInstructionNumber);
        }
    }
}

