/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Section;
import com.dylibso.chicory.wasm.types.TypeSection;
import java.util.Arrays;
import java.util.Objects;

public class FunctionSection
extends Section {
    private int[] typeIndices;
    private int count;

    public FunctionSection() {
        this(new int[8]);
    }

    public FunctionSection(int estimatedSize) {
        this(new int[Math.max(8, estimatedSize)]);
    }

    private FunctionSection(int[] typeIndices) {
        super(3L);
        this.typeIndices = typeIndices;
        this.count = 0;
    }

    public int functionCount() {
        return this.count;
    }

    public int getFunctionType(int idx) {
        Objects.checkIndex(idx, this.count);
        return this.typeIndices[idx];
    }

    public FunctionType getFunctionType(int idx, TypeSection typeSection) {
        return typeSection.getType(this.getFunctionType(idx));
    }

    public int addFunctionType(int typeIndex) {
        int count = this.count;
        if (count == this.typeIndices.length) {
            this.typeIndices = Arrays.copyOf(this.typeIndices, count + (count >> 1));
        }
        this.typeIndices[count] = typeIndex;
        this.count = count + 1;
        return count;
    }
}

