/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

import com.dylibso.chicory.wasm.exceptions.ChicoryException;
import com.dylibso.chicory.wasm.types.Limits;
import com.dylibso.chicory.wasm.types.Value;
import com.dylibso.chicory.wasm.types.ValueType;
import java.util.Arrays;
import java.util.Objects;

public class Table {
    private final ValueType elementType;
    private final Limits limits;
    private int[] refs;

    public Table(ValueType elementType, Limits limits) {
        this.elementType = Objects.requireNonNull(elementType, "elementType");
        if (!elementType.isReference()) {
            throw new IllegalArgumentException("Table element type must be a reference type");
        }
        this.limits = Objects.requireNonNull(limits, "limits");
        this.refs = new int[(int)limits.min()];
        Arrays.fill(this.refs, -1);
    }

    public ValueType elementType() {
        return this.elementType;
    }

    public Limits limits() {
        return this.limits;
    }

    public int size() {
        return this.refs.length;
    }

    public int grow(int size, int value) {
        int oldSize = this.refs.length;
        int targetSize = oldSize + size;
        if (size < 0 || (long)targetSize > this.limits().max()) {
            return -1;
        }
        int[] newRefs = Arrays.copyOf(this.refs, targetSize);
        Arrays.fill(newRefs, oldSize, targetSize, value);
        this.refs = newRefs;
        return oldSize;
    }

    public Value ref(int index) {
        int res;
        try {
            res = this.refs[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new ChicoryException("undefined element", e);
        }
        if (this.elementType() == ValueType.FuncRef) {
            return Value.funcRef(res);
        }
        return Value.externRef(res);
    }

    public void setRef(int index, int value) {
        try {
            this.refs[index] = value;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ChicoryException("out of bounds table access", e);
        }
    }

    public void reset() {
        for (int i = 0; i < this.refs.length; ++i) {
            this.refs[i] = -1;
        }
    }
}

