/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

public class MemoryLimits {
    public static final int MAX_PAGES = 65536;
    private final int initial;
    private final int maximum;

    public MemoryLimits(int initial) {
        this(initial, 65536);
    }

    public MemoryLimits(int initial, int maximum) {
        if (initial < 0 || initial > maximum) {
            throw new IllegalArgumentException("initial must be >= 0 and <= maximum, but was " + initial);
        }
        if (maximum > 65536) {
            throw new IllegalArgumentException("maximum must be <= MAX_PAGES, but was " + maximum);
        }
        this.initial = initial;
        this.maximum = maximum;
    }

    public static MemoryLimits defaultLimits() {
        return new MemoryLimits(0, 65536);
    }

    public int initialPages() {
        return this.initial;
    }

    public int maximumPages() {
        return this.maximum;
    }
}

