/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

import com.dylibso.chicory.wasm.Parser;
import com.dylibso.chicory.wasm.types.CustomSection;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class NameCustomSection
extends CustomSection {
    private final ArrayList<String> funcNames;

    public NameCustomSection(byte[] bytes) {
        this.funcNames = this.parseFunctionNames(bytes);
    }

    @Override
    public String name() {
        return "name";
    }

    private ArrayList<String> parseFunctionNames(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        if (buf.get() != 1) {
            throw new IllegalArgumentException("Not a function name subsection");
        }
        Parser.readVarUInt32(buf);
        long nameMapLength = Parser.readVarUInt32(buf);
        ArrayList<String> names = new ArrayList<String>(Math.toIntExact(nameMapLength));
        int i = 0;
        while ((long)i < nameMapLength) {
            Parser.readVarUInt32(buf);
            names.add(Parser.readName(buf));
            ++i;
        }
        return names;
    }

    public int functionNameCount() {
        return this.funcNames.size();
    }

    public String getFunctionName(int idx) {
        return this.funcNames.get(idx);
    }
}

