/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm;

import com.dylibso.chicory.log.Logger;
import com.dylibso.chicory.wasm.ControlTree;
import com.dylibso.chicory.wasm.Encoding;
import com.dylibso.chicory.wasm.Module;
import com.dylibso.chicory.wasm.ParserListener;
import com.dylibso.chicory.wasm.exceptions.ChicoryException;
import com.dylibso.chicory.wasm.exceptions.MalformedException;
import com.dylibso.chicory.wasm.types.ActiveDataSegment;
import com.dylibso.chicory.wasm.types.ActiveElement;
import com.dylibso.chicory.wasm.types.CodeSection;
import com.dylibso.chicory.wasm.types.CustomSection;
import com.dylibso.chicory.wasm.types.DataSection;
import com.dylibso.chicory.wasm.types.DeclarativeElement;
import com.dylibso.chicory.wasm.types.Element;
import com.dylibso.chicory.wasm.types.ElementSection;
import com.dylibso.chicory.wasm.types.ElementType;
import com.dylibso.chicory.wasm.types.Export;
import com.dylibso.chicory.wasm.types.ExportSection;
import com.dylibso.chicory.wasm.types.ExternalType;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionImport;
import com.dylibso.chicory.wasm.types.FunctionSection;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Global;
import com.dylibso.chicory.wasm.types.GlobalImport;
import com.dylibso.chicory.wasm.types.GlobalSection;
import com.dylibso.chicory.wasm.types.ImportSection;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.Limits;
import com.dylibso.chicory.wasm.types.Memory;
import com.dylibso.chicory.wasm.types.MemoryImport;
import com.dylibso.chicory.wasm.types.MemoryLimits;
import com.dylibso.chicory.wasm.types.MemorySection;
import com.dylibso.chicory.wasm.types.MutabilityType;
import com.dylibso.chicory.wasm.types.NameCustomSection;
import com.dylibso.chicory.wasm.types.OpCode;
import com.dylibso.chicory.wasm.types.PassiveDataSegment;
import com.dylibso.chicory.wasm.types.PassiveElement;
import com.dylibso.chicory.wasm.types.Section;
import com.dylibso.chicory.wasm.types.StartSection;
import com.dylibso.chicory.wasm.types.Table;
import com.dylibso.chicory.wasm.types.TableImport;
import com.dylibso.chicory.wasm.types.TableSection;
import com.dylibso.chicory.wasm.types.TypeSection;
import com.dylibso.chicory.wasm.types.UnknownCustomSection;
import com.dylibso.chicory.wasm.types.ValueType;
import com.dylibso.chicory.wasm.types.WasmEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class Parser {
    private static final int MAGIC_BYTES = 1836278016;
    private final Map<String, Function<byte[], CustomSection>> customParsers;
    private final BitSet includeSections;
    private final Logger logger;

    public Parser(Logger logger) {
        this(logger, new BitSet());
    }

    public Parser(Logger logger, BitSet includeSections) {
        this(logger, includeSections, Map.of("name", NameCustomSection::new));
    }

    public Parser(Logger logger, BitSet includeSections, Map<String, Function<byte[], CustomSection>> customParsers) {
        this.logger = Objects.requireNonNull(logger, "logger");
        this.includeSections = Objects.requireNonNull(includeSections, "includeSections");
        this.customParsers = Map.copyOf(customParsers);
    }

    private ByteBuffer readByteBuffer(InputStream is) {
        try {
            ByteBuffer buffer = ByteBuffer.wrap(is.readAllBytes());
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            return buffer;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read wasm bytes.", e);
        }
    }

    public Module parseModule(InputStream in) {
        Module module = new Module();
        this.parse(in, s -> {
            switch (s.sectionId()) {
                case 0: {
                    module.addCustomSection((CustomSection)s);
                    break;
                }
                case 1: {
                    module.setTypeSection((TypeSection)s);
                    break;
                }
                case 2: {
                    module.setImportSection((ImportSection)s);
                    break;
                }
                case 3: {
                    module.setFunctionSection((FunctionSection)s);
                    break;
                }
                case 4: {
                    module.setTableSection((TableSection)s);
                    break;
                }
                case 5: {
                    module.setMemorySection((MemorySection)s);
                    break;
                }
                case 6: {
                    module.setGlobalSection((GlobalSection)s);
                    break;
                }
                case 7: {
                    module.setExportSection((ExportSection)s);
                    break;
                }
                case 8: {
                    module.setStartSection((StartSection)s);
                    break;
                }
                case 9: {
                    module.setElementSection((ElementSection)s);
                    break;
                }
                case 10: {
                    module.setCodeSection((CodeSection)s);
                    break;
                }
                case 11: {
                    module.setDataSection((DataSection)s);
                    break;
                }
                default: {
                    this.logger.warnf("Ignoring section with id: %d", new Object[]{s.sectionId()});
                }
            }
        });
        return module;
    }

    void parse(InputStream in, ParserListener listener) {
        Objects.requireNonNull(listener, "listener");
        ByteBuffer buffer = this.readByteBuffer(in);
        int magicNumber = buffer.getInt();
        if (magicNumber != 1836278016) {
            throw new MalformedException("unexpected token: magic number mismatch, found: " + magicNumber + " expected: 1836278016");
        }
        int version = buffer.getInt();
        if (version != 1) {
            throw new MalformedException("unexpected token: unsupported version, found: " + version + " expected: 1");
        }
        block14: while (buffer.hasRemaining()) {
            byte sectionId = buffer.get();
            long sectionSize = Parser.readVarUInt32(buffer);
            if (this.shouldParseSection(sectionId)) {
                switch (sectionId) {
                    case 0: {
                        CustomSection customSection = this.parseCustomSection(buffer, sectionSize);
                        listener.onSection(customSection);
                        continue block14;
                    }
                    case 1: {
                        TypeSection typeSection = Parser.parseTypeSection(buffer);
                        listener.onSection(typeSection);
                        continue block14;
                    }
                    case 2: {
                        ImportSection importSection = Parser.parseImportSection(buffer);
                        listener.onSection(importSection);
                        continue block14;
                    }
                    case 3: {
                        FunctionSection funcSection = Parser.parseFunctionSection(buffer);
                        listener.onSection(funcSection);
                        continue block14;
                    }
                    case 4: {
                        TableSection tableSection = Parser.parseTableSection(buffer);
                        listener.onSection(tableSection);
                        continue block14;
                    }
                    case 5: {
                        MemorySection memorySection = Parser.parseMemorySection(buffer);
                        listener.onSection(memorySection);
                        continue block14;
                    }
                    case 6: {
                        GlobalSection globalSection = Parser.parseGlobalSection(buffer);
                        listener.onSection(globalSection);
                        continue block14;
                    }
                    case 7: {
                        ExportSection exportSection = Parser.parseExportSection(buffer);
                        listener.onSection(exportSection);
                        continue block14;
                    }
                    case 8: {
                        StartSection startSection = Parser.parseStartSection(buffer);
                        listener.onSection(startSection);
                        continue block14;
                    }
                    case 9: {
                        ElementSection elementSection = Parser.parseElementSection(buffer, sectionSize);
                        listener.onSection(elementSection);
                        continue block14;
                    }
                    case 10: {
                        CodeSection codeSection = Parser.parseCodeSection(buffer);
                        listener.onSection(codeSection);
                        continue block14;
                    }
                    case 11: {
                        DataSection dataSection = Parser.parseDataSection(buffer);
                        listener.onSection(dataSection);
                        continue block14;
                    }
                }
                listener.onSection(new Section(sectionId));
                buffer.position((int)((long)buffer.position() + sectionSize));
                continue;
            }
            System.out.println("Skipping Section with ID due to configuration: " + sectionId);
            buffer.position((int)((long)buffer.position() + sectionSize));
        }
    }

    public void includeSection(int sectionId) {
        this.includeSections.set(sectionId);
    }

    private boolean shouldParseSection(int sectionId) {
        if (this.includeSections.isEmpty()) {
            return true;
        }
        return this.includeSections.get(sectionId);
    }

    private CustomSection parseCustomSection(ByteBuffer buffer, long sectionSize) {
        String name = Parser.readName(buffer);
        int byteLen = name.getBytes().length;
        long size = sectionSize - (long)byteLen - (long)Encoding.computeLeb128Size(byteLen);
        int remaining = buffer.limit() - buffer.position();
        if (remaining > 0) {
            size = Math.min((long)remaining, size);
        }
        byte[] bytes = new byte[(int)size];
        buffer.get(bytes);
        Function<byte[], CustomSection> parser = this.customParsers.get(name);
        return parser == null ? new UnknownCustomSection(name, bytes) : parser.apply(bytes);
    }

    private static TypeSection parseTypeSection(ByteBuffer buffer) {
        long typeCount = Parser.readVarUInt32(buffer);
        TypeSection typeSection = new TypeSection((int)typeCount);
        int i = 0;
        while ((long)i < typeCount) {
            long form = Parser.readVarUInt32(buffer);
            if (form != 96L) {
                throw new RuntimeException("We don't support non func types. Form " + String.format("0x%02X", form) + " was given but we expected 0x60");
            }
            int paramCount = (int)Parser.readVarUInt32(buffer);
            ValueType[] params = new ValueType[paramCount];
            for (int j = 0; j < paramCount; ++j) {
                params[j] = ValueType.byId(Parser.readVarUInt32(buffer));
            }
            int returnCount = (int)Parser.readVarUInt32(buffer);
            ValueType[] returns = new ValueType[returnCount];
            for (int j = 0; j < returnCount; ++j) {
                returns[j] = ValueType.byId(Parser.readVarUInt32(buffer));
            }
            typeSection.addFunctionType(new FunctionType(params, returns));
            ++i;
        }
        return typeSection;
    }

    private static ImportSection parseImportSection(ByteBuffer buffer) {
        long importCount = Parser.readVarUInt32(buffer);
        ImportSection importSection = new ImportSection((int)importCount);
        int i = 0;
        while ((long)i < importCount) {
            String moduleName = Parser.readName(buffer);
            String importName = Parser.readName(buffer);
            ExternalType descType = ExternalType.byId((int)Parser.readVarUInt32(buffer));
            switch (descType) {
                case FUNCTION: {
                    importSection.addImport(new FunctionImport(moduleName, importName, (int)Parser.readVarUInt32(buffer)));
                    break;
                }
                case TABLE: {
                    long rawTableType = Parser.readVarUInt32(buffer);
                    assert (rawTableType == 112L || rawTableType == 111L);
                    ValueType tableType = rawTableType == 112L ? ValueType.FuncRef : ValueType.ExternRef;
                    int limitType = (int)Parser.readVarUInt32(buffer);
                    assert (limitType == 0 || limitType == 1);
                    int min = (int)Parser.readVarUInt32(buffer);
                    Limits limits = limitType > 0 ? new Limits(min, Parser.readVarUInt32(buffer)) : new Limits(min);
                    importSection.addImport(new TableImport(moduleName, importName, tableType, limits));
                    break;
                }
                case MEMORY: {
                    int limitType = (int)Parser.readVarUInt32(buffer);
                    assert (limitType == 0 || limitType == 1);
                    int min = (int)Math.min(65536L, Parser.readVarUInt32(buffer));
                    MemoryLimits limits = limitType > 0 ? new MemoryLimits(min, (int)Math.min(65536L, Parser.readVarUInt32(buffer))) : new MemoryLimits(min, 65536);
                    importSection.addImport(new MemoryImport(moduleName, importName, limits));
                    break;
                }
                case GLOBAL: {
                    ValueType globalValType = ValueType.byId(Parser.readVarUInt32(buffer));
                    MutabilityType globalMut = MutabilityType.byId(Parser.readVarUInt32(buffer));
                    importSection.addImport(new GlobalImport(moduleName, importName, globalMut, globalValType));
                }
            }
            ++i;
        }
        return importSection;
    }

    private static FunctionSection parseFunctionSection(ByteBuffer buffer) {
        long functionCount = Parser.readVarUInt32(buffer);
        FunctionSection functionSection = new FunctionSection((int)functionCount);
        int i = 0;
        while ((long)i < functionCount) {
            long typeIndex = Parser.readVarUInt32(buffer);
            functionSection.addFunctionType((int)typeIndex);
            ++i;
        }
        return functionSection;
    }

    private static TableSection parseTableSection(ByteBuffer buffer) {
        long tableCount = Parser.readVarUInt32(buffer);
        TableSection tableSection = new TableSection((int)tableCount);
        int i = 0;
        while ((long)i < tableCount) {
            ElementType tableType = ElementType.byId(Parser.readVarUInt32(buffer));
            long limitType = Parser.readVarUInt32(buffer);
            assert (limitType == 0L || limitType == 1L);
            long min = Parser.readVarUInt32(buffer);
            Limits limits = limitType > 0L ? new Limits(min, Parser.readVarUInt32(buffer)) : new Limits(min);
            tableSection.addTable(new Table(tableType, limits));
            ++i;
        }
        return tableSection;
    }

    private static MemorySection parseMemorySection(ByteBuffer buffer) {
        long memoryCount = Parser.readVarUInt32(buffer);
        MemorySection memorySection = new MemorySection((int)memoryCount);
        int i = 0;
        while ((long)i < memoryCount) {
            MemoryLimits limits = Parser.parseMemoryLimits(buffer);
            memorySection.addMemory(new Memory(limits));
            ++i;
        }
        return memorySection;
    }

    private static MemoryLimits parseMemoryLimits(ByteBuffer buffer) {
        long limitType = Parser.readVarUInt32(buffer);
        assert (limitType == 0L || limitType == 1L);
        int initial = (int)Parser.readVarUInt32(buffer);
        if (limitType != 1L) {
            return new MemoryLimits(initial);
        }
        int maximum = (int)Parser.readVarUInt32(buffer);
        return new MemoryLimits(initial, maximum);
    }

    private static GlobalSection parseGlobalSection(ByteBuffer buffer) {
        long globalCount = Parser.readVarUInt32(buffer);
        GlobalSection globalSection = new GlobalSection((int)globalCount);
        int i = 0;
        while ((long)i < globalCount) {
            ValueType valueType = ValueType.byId(Parser.readVarUInt32(buffer));
            MutabilityType mutabilityType = MutabilityType.byId(Parser.readVarUInt32(buffer));
            Instruction[] init = Parser.parseExpression(buffer);
            globalSection.addGlobal(new Global(valueType, mutabilityType, List.of(init)));
            ++i;
        }
        return globalSection;
    }

    private static ExportSection parseExportSection(ByteBuffer buffer) {
        long exportCount = Parser.readVarUInt32(buffer);
        ExportSection exportSection = new ExportSection((int)exportCount);
        int i = 0;
        while ((long)i < exportCount) {
            String name = Parser.readName(buffer);
            ExternalType exportType = ExternalType.byId((int)Parser.readVarUInt32(buffer));
            int index = (int)Parser.readVarUInt32(buffer);
            exportSection.addExport(new Export(name, index, exportType));
            ++i;
        }
        return exportSection;
    }

    private static StartSection parseStartSection(ByteBuffer buffer) {
        StartSection startSection = new StartSection();
        startSection.setStartIndex(Parser.readVarUInt32(buffer));
        return startSection;
    }

    private static ElementSection parseElementSection(ByteBuffer buffer, long sectionSize) {
        int initialPosition = buffer.position();
        long elementCount = Parser.readVarUInt32(buffer);
        ElementSection elementSection = new ElementSection((int)elementCount);
        int i = 0;
        while ((long)i < elementCount) {
            elementSection.addElement(Parser.parseSingleElement(buffer));
            ++i;
        }
        assert ((long)buffer.position() == (long)initialPosition + sectionSize);
        return elementSection;
    }

    private static Element parseSingleElement(ByteBuffer buffer) {
        ValueType type;
        int flags = (int)Parser.readVarUInt32(buffer);
        boolean active = (flags & 1) == 0;
        boolean declarative = !active && (flags & 2) != 0;
        boolean passive = !active && !declarative;
        boolean hasTableIdx = active && (flags & 2) != 0;
        boolean alwaysFuncRef = active && !hasTableIdx;
        boolean exprInit = (flags & 4) != 0;
        boolean hasElemKind = !exprInit && !alwaysFuncRef;
        boolean hasRefType = exprInit && !alwaysFuncRef;
        int tableIdx = 0;
        List<Instruction> offset = List.of();
        if (active) {
            if (hasTableIdx) {
                tableIdx = Math.toIntExact(Parser.readVarUInt32(buffer));
            }
            offset = List.of(Parser.parseExpression(buffer));
        }
        if (alwaysFuncRef) {
            type = ValueType.FuncRef;
        } else if (hasElemKind) {
            int ek = (int)Parser.readVarUInt32(buffer);
            switch (ek) {
                case 0: {
                    type = ValueType.FuncRef;
                    break;
                }
                default: {
                    throw new ChicoryException("Invalid element kind");
                }
            }
        } else {
            assert (hasRefType);
            type = ValueType.refTypeForId(Math.toIntExact(Parser.readVarUInt32(buffer)));
        }
        int initCnt = Math.toIntExact(Parser.readVarUInt32(buffer));
        ArrayList<List<Instruction>> inits = new ArrayList<List<Instruction>>(initCnt);
        if (exprInit) {
            for (int i = 0; i < initCnt; ++i) {
                inits.add(List.of(Parser.parseExpression(buffer)));
            }
        } else {
            for (int i = 0; i < initCnt; ++i) {
                inits.add(List.of(new Instruction(-1, OpCode.REF_FUNC, new long[]{Parser.readVarUInt32(buffer)}), new Instruction(-1, OpCode.END, new long[0])));
            }
        }
        if (declarative) {
            return new DeclarativeElement(type, inits);
        }
        if (passive) {
            return new PassiveElement(type, inits);
        }
        assert (active);
        return new ActiveElement(type, inits, tableIdx, offset);
    }

    private static long[] readFuncIndices(ByteBuffer buffer) {
        long funcIndexCount = Parser.readVarUInt32(buffer);
        long[] funcIndices = new long[(int)funcIndexCount];
        int j = 0;
        while ((long)j < funcIndexCount) {
            funcIndices[j] = Parser.readVarUInt32(buffer);
            ++j;
        }
        return funcIndices;
    }

    private static Instruction[][] readExprs(ByteBuffer buffer) {
        long exprIndexCount = Parser.readVarUInt32(buffer);
        Instruction[][] exprs = new Instruction[(int)exprIndexCount][];
        int j = 0;
        while ((long)j < exprIndexCount) {
            Instruction[] instr = Parser.parseExpression(buffer);
            exprs[j] = instr;
            ++j;
        }
        return exprs;
    }

    private static List<ValueType> parseCodeSectionLocalTypes(ByteBuffer buffer) {
        long distinctTypesCount = Parser.readVarUInt32(buffer);
        ArrayList<ValueType> locals = new ArrayList<ValueType>();
        int i = 0;
        while ((long)i < distinctTypesCount) {
            long numberOfLocals = Parser.readVarUInt32(buffer);
            ValueType type = ValueType.byId(Parser.readVarUInt32(buffer));
            int j = 0;
            while ((long)j < numberOfLocals) {
                locals.add(type);
                ++j;
            }
            ++i;
        }
        return locals;
    }

    private static CodeSection parseCodeSection(ByteBuffer buffer) {
        long funcBodyCount = Parser.readVarUInt32(buffer);
        ControlTree root = new ControlTree();
        CodeSection codeSection = new CodeSection((int)funcBodyCount);
        int i = 0;
        while ((long)i < funcBodyCount) {
            ArrayDeque<Instruction> blockScope = new ArrayDeque<Instruction>();
            int depth = 0;
            long funcEndPoint = Parser.readVarUInt32(buffer) + (long)buffer.position();
            List<ValueType> locals = Parser.parseCodeSectionLocalTypes(buffer);
            ArrayList<Instruction> instructions = new ArrayList<Instruction>();
            boolean lastInstruction = false;
            ControlTree currentControlFlow = null;
            do {
                Instruction instruction = Parser.parseInstruction(buffer);
                boolean bl = lastInstruction = (long)buffer.position() >= funcEndPoint;
                if (instructions.isEmpty()) {
                    currentControlFlow = root.spawn(0, instruction);
                }
                switch (instruction.opcode()) {
                    case BLOCK: 
                    case LOOP: 
                    case IF: {
                        instruction.setDepth(++depth);
                        blockScope.push(instruction);
                        instruction.setScope((Instruction)blockScope.peek());
                        break;
                    }
                    case END: {
                        instruction.setDepth(depth--);
                        instruction.setScope(blockScope.isEmpty() ? instruction : (Instruction)blockScope.pop());
                        break;
                    }
                    default: {
                        instruction.setDepth(depth);
                    }
                }
                switch (instruction.opcode()) {
                    case BLOCK: 
                    case LOOP: {
                        currentControlFlow = currentControlFlow.spawn(instructions.size(), instruction);
                        break;
                    }
                    case IF: {
                        currentControlFlow = currentControlFlow.spawn(instructions.size(), instruction);
                        int defaultJmp = instructions.size() + 1;
                        currentControlFlow.addCallback(end -> {
                            if (instruction.labelFalse() == defaultJmp) {
                                instruction.setLabelFalse((Integer)end);
                            }
                        });
                        instruction.setLabelTrue(defaultJmp);
                        instruction.setLabelFalse(defaultJmp);
                        break;
                    }
                    case ELSE: {
                        assert (currentControlFlow.instruction().opcode() == OpCode.IF);
                        currentControlFlow.instruction().setLabelFalse(instructions.size() + 1);
                        currentControlFlow.addCallback(instruction::setLabelTrue);
                        break;
                    }
                    case BR_IF: {
                        instruction.setLabelFalse(instructions.size() + 1);
                    }
                    case BR: {
                        ControlTree reference = currentControlFlow;
                        for (int offset = (int)instruction.operands()[0]; offset > 0; --offset) {
                            reference = reference.parent();
                        }
                        reference.addCallback(instruction::setLabelTrue);
                        break;
                    }
                    case BR_TABLE: {
                        instruction.setLabelTable(new int[instruction.operands().length]);
                        int idx = 0;
                        while (idx < instruction.labelTable().length) {
                            ControlTree reference = currentControlFlow;
                            for (int offset = (int)instruction.operands()[idx]; offset > 0; --offset) {
                                reference = reference.parent();
                            }
                            int finalIdx = idx++;
                            reference.addCallback(end -> {
                                instruction.labelTable()[finalIdx] = end;
                            });
                        }
                        break;
                    }
                    case END: {
                        Instruction former;
                        currentControlFlow.setFinalInstructionNumber(instructions.size(), instruction);
                        currentControlFlow = currentControlFlow.parent();
                        if (!lastInstruction || instructions.size() <= 1 || (former = instructions.get(instructions.size() - 1)).opcode() != OpCode.END) break;
                        instruction.setScope(former.scope());
                    }
                }
                instructions.add(instruction);
            } while (!lastInstruction);
            codeSection.addFunctionBody(new FunctionBody(locals, instructions));
            ++i;
        }
        return codeSection;
    }

    private static DataSection parseDataSection(ByteBuffer buffer) {
        long dataSegmentCount = Parser.readVarUInt32(buffer);
        DataSection dataSection = new DataSection((int)dataSegmentCount);
        int i = 0;
        while ((long)i < dataSegmentCount) {
            long mode = Parser.readVarUInt32(buffer);
            if (mode == 0L) {
                Instruction[] offset = Parser.parseExpression(buffer);
                byte[] data = new byte[(int)Parser.readVarUInt32(buffer)];
                buffer.get(data);
                dataSection.addDataSegment(new ActiveDataSegment(List.of(offset), data));
            } else if (mode == 1L) {
                byte[] data = new byte[(int)Parser.readVarUInt32(buffer)];
                buffer.get(data);
                dataSection.addDataSegment(new PassiveDataSegment(data));
            } else if (mode == 2L) {
                long memoryId = Parser.readVarUInt32(buffer);
                Instruction[] offset = Parser.parseExpression(buffer);
                byte[] data = new byte[(int)Parser.readVarUInt32(buffer)];
                buffer.get(data);
                dataSection.addDataSegment(new ActiveDataSegment(memoryId, List.of(offset), data));
            } else {
                throw new ChicoryException("Failed to parse data segment with data mode: " + mode);
            }
            ++i;
        }
        return dataSection;
    }

    private static Instruction parseInstruction(ByteBuffer buffer) {
        OpCode op;
        int address = buffer.position();
        int b = buffer.get() & 0xFF;
        if (b == 252) {
            b = (int)(64512L + Encoding.readUnsignedLeb128(buffer));
        }
        if ((op = OpCode.byOpCode(b)) == null) {
            throw new IllegalArgumentException("Can't find opcode for op value " + b);
        }
        WasmEncoding[] signature = OpCode.getSignature(op);
        if (signature.length == 0) {
            return new Instruction(address, op, new long[0]);
        }
        ArrayList<Long> operands = new ArrayList<Long>();
        block8: for (WasmEncoding sig : signature) {
            switch (sig) {
                case VARUINT: {
                    operands.add(Parser.readVarUInt32(buffer));
                    continue block8;
                }
                case VARSINT32: {
                    operands.add(Parser.readVarSInt32(buffer));
                    continue block8;
                }
                case VARSINT64: {
                    operands.add(Parser.readVarSInt64(buffer));
                    continue block8;
                }
                case FLOAT64: {
                    operands.add(Parser.readFloat64(buffer));
                    continue block8;
                }
                case FLOAT32: {
                    operands.add(Parser.readFloat32(buffer));
                    continue block8;
                }
                case VEC_VARUINT: {
                    int vcount = (int)Parser.readVarUInt32(buffer);
                    for (int j = 0; j < vcount; ++j) {
                        operands.add(Parser.readVarUInt32(buffer));
                    }
                    continue block8;
                }
            }
        }
        long[] operandsArray = new long[operands.size()];
        for (int i = 0; i < operands.size(); ++i) {
            operandsArray[i] = (Long)operands.get(i);
        }
        return new Instruction(address, op, operandsArray);
    }

    private static Instruction[] parseExpression(ByteBuffer buffer) {
        Instruction i;
        ArrayList<Instruction> expr = new ArrayList<Instruction>();
        while ((i = Parser.parseInstruction(buffer)).opcode() != OpCode.END) {
            expr.add(i);
        }
        return expr.toArray(new Instruction[0]);
    }

    public static long readVarUInt32(ByteBuffer buffer) {
        return Encoding.readUnsignedLeb128(buffer);
    }

    public static long readVarSInt32(ByteBuffer buffer) {
        return Encoding.readSigned32Leb128(buffer);
    }

    public static long readVarSInt64(ByteBuffer buffer) {
        return Encoding.readSigned64Leb128(buffer);
    }

    public static long readFloat64(ByteBuffer buffer) {
        return buffer.getLong();
    }

    public static long readFloat32(ByteBuffer buffer) {
        return buffer.getInt();
    }

    public static String readName(ByteBuffer buffer) {
        int length = (int)Parser.readVarUInt32(buffer);
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

