/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

import com.dylibso.chicory.wasm.types.BlockType;
import com.dylibso.chicory.wasm.types.CodeBlock;
import com.dylibso.chicory.wasm.types.Instruction;
import java.util.ArrayDeque;

public class Ast {
    private final CodeBlock root = new CodeBlock(BlockType.BLOCK);
    private final ArrayDeque<CodeBlock> stack = new ArrayDeque();

    public Ast() {
        this.stack.push(this.root);
    }

    public CodeBlock root() {
        return this.root;
    }

    public void addInstruction(Instruction i) {
        CodeBlock current = this.peek();
        switch (i.opcode()) {
            case BLOCK: {
                current.addInstruction(i);
                CodeBlock next = new CodeBlock(BlockType.BLOCK);
                i.setCodeBlock(next);
                this.push(next);
                break;
            }
            case LOOP: {
                current.addInstruction(i);
                CodeBlock next = new CodeBlock(BlockType.LOOP);
                i.setCodeBlock(next);
                this.push(next);
                break;
            }
            case END: {
                current.addInstruction(i);
                this.pop();
                break;
            }
            default: {
                current.addInstruction(i);
            }
        }
    }

    private void push(CodeBlock block) {
        this.stack.push(block);
    }

    private CodeBlock peek() {
        return this.stack.peek();
    }

    private void pop() {
        this.stack.pop();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.printAst(sb, this.root, 0);
        return sb.toString();
    }

    private void printAst(StringBuilder sb, CodeBlock block, int depth) {
        for (Instruction i : block.instructions()) {
            sb.append("0x");
            sb.append(Integer.toHexString(i.address()));
            sb.append(" | ");
            sb.append("\t".repeat(depth));
            sb.append(i);
            sb.append("\n");
            if (i.codeBlock() == null) continue;
            this.printAst(sb, i.codeBlock(), depth + 1);
        }
    }
}

