/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

import com.dylibso.chicory.wasm.types.ValueType;
import java.util.Arrays;

public class FunctionType {
    private ValueType[] params;
    private ValueType[] returns;

    public FunctionType(ValueType[] params, ValueType[] returns) {
        this.params = params;
        this.returns = returns;
    }

    public ValueType[] params() {
        return this.params;
    }

    public ValueType[] returns() {
        return this.returns;
    }

    public boolean paramsMatch(FunctionType other) {
        return Arrays.equals((Object[])this.params, (Object[])other.params);
    }

    public boolean returnsMatch(FunctionType other) {
        return Arrays.equals((Object[])this.returns, (Object[])other.returns);
    }

    public boolean typesMatch(FunctionType other) {
        return this.paramsMatch(other) && this.returnsMatch(other);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        int nParams = this.params.length;
        for (int i = 0; i < nParams; ++i) {
            builder.append(this.params[i].toString());
            if (i >= nParams - 1) continue;
            builder.append(',');
        }
        builder.append(") -> ");
        int nReturns = this.returns.length;
        if (nReturns == 0) {
            builder.append("nil");
        } else {
            for (int i = 0; i < nReturns; ++i) {
                builder.append(this.returns[i].toString());
                if (i >= nReturns - 1) continue;
                builder.append(',');
            }
        }
        return builder.toString();
    }
}

