/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm;

import com.dylibso.chicory.wasm.InvalidException;
import com.dylibso.chicory.wasm.MalformedException;
import com.dylibso.chicory.wasm.Module;
import com.dylibso.chicory.wasm.types.ActiveDataSegment;
import com.dylibso.chicory.wasm.types.ActiveElement;
import com.dylibso.chicory.wasm.types.AnnotatedInstruction;
import com.dylibso.chicory.wasm.types.DataSegment;
import com.dylibso.chicory.wasm.types.DeclarativeElement;
import com.dylibso.chicory.wasm.types.Element;
import com.dylibso.chicory.wasm.types.ExternalType;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionImport;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Global;
import com.dylibso.chicory.wasm.types.GlobalImport;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.MutabilityType;
import com.dylibso.chicory.wasm.types.OpCode;
import com.dylibso.chicory.wasm.types.TableImport;
import com.dylibso.chicory.wasm.types.ValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class Validator {
    private final List<ValueType> valueTypeStack = new ArrayList<ValueType>();
    private final List<CtrlFrame> ctrlFrameStack = new ArrayList<CtrlFrame>();
    private final List<InvalidException> errors = new ArrayList<InvalidException>();
    private final Module module;
    private final List<Global> globalImports;
    private final List<Integer> functionImports;
    private final List<ValueType> tableImports;
    private final int memoryImports;
    private final Set<Integer> declaredFunctions;

    private static boolean isNum(ValueType t) {
        return t.isNumeric() || t == ValueType.UNKNOWN;
    }

    private static boolean isRef(ValueType t) {
        return t.isReference() || t == ValueType.UNKNOWN;
    }

    Validator(Module module) {
        this.module = Objects.requireNonNull(module);
        this.globalImports = module.importSection().stream().filter(GlobalImport.class::isInstance).map(GlobalImport.class::cast).map(i -> new Global(i.type(), i.mutabilityType(), List.of())).collect(Collectors.toList());
        this.functionImports = module.importSection().stream().filter(FunctionImport.class::isInstance).map(FunctionImport.class::cast).map(FunctionImport::typeIndex).collect(Collectors.toList());
        this.tableImports = module.importSection().stream().filter(TableImport.class::isInstance).map(TableImport.class::cast).map(TableImport::entryType).collect(Collectors.toList());
        this.memoryImports = module.importSection().count(ExternalType.MEMORY);
        this.declaredFunctions = module.elementSection().stream().filter(DeclarativeElement.class::isInstance).flatMap(element -> element.initializers().stream()).flatMap(this::declaredFunctions).collect(Collectors.toSet());
    }

    private Stream<Integer> declaredFunctions(List<Instruction> init) {
        if (!init.isEmpty() && init.get(0).opcode() == OpCode.REF_FUNC) {
            int idx = (int)init.get(0).operand(0);
            this.getFunctionType(idx);
            if (idx >= this.functionImports.size()) {
                return Stream.of(Integer.valueOf(idx));
            }
        }
        return Stream.empty();
    }

    private void pushVal(ValueType valType) {
        this.valueTypeStack.add(valType);
    }

    private ValueType popVal() {
        CtrlFrame frame = this.peekCtrl();
        if (this.valueTypeStack.size() == frame.height && frame.unreachable) {
            return ValueType.UNKNOWN;
        }
        if (this.valueTypeStack.size() == frame.height) {
            this.errors.add(new InvalidException("type mismatch, popVal(), stack reached limit at " + frame.height));
            return ValueType.UNKNOWN;
        }
        return this.valueTypeStack.remove(this.valueTypeStack.size() - 1);
    }

    private ValueType popVal(ValueType expected) {
        ValueType actual = this.popVal();
        if (actual != expected && actual != ValueType.UNKNOWN && expected != ValueType.UNKNOWN) {
            this.errors.add(new InvalidException("type mismatch, popVal(expected), expected: " + expected + " but got: " + actual));
        }
        return actual;
    }

    private void pushVals(List<ValueType> valTypes) {
        for (ValueType t : valTypes) {
            this.pushVal(t);
        }
    }

    private List<ValueType> popVals(List<ValueType> valTypes) {
        ValueType[] popped = new ValueType[valTypes.size()];
        for (int i = 0; i < valTypes.size(); ++i) {
            popped[i] = this.popVal(valTypes.get(valTypes.size() - 1 - i));
        }
        return Arrays.asList(popped);
    }

    private void pushCtrl(OpCode opCode, List<ValueType> in, List<ValueType> out) {
        CtrlFrame frame = new CtrlFrame(opCode, in, out, this.valueTypeStack.size(), false, false);
        this.pushCtrl(frame);
        this.pushVals(in);
    }

    private void pushCtrl(CtrlFrame frame) {
        this.ctrlFrameStack.add(frame);
    }

    private CtrlFrame popCtrl() {
        if (this.ctrlFrameStack.isEmpty()) {
            this.errors.add(new InvalidException("type mismatch, control frame stack empty"));
        }
        CtrlFrame frame = this.peekCtrl();
        this.popVals(frame.endTypes);
        if (this.valueTypeStack.size() != frame.height) {
            this.errors.add(new InvalidException("type mismatch, mismatching stack height, invalid result arity"));
        }
        this.ctrlFrameStack.remove(this.ctrlFrameStack.size() - 1);
        return frame;
    }

    private CtrlFrame peekCtrl() {
        return this.ctrlFrameStack.get(this.ctrlFrameStack.size() - 1);
    }

    private CtrlFrame getCtrl(int n) {
        return this.ctrlFrameStack.get(this.ctrlFrameStack.size() - 1 - n);
    }

    private static List<ValueType> labelTypes(CtrlFrame frame) {
        return frame.opCode == OpCode.LOOP ? frame.startTypes : frame.endTypes;
    }

    private void resetAtStackLimit() {
        CtrlFrame frame = this.peekCtrl();
        while (this.valueTypeStack.size() > frame.height) {
            this.valueTypeStack.remove(this.valueTypeStack.size() - 1);
        }
    }

    private void unreachable() {
        CtrlFrame frame = this.peekCtrl();
        this.resetAtStackLimit();
        frame.unreachable = true;
    }

    private void validateMemory(int id) {
        if (this.module.memorySection().isEmpty() && this.memoryImports == 0 || id != 0) {
            throw new InvalidException("unknown memory " + id);
        }
    }

    private void validateDataSegment(int idx) {
        if (idx < 0 || idx >= this.module.dataSection().dataSegmentCount()) {
            throw new InvalidException("unknown data segment " + idx);
        }
    }

    private List<ValueType> getReturns(AnnotatedInstruction op) {
        int typeId = (int)op.operand(0);
        if (typeId == 64) {
            return List.of();
        }
        if (ValueType.isValid(typeId)) {
            return List.of(ValueType.forId(typeId));
        }
        return this.getType(typeId).returns();
    }

    private List<ValueType> getParams(AnnotatedInstruction op) {
        int typeId = (int)op.operand(0);
        if (typeId == 64) {
            return List.of();
        }
        if (ValueType.isValid(typeId)) {
            return List.of();
        }
        if (typeId >= this.module.typeSection().typeCount()) {
            throw new MalformedException("unexpected end");
        }
        return this.getType(typeId).params();
    }

    private static ValueType getLocalType(List<ValueType> localTypes, int idx) {
        if (idx >= localTypes.size()) {
            throw new InvalidException("unknown local " + idx);
        }
        return localTypes.get(idx);
    }

    private FunctionType getType(int idx) {
        if (idx < 0 || idx >= this.module.typeSection().typeCount()) {
            throw new InvalidException("unknown type " + idx);
        }
        return this.module.typeSection().getType(idx);
    }

    private Global getGlobal(int idx) {
        if (idx < 0 || idx >= this.globalImports.size() + this.module.globalSection().globalCount()) {
            throw new InvalidException("unknown global " + idx);
        }
        if (idx < this.globalImports.size()) {
            return this.globalImports.get(idx);
        }
        return this.module.globalSection().getGlobal(idx - this.globalImports.size());
    }

    private int getFunctionType(int idx) {
        if (idx < 0 || idx >= this.functionImports.size() + this.module.functionSection().functionCount()) {
            throw new InvalidException("unknown function " + idx);
        }
        if (idx < this.functionImports.size()) {
            return this.functionImports.get(idx);
        }
        return this.module.functionSection().getFunctionType(idx - this.functionImports.size());
    }

    private ValueType getTableType(int idx) {
        if (idx < 0 || idx >= this.tableImports.size() + this.module.tableSection().tableCount()) {
            throw new InvalidException("unknown table " + idx);
        }
        if (idx < this.tableImports.size()) {
            return this.tableImports.get(idx);
        }
        return this.module.tableSection().getTable(idx - this.tableImports.size()).elementType();
    }

    private Element getElement(int idx) {
        if (idx < 0 || idx >= this.module.elementSection().elementCount()) {
            throw new InvalidException("unknown elem segment " + idx);
        }
        return this.module.elementSection().getElement(idx);
    }

    void validateModule() {
        if (this.module.functionSection().functionCount() != this.module.codeSection().functionBodyCount()) {
            throw new MalformedException("function and code section have inconsistent lengths");
        }
        if (this.module.dataCountSection().map(dcs -> dcs.dataCount() != this.module.dataSection().dataSegmentCount()).orElse(false).booleanValue()) {
            throw new MalformedException("data count and data section have inconsistent lengths");
        }
        if (this.module.startSection().isPresent()) {
            long index = this.module.startSection().get().startIndex();
            if (index < 0L || index > Integer.MAX_VALUE) {
                throw new InvalidException("unknown function " + index);
            }
            FunctionType type = this.getType(this.getFunctionType((int)index));
            if (!type.params().isEmpty() || !type.returns().isEmpty()) {
                throw new InvalidException("invalid start function, must have empty signature " + type);
            }
        }
    }

    void validateData() {
        for (DataSegment ds : this.module.dataSection().dataSegments()) {
            if (!(ds instanceof ActiveDataSegment)) continue;
            ActiveDataSegment ads = (ActiveDataSegment)ds;
            if (ads.index() != 0L) {
                throw new InvalidException("unknown memory " + ads.index());
            }
            this.validateConstantExpression(ads.offsetInstructions(), ValueType.I32);
        }
    }

    void validateElements() {
        for (Element el : this.module.elementSection().elements()) {
            if (el instanceof ActiveElement) {
                ActiveElement ae = (ActiveElement)el;
                this.validateConstantExpression(ae.offset(), ValueType.I32);
                for (int i = 0; i < ae.initializers().size(); ++i) {
                    List<Instruction> initializers = ae.initializers().get(i);
                    if (initializers.stream().filter(x -> x.opcode() != OpCode.END).count() != 1L) {
                        throw new InvalidException("type mismatch, constant expression required");
                    }
                    this.validateConstantExpression(ae.initializers().get(i), this.getTableType(ae.tableIndex()));
                }
                continue;
            }
            if (!(el instanceof DeclarativeElement)) continue;
            for (List<Instruction> init : el.initializers()) {
                if (init.stream().filter(x -> x.opcode() != OpCode.END).count() == 1L) continue;
                throw new InvalidException("type mismatch, constant expression required");
            }
        }
    }

    void validateGlobals() {
        for (Global g : this.module.globalSection().globals()) {
            this.validateConstantExpression(g.initInstructions(), g.valueType());
            if (g.mutabilityType() != MutabilityType.Const || g.initInstructions().size() <= 1) continue;
            throw new InvalidException("constant expression required");
        }
    }

    private void validateConstantExpression(List<? extends Instruction> expr, ValueType expectedType) {
        int allFuncCount = this.functionImports.size() + this.module.functionSection().functionCount();
        int constInstrCount = 0;
        for (Instruction instruction : expr) {
            ValueType exprType = null;
            switch (instruction.opcode()) {
                case I32_CONST: {
                    exprType = ValueType.I32;
                    ++constInstrCount;
                    break;
                }
                case I64_CONST: {
                    exprType = ValueType.I64;
                    ++constInstrCount;
                    break;
                }
                case F32_CONST: {
                    exprType = ValueType.F32;
                    ++constInstrCount;
                    break;
                }
                case F64_CONST: {
                    exprType = ValueType.F64;
                    ++constInstrCount;
                    break;
                }
                case REF_NULL: {
                    exprType = ValueType.refTypeForId((int)instruction.operand(0));
                    ++constInstrCount;
                    if (exprType == ValueType.ExternRef || exprType == ValueType.FuncRef) break;
                    throw new IllegalStateException("Unexpected wrong type for ref.null instruction");
                }
                case REF_FUNC: {
                    exprType = ValueType.FuncRef;
                    ++constInstrCount;
                    long idx = instruction.operand(0);
                    if (idx >= 0L && idx <= (long)allFuncCount) break;
                    throw new InvalidException("unknown function " + idx);
                }
                case GLOBAL_GET: {
                    Global global;
                    int idx = (int)instruction.operand(0);
                    if (idx < this.globalImports.size()) {
                        global = this.globalImports.get(idx);
                        if (global.mutabilityType() != MutabilityType.Const) {
                            throw new InvalidException("constant expression required, initializer expression cannot reference a mutable global");
                        }
                    } else {
                        throw new InvalidException("unknown global " + idx + ", initializer expression can only reference an imported global");
                    }
                    exprType = global.valueType();
                    ++constInstrCount;
                    break;
                }
                case END: {
                    break;
                }
                default: {
                    throw new InvalidException("constant expression required, but non-constant instruction encountered: " + instruction);
                }
            }
            if (exprType != null && exprType != expectedType) {
                throw new InvalidException("type mismatch");
            }
            if (constInstrCount <= 1) continue;
            throw new InvalidException("type mismatch, multiple constant expressions found");
        }
        if (constInstrCount <= 0) {
            throw new InvalidException("type mismatch, no constant expressions found");
        }
    }

    void validateFunctions() {
        for (int i = 0; i < this.module.codeSection().functionBodyCount(); ++i) {
            FunctionBody body = this.module.codeSection().getFunctionBody(i);
            int idx = this.functionImports.size() + i;
            FunctionType type = this.getType(this.getFunctionType(idx));
            this.validateFunction(idx, body, type);
        }
    }

    void validateFunction(int funcIdx, FunctionBody body, FunctionType functionType) {
        List<ValueType> localTypes = body.localTypes();
        int inputLen = functionType.params().size();
        this.pushCtrl(null, new ArrayList<ValueType>(), functionType.returns());
        block82: for (int i = 0; i < body.instructions().size(); ++i) {
            Object t2;
            AnnotatedInstruction op = body.instructions().get(i);
            switch (op.opcode()) {
                case UNREACHABLE: {
                    this.unreachable();
                    break;
                }
                case IF: {
                    this.popVal(ValueType.I32);
                }
                case LOOP: 
                case BLOCK: {
                    List<ValueType> t1 = this.getParams(op);
                    t2 = this.getReturns(op);
                    this.popVals(t1);
                    this.pushCtrl(op.opcode(), t1, (List<ValueType>)t2);
                    break;
                }
                case END: {
                    CtrlFrame frame = this.popCtrl();
                    if (frame.opCode == OpCode.IF && !frame.hasElse && frame.startTypes.size() != frame.endTypes.size()) {
                        throw new InvalidException("type mismatch, unbalanced if branches");
                    }
                    this.pushVals(frame.endTypes);
                    break;
                }
                case ELSE: {
                    CtrlFrame frame = this.popCtrl();
                    if (frame.opCode != OpCode.IF) {
                        throw new InvalidException("else doesn't belong to if");
                    }
                    this.pushCtrl(op.opcode(), frame.startTypes, frame.endTypes);
                    this.peekCtrl().hasElse = true;
                    break;
                }
                case BR: {
                    int n = (int)op.operand(0);
                    this.popVals(Validator.labelTypes(this.getCtrl(n)));
                    this.unreachable();
                    break;
                }
                case BR_IF: {
                    this.popVal(ValueType.I32);
                    int n = (int)op.operand(0);
                    List<ValueType> labelTypes = Validator.labelTypes(this.getCtrl(n));
                    this.popVals(labelTypes);
                    this.pushVals(labelTypes);
                    break;
                }
                case BR_TABLE: {
                    this.popVal(ValueType.I32);
                    int m = (int)op.operand(op.operandCount() - 1);
                    if (this.ctrlFrameStack.size() - 1 - m < 0) {
                        throw new InvalidException("unknown label " + m);
                    }
                    List<ValueType> defaultBranchLabelTypes = Validator.labelTypes(this.getCtrl(m));
                    int arity = defaultBranchLabelTypes.size();
                    for (int idx = 0; idx < op.operandCount() - 1; ++idx) {
                        CtrlFrame ctrlFrame;
                        int n = (int)op.operand(idx);
                        try {
                            ctrlFrame = this.getCtrl(n);
                        }
                        catch (IndexOutOfBoundsException e) {
                            throw new InvalidException("unknown label", e);
                        }
                        List<ValueType> labelTypes = Validator.labelTypes(ctrlFrame);
                        if (!ctrlFrame.unreachable) {
                            if (labelTypes.size() != arity) {
                                throw new InvalidException("type mismatch, mismatched arity in BR_TABLE for label " + n);
                            }
                            for (int t = 0; t < arity; ++t) {
                                if (labelTypes.get(t) == defaultBranchLabelTypes.get(t)) continue;
                                throw new InvalidException("type mismatch, br_table labels have inconsistent types: expected: " + (Object)((Object)defaultBranchLabelTypes.get(t)) + ", got: " + (Object)((Object)labelTypes.get(t)));
                            }
                        }
                        this.pushVals(this.popVals(labelTypes));
                    }
                    ArrayList<ValueType> reversed = new ArrayList<ValueType>(defaultBranchLabelTypes);
                    Collections.reverse(reversed);
                    this.popVals(reversed);
                    this.unreachable();
                    break;
                }
                case RETURN: {
                    this.popVals(Validator.labelTypes(this.ctrlFrameStack.get(0)));
                    this.unreachable();
                    break;
                }
            }
            switch (op.opcode()) {
                case MEMORY_COPY: {
                    this.validateMemory((int)op.operand(0));
                    this.validateMemory((int)op.operand(1));
                    break;
                }
                case MEMORY_FILL: {
                    this.validateMemory((int)op.operand(0));
                    break;
                }
                case MEMORY_INIT: {
                    this.validateMemory((int)op.operand(1));
                    this.validateDataSegment((int)op.operand(0));
                    break;
                }
                case MEMORY_SIZE: 
                case MEMORY_GROW: 
                case I32_LOAD: 
                case I32_LOAD8_U: 
                case I32_LOAD8_S: 
                case I32_LOAD16_U: 
                case I32_LOAD16_S: 
                case I64_LOAD: 
                case I64_LOAD8_S: 
                case I64_LOAD8_U: 
                case I64_LOAD16_S: 
                case I64_LOAD16_U: 
                case I64_LOAD32_S: 
                case I64_LOAD32_U: 
                case F32_LOAD: 
                case F64_LOAD: 
                case I32_STORE: 
                case I32_STORE8: 
                case I32_STORE16: 
                case I64_STORE: 
                case I64_STORE8: 
                case I64_STORE16: 
                case I64_STORE32: 
                case F32_STORE: 
                case F64_STORE: {
                    this.validateMemory(0);
                    break;
                }
            }
            switch (op.opcode()) {
                case END: 
                case UNREACHABLE: 
                case IF: 
                case LOOP: 
                case BLOCK: 
                case ELSE: 
                case BR: 
                case BR_IF: 
                case BR_TABLE: 
                case RETURN: 
                case NOP: {
                    continue block82;
                }
                case DATA_DROP: {
                    this.validateDataSegment((int)op.operand(0));
                    continue block82;
                }
                case DROP: {
                    this.popVal();
                    continue block82;
                }
                case I32_STORE: 
                case I32_STORE8: 
                case I32_STORE16: {
                    this.popVal(ValueType.I32);
                    this.popVal(ValueType.I32);
                    continue block82;
                }
                case MEMORY_GROW: 
                case I32_LOAD: 
                case I32_LOAD8_U: 
                case I32_LOAD8_S: 
                case I32_LOAD16_U: 
                case I32_LOAD16_S: 
                case I32_CLZ: 
                case I32_CTZ: 
                case I32_POPCNT: 
                case I32_EXTEND_8_S: 
                case I32_EXTEND_16_S: 
                case I32_EQZ: {
                    this.popVal(ValueType.I32);
                    this.pushVal(ValueType.I32);
                    continue block82;
                }
                case I32_CONST: 
                case MEMORY_SIZE: 
                case TABLE_SIZE: {
                    this.pushVal(ValueType.I32);
                    continue block82;
                }
                case I32_ADD: 
                case I32_SUB: 
                case I32_MUL: 
                case I32_DIV_S: 
                case I32_DIV_U: 
                case I32_REM_S: 
                case I32_REM_U: 
                case I32_AND: 
                case I32_OR: 
                case I32_XOR: 
                case I32_EQ: 
                case I32_NE: 
                case I32_LT_S: 
                case I32_LT_U: 
                case I32_LE_S: 
                case I32_LE_U: 
                case I32_GT_S: 
                case I32_GT_U: 
                case I32_GE_S: 
                case I32_GE_U: 
                case I32_SHL: 
                case I32_SHR_U: 
                case I32_SHR_S: 
                case I32_ROTL: 
                case I32_ROTR: {
                    this.popVal(ValueType.I32);
                    this.popVal(ValueType.I32);
                    this.pushVal(ValueType.I32);
                    continue block82;
                }
                case I32_WRAP_I64: 
                case I64_EQZ: {
                    this.popVal(ValueType.I64);
                    this.pushVal(ValueType.I32);
                    continue block82;
                }
                case I32_TRUNC_F32_S: 
                case I32_TRUNC_F32_U: 
                case I32_TRUNC_SAT_F32_S: 
                case I32_TRUNC_SAT_F32_U: 
                case I32_REINTERPRET_F32: {
                    this.popVal(ValueType.F32);
                    this.pushVal(ValueType.I32);
                    continue block82;
                }
                case I32_TRUNC_F64_S: 
                case I32_TRUNC_F64_U: 
                case I32_TRUNC_SAT_F64_S: 
                case I32_TRUNC_SAT_F64_U: {
                    this.popVal(ValueType.F64);
                    this.pushVal(ValueType.I32);
                    continue block82;
                }
                case I64_LOAD: 
                case I64_LOAD8_S: 
                case I64_LOAD8_U: 
                case I64_LOAD16_S: 
                case I64_LOAD16_U: 
                case I64_LOAD32_S: 
                case I64_LOAD32_U: 
                case I64_EXTEND_I32_U: 
                case I64_EXTEND_I32_S: {
                    this.popVal(ValueType.I32);
                    this.pushVal(ValueType.I64);
                    continue block82;
                }
                case I64_CONST: {
                    this.pushVal(ValueType.I64);
                    continue block82;
                }
                case I64_STORE: 
                case I64_STORE8: 
                case I64_STORE16: 
                case I64_STORE32: {
                    this.popVal(ValueType.I64);
                    this.popVal(ValueType.I32);
                    continue block82;
                }
                case I64_ADD: 
                case I64_SUB: 
                case I64_MUL: 
                case I64_DIV_S: 
                case I64_DIV_U: 
                case I64_REM_S: 
                case I64_REM_U: 
                case I64_AND: 
                case I64_OR: 
                case I64_XOR: 
                case I64_SHL: 
                case I64_SHR_U: 
                case I64_SHR_S: 
                case I64_ROTL: 
                case I64_ROTR: {
                    this.popVal(ValueType.I64);
                    this.popVal(ValueType.I64);
                    this.pushVal(ValueType.I64);
                    continue block82;
                }
                case I64_EQ: 
                case I64_NE: 
                case I64_LT_S: 
                case I64_LT_U: 
                case I64_LE_S: 
                case I64_LE_U: 
                case I64_GT_S: 
                case I64_GT_U: 
                case I64_GE_S: 
                case I64_GE_U: {
                    this.popVal(ValueType.I64);
                    this.popVal(ValueType.I64);
                    this.pushVal(ValueType.I32);
                    continue block82;
                }
                case I64_CLZ: 
                case I64_CTZ: 
                case I64_POPCNT: 
                case I64_EXTEND_8_S: 
                case I64_EXTEND_16_S: 
                case I64_EXTEND_32_S: {
                    this.popVal(ValueType.I64);
                    this.pushVal(ValueType.I64);
                    continue block82;
                }
                case I64_REINTERPRET_F64: 
                case I64_TRUNC_F64_S: 
                case I64_TRUNC_F64_U: 
                case I64_TRUNC_SAT_F64_S: 
                case I64_TRUNC_SAT_F64_U: {
                    this.popVal(ValueType.F64);
                    this.pushVal(ValueType.I64);
                    continue block82;
                }
                case I64_TRUNC_F32_S: 
                case I64_TRUNC_F32_U: 
                case I64_TRUNC_SAT_F32_S: 
                case I64_TRUNC_SAT_F32_U: {
                    this.popVal(ValueType.F32);
                    this.pushVal(ValueType.I64);
                    continue block82;
                }
                case F32_STORE: {
                    this.popVal(ValueType.F32);
                    this.popVal(ValueType.I32);
                    continue block82;
                }
                case F32_CONST: {
                    this.pushVal(ValueType.F32);
                    continue block82;
                }
                case F32_LOAD: 
                case F32_CONVERT_I32_S: 
                case F32_CONVERT_I32_U: 
                case F32_REINTERPRET_I32: {
                    this.popVal(ValueType.I32);
                    this.pushVal(ValueType.F32);
                    continue block82;
                }
                case F32_CONVERT_I64_S: 
                case F32_CONVERT_I64_U: {
                    this.popVal(ValueType.I64);
                    this.pushVal(ValueType.F32);
                    continue block82;
                }
                case F64_LOAD: 
                case F64_CONVERT_I32_S: 
                case F64_CONVERT_I32_U: {
                    this.popVal(ValueType.I32);
                    this.pushVal(ValueType.F64);
                    continue block82;
                }
                case F64_CONVERT_I64_S: 
                case F64_CONVERT_I64_U: 
                case F64_REINTERPRET_I64: {
                    this.popVal(ValueType.I64);
                    this.pushVal(ValueType.F64);
                    continue block82;
                }
                case F64_PROMOTE_F32: {
                    this.popVal(ValueType.F32);
                    this.pushVal(ValueType.F64);
                    continue block82;
                }
                case F32_DEMOTE_F64: {
                    this.popVal(ValueType.F64);
                    this.pushVal(ValueType.F32);
                    continue block82;
                }
                case F32_SQRT: 
                case F32_ABS: 
                case F32_NEG: 
                case F32_CEIL: 
                case F32_FLOOR: 
                case F32_TRUNC: 
                case F32_NEAREST: {
                    this.popVal(ValueType.F32);
                    this.pushVal(ValueType.F32);
                    continue block82;
                }
                case F32_ADD: 
                case F32_SUB: 
                case F32_MUL: 
                case F32_DIV: 
                case F32_MIN: 
                case F32_MAX: 
                case F32_COPYSIGN: {
                    this.popVal(ValueType.F32);
                    this.popVal(ValueType.F32);
                    this.pushVal(ValueType.F32);
                    continue block82;
                }
                case F32_EQ: 
                case F32_NE: 
                case F32_LT: 
                case F32_LE: 
                case F32_GT: 
                case F32_GE: {
                    this.popVal(ValueType.F32);
                    this.popVal(ValueType.F32);
                    this.pushVal(ValueType.I32);
                    continue block82;
                }
                case F64_STORE: {
                    this.popVal(ValueType.F64);
                    this.popVal(ValueType.I32);
                    continue block82;
                }
                case F64_CONST: {
                    this.pushVal(ValueType.F64);
                    continue block82;
                }
                case F64_SQRT: 
                case F64_ABS: 
                case F64_NEG: 
                case F64_CEIL: 
                case F64_FLOOR: 
                case F64_TRUNC: 
                case F64_NEAREST: {
                    this.popVal(ValueType.F64);
                    this.pushVal(ValueType.F64);
                    continue block82;
                }
                case F64_ADD: 
                case F64_SUB: 
                case F64_MUL: 
                case F64_DIV: 
                case F64_MIN: 
                case F64_MAX: 
                case F64_COPYSIGN: {
                    this.popVal(ValueType.F64);
                    this.popVal(ValueType.F64);
                    this.pushVal(ValueType.F64);
                    continue block82;
                }
                case F64_EQ: 
                case F64_NE: 
                case F64_LT: 
                case F64_LE: 
                case F64_GT: 
                case F64_GE: {
                    this.popVal(ValueType.F64);
                    this.popVal(ValueType.F64);
                    this.pushVal(ValueType.I32);
                    continue block82;
                }
                case LOCAL_SET: {
                    int index = (int)op.operand(0);
                    ValueType expectedType = index < inputLen ? functionType.params().get(index) : Validator.getLocalType(localTypes, index - inputLen);
                    this.popVal(expectedType);
                    continue block82;
                }
                case LOCAL_GET: {
                    int index = (int)op.operand(0);
                    ValueType expectedType = index < inputLen ? functionType.params().get(index) : Validator.getLocalType(localTypes, index - inputLen);
                    this.pushVal(expectedType);
                    continue block82;
                }
                case LOCAL_TEE: {
                    int index = (int)op.operand(0);
                    ValueType expectedType = index < inputLen ? functionType.params().get(index) : Validator.getLocalType(localTypes, index - inputLen);
                    this.popVal(expectedType);
                    this.pushVal(expectedType);
                    continue block82;
                }
                case GLOBAL_GET: {
                    Global global = this.getGlobal((int)op.operand(0));
                    this.pushVal(global.valueType());
                    continue block82;
                }
                case GLOBAL_SET: {
                    Global global = this.getGlobal((int)op.operand(0));
                    if (global.mutabilityType() == MutabilityType.Const) {
                        throw new InvalidException("global is immutable");
                    }
                    this.popVal(global.valueType());
                    continue block82;
                }
                case CALL: {
                    int j;
                    int typeId = this.getFunctionType((int)op.operand(0));
                    FunctionType types = this.getType(typeId);
                    for (j = types.params().size() - 1; j >= 0; --j) {
                        this.popVal(types.params().get(j));
                    }
                    this.pushVals(types.returns());
                    continue block82;
                }
                case CALL_INDIRECT: {
                    int j;
                    int typeId = (int)op.operand(0);
                    this.popVal(ValueType.I32);
                    this.getTableType((int)op.operand(1));
                    FunctionType types = this.getType(typeId);
                    for (j = types.params().size() - 1; j >= 0; --j) {
                        this.popVal(types.params().get(j));
                    }
                    this.pushVals(types.returns());
                    continue block82;
                }
                case REF_NULL: {
                    this.pushVal(ValueType.forId((int)op.operand(0)));
                    continue block82;
                }
                case REF_IS_NULL: {
                    ValueType ref = this.popVal();
                    if (!Validator.isRef(ref)) {
                        throw new InvalidException("type mismatch: expected FuncRef or ExtRef, but was " + ref);
                    }
                    this.pushVal(ValueType.I32);
                    continue block82;
                }
                case REF_FUNC: {
                    int idx = (int)op.operand(0);
                    if (idx == funcIdx && !this.declaredFunctions.contains(idx)) {
                        throw new InvalidException("undeclared function reference");
                    }
                    this.pushVal(ValueType.FuncRef);
                    continue block82;
                }
                case SELECT: {
                    this.popVal(ValueType.I32);
                    ValueType t1 = this.popVal();
                    t2 = this.popVal();
                    if (!Validator.isNum(t1) || !Validator.isNum(t2)) {
                        throw new InvalidException("type mismatch: select should have numeric arguments");
                    }
                    if (t1 != t2 && t1 != ValueType.UNKNOWN && t2 != ValueType.UNKNOWN) {
                        throw new InvalidException("type mismatch, in SELECT t1: " + t1 + ", t2: " + t2);
                    }
                    if (t1 == ValueType.UNKNOWN) {
                        this.pushVal((ValueType)((Object)t2));
                        continue block82;
                    }
                    this.pushVal(t1);
                    continue block82;
                }
                case SELECT_T: {
                    this.popVal(ValueType.I32);
                    ValueType t = ValueType.forId((int)op.operand(0));
                    this.popVal(t);
                    this.popVal(t);
                    this.pushVal(t);
                    continue block82;
                }
                case TABLE_COPY: {
                    ValueType table1 = this.getTableType((int)op.operand(1));
                    ValueType table2 = this.getTableType((int)op.operand(0));
                    if (table1 != table2) {
                        throw new InvalidException("type mismatch, table 1 type: " + table1 + ", table 2 type: " + table2);
                    }
                    this.popVal(ValueType.I32);
                    this.popVal(ValueType.I32);
                    this.popVal(ValueType.I32);
                    continue block82;
                }
                case TABLE_INIT: {
                    ValueType table = this.getTableType((int)op.operand(1));
                    int elemIdx = (int)op.operand(0);
                    Element elem = this.getElement(elemIdx);
                    if (table != elem.type()) {
                        throw new InvalidException("type mismatch, table type: " + table + ", elem type: " + elem.type());
                    }
                    this.popVal(ValueType.I32);
                    this.popVal(ValueType.I32);
                    this.popVal(ValueType.I32);
                    continue block82;
                }
                case MEMORY_COPY: 
                case MEMORY_FILL: 
                case MEMORY_INIT: {
                    this.popVal(ValueType.I32);
                    this.popVal(ValueType.I32);
                    this.popVal(ValueType.I32);
                    continue block82;
                }
                case TABLE_FILL: {
                    this.popVal(ValueType.I32);
                    this.popVal(this.getTableType((int)op.operand(0)));
                    this.popVal(ValueType.I32);
                    continue block82;
                }
                case TABLE_GET: {
                    this.popVal(ValueType.I32);
                    this.pushVal(this.getTableType((int)op.operand(0)));
                    continue block82;
                }
                case TABLE_SET: {
                    this.popVal(this.getTableType((int)op.operand(0)));
                    this.popVal(ValueType.I32);
                    continue block82;
                }
                case TABLE_GROW: {
                    this.popVal(ValueType.I32);
                    this.popVal(this.getTableType((int)op.operand(0)));
                    this.pushVal(ValueType.I32);
                    continue block82;
                }
                case ELEM_DROP: {
                    int index = (int)op.operand(0);
                    this.getElement(index);
                    continue block82;
                }
                case V128_LOAD: {
                    this.popVal(ValueType.I32);
                    this.pushVal(ValueType.V128);
                    continue block82;
                }
                case V128_CONST: {
                    this.pushVal(ValueType.V128);
                    continue block82;
                }
                case I8x16_ALL_TRUE: 
                case I8x16_EXTRACT_LANE_S: {
                    this.popVal(ValueType.V128);
                    this.pushVal(ValueType.I32);
                    continue block82;
                }
                case I8x16_EQ: 
                case I8x16_SUB: 
                case I8x16_ADD: 
                case I8x16_SWIZZLE: 
                case F32x4_MUL: 
                case F32x4_MIN: {
                    this.popVal(ValueType.V128);
                    this.popVal(ValueType.V128);
                    this.pushVal(ValueType.V128);
                    continue block82;
                }
                case F32x4_ABS: 
                case I32x4_TRUNC_SAT_F32X4_S: 
                case F32x4_CONVERT_I32x4_U: 
                case V128_NOT: {
                    this.popVal(ValueType.V128);
                    this.pushVal(ValueType.V128);
                    continue block82;
                }
                case V128_BITSELECT: {
                    this.popVal(ValueType.V128);
                    this.popVal(ValueType.V128);
                    this.popVal(ValueType.V128);
                    this.pushVal(ValueType.V128);
                    continue block82;
                }
                case I8x16_SHL: {
                    this.popVal(ValueType.I32);
                    this.popVal(ValueType.V128);
                    this.pushVal(ValueType.V128);
                    continue block82;
                }
                default: {
                    throw new IllegalArgumentException("Missing type validation opcode handling for " + op.opcode());
                }
            }
        }
        if (!this.errors.isEmpty()) {
            throw new InvalidException(this.errors.stream().map(Throwable::getMessage).collect(Collectors.joining(" - ")));
        }
        if (this.module.codeSection().isRequiresDataCount() && this.module.dataCountSection().isEmpty()) {
            throw new MalformedException("data count section required");
        }
    }

    private static class CtrlFrame {
        public final OpCode opCode;
        public final List<ValueType> startTypes;
        public final List<ValueType> endTypes;
        public final int height;
        public boolean unreachable;
        public boolean hasElse;

        public CtrlFrame(OpCode opCode, List<ValueType> startTypes, List<ValueType> endTypes, int height, boolean unreachable, boolean hasElse) {
            this.opCode = opCode;
            this.startTypes = startTypes;
            this.endTypes = endTypes;
            this.height = height;
            this.unreachable = unreachable;
            this.hasElse = hasElse;
        }
    }
}

